unlessIO :: Bool -> IO () -> IO ()
unlessIO test action | test      = return ()
                     | otherwise = action

mapIO :: (a -> b) -> IO a -> IO b
mapIO f acao = do x <- acao
                  return (f x)

replicateIO 0 _ = return []
replicateIO n acao | n > 0 = do x <- acao
                                xs <- replicateIO (n-1) acao
                                return (x:xs)
