module Main where

toDigitsRev :: Integer -> [Integer]
toDigitsRev n | n < 0     = []
              | n < 10    = [n]
              | otherwise = mod n 10 : toDigitsRev (div n 10)

toDigits :: Integer -> [Integer]
toDigits = reverse . toDigitsRev

doubleEveryOther :: [Integer] -> [Integer]
doubleEveryOther lista = reverse (doubleEveryOtherRev (reverse lista))

doubleEveryOtherRev :: [Integer] -> [Integer]
doubleEveryOtherRev [] = []
doubleEveryOtherRev [x] = [x]
doubleEveryOtherRev (x:y:resto) = x : 2*y : doubleEveryOtherRev resto

sumDigits :: [Integer] -> Integer
sumDigits [] = 0
sumDigits (x:xs) = div x 10 + mod x 10 + sumDigits xs

sumDigits' [] = 0
sumDigits' (x:xs) = (sum . toDigits) x + sumDigits' xs

sumDigits'' = sum . (map (sum . toDigits))

validate :: Integer -> Bool
validate n = sumDigits (doubleEveryOther (toDigits n)) `mod` 10 == 0

main :: IO ()
main = do putStrLn "Digite o número do cartão de crédito:"
          cartao <- readLn
          putStrLn (if validate cartao then "Válido!" else "Inválido!")
