module Main where

main :: IO ()
main =
  do putStrLn "Cálculo da média aritmética"
     putStrLn "-----------------------------------------------------"
     putStrLn "Digite uma sequência de números (um número por linha)"
     putStrLn "Para terminar digite um valor negativo"
     (tamanho, soma) <- leSerie (<0)
     if tamanho == 0
       then putStrLn "Sequência vazia"
       else let media = soma / fromIntegral tamanho
            in putStrLn ("A média dos números digitados é " ++ show media)
     
leSerie :: (Read a, Num a) => (a -> Bool) -> IO (Integer,a)
leSerie invalido =
  go 0 0
  where
    go q s = 
      do x <- readLn
         if invalido x
           then return (q, s)
           else go (q+1) (s+x)
