module Main where

main :: IO ()
main =
  do putStrLn "Cálculo da média aritmética"
     putStrLn "-----------------------------------------------------"
     putStrLn "Digite uma sequência de números (um número por linha)"
     putStrLn "Para terminar digite um valor negativo"
     sequencia <- leListaSentinela (<0)
     case sequencia of
       [] -> putStrLn "Sequência vazia"
       _  -> let media = sum sequencia / fromIntegral (length sequencia)
             in putStrLn ("A média dos números digitados é " ++ show media)
     
leListaSentinela :: (Read a) => (a -> Bool) -> IO [a]
leListaSentinela invalido =
  go []
  where
    go lista =
      do x <- readLn
         if invalido x
           then return (reverse lista)
           else go (x:lista)
