module Main where

main :: IO ()
main =
  do putStrLn "Cálculo da média aritmética"
     putStrLn "-----------------------------------------------------"
     putStrLn "Digite uma sequência de números (um número por linha)"
     putStrLn "Para terminar digite um valor negativo"
     sequencia <- leListaSentinela (<0)
     case sequencia of
       [] -> putStrLn "Sequência vazia"
       _  -> let media = sum sequencia / fromIntegral (length sequencia)
             in putStrLn ("A média dos números digitados é " ++ show media)
     
leListaSentinela :: (Read a) => (a -> Bool) -> IO [a]
leListaSentinela invalido =
  do x <- readLn
     if invalido x
       then return []
       else do resto <- leListaSentinela invalido
               return (x:resto)
