module Main where

main :: IO ()
main =
  do putStrLn "Cálculo da média aritmética"
     putStrLn "-----------------------------------------------------"
     putStrLn "Digite uma sequência de números (um número por linha)"
     putStrLn "Para terminar digite um valor negativo"
     sequencia <- leListaNum
     case sequencia of
       [] -> putStrLn "Sequência vazia"
       _  -> let media = sum sequencia / fromIntegral (length sequencia)
             in putStrLn ("A média dos números digitados é " ++ show media)

     
leListaNum :: (Read a, Num a, Ord a) => IO [a]
leListaNum = leListaNumAux []
  where
    leListaNumAux acumulados =
      do x <- readLn
         if x < 0
           then return (reverse acumulados)
           else leListaNumAux (x:acumulados)
