import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class TaxCalculator extends Application
{
   @Override
   public void start(Stage primaryStage) throws Exception
   {
      primaryStage.setTitle("JavaFX Tax Calculator");
      
      GridPane pane = new GridPane();
      pane.setAlignment(Pos.CENTER);
      pane.setHgap(10); // gap between controls
      pane.setVgap(10);
      pane.setPadding(new Insets(25, 25, 25, 25)); // padding (spaces around the edges of the pane
      //pane.setGridLinesVisible(true);
      
      Scene scene = new Scene(pane, 300, 275);
      primaryStage.setScene(scene);
      
      Text sceneTitle = new Text("Tax Calculator");
      sceneTitle.setFont(Font.font("Arial", FontWeight.NORMAL, 20));
      pane.add(sceneTitle, 0, 0, 2, 1);
      
      Label total = new Label("Income:");
      pane.add(total, 0, 1);
      TextField totalField = new TextField();
      pane.add(totalField, 1, 1);
      Label percent = new Label("% Tax:");
      pane.add(percent, 0, 2);
      TextField percentField = new TextField();
      pane.add(percentField, 1, 2);
      
      Button calculateButton = new Button("Calculate xxxxxxxxxxxxxxxxxxx");
      HBox hbox = new HBox(10);
      hbox.setAlignment(Pos.CENTER_RIGHT);
      hbox.getChildren().add(calculateButton);
      pane.add(hbox, 0, 4, 2, 1);
      
      final Text taxMessage = new Text();
      pane.add(taxMessage, 0, 6, 2, 1);
      
//      class MeuTratador implements EventHandler<ActionEvent>
//      {
//         @Override
//         public void handle(ActionEvent arg0)
//         {
//            System.out.println("Botão foi clicado!");
//         }
//      }
      
      //calculateButton.setOnAction(new MeuTratador());
      
//      calculateButton.setOnAction(new EventHandler<ActionEvent>() {
//         @Override
//         public void handle(ActionEvent arg0) {
//            Double income = Double.parseDouble(totalField.getText());
//            Double tax = Double.parseDouble(percentField.getText()) / 100;
//            taxMessage.setText("Tax incurred: " + income*tax);
//         }
//      });
      
      calculateButton.setOnAction(e -> {
            Double income = Double.parseDouble(totalField.getText());
            Double tax = Double.parseDouble(percentField.getText()) / 100;
            taxMessage.setText("Tax incurred: " + income*tax);
         }
      );
      
      primaryStage.show();
   }
   
   public static void main(String[] args)
   {
      launch(args);
   }
}
