import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

class MyHandler implements EventHandler<ActionEvent>
{
   @Override
   public void handle(ActionEvent ev)
   {
      System.out.println("Hello, world!");
   }  
}

public class HelloWorld extends Application
{
   public static void main(String[] args)
   {
      launch(args);
   }

   @Override
   public void start(Stage stage) throws Exception
   {
      stage.setTitle("Hello World from JavaFX");
      
      VBox box = new VBox(10);
      box.setAlignment(Pos.CENTER);
      
      Label label = new Label("I can say 'Hello World!'");
      box.getChildren().add(label);
      
      Button button = new Button("Say Hello");
      box.getChildren().add(button);
      button.setOnAction(new MyHandler());
      
      Button button2 = new Button("Diga Olá");
      box.getChildren().add(button2);
      button2.setOnAction(new EventHandler<ActionEvent>() {
         @Override
         public void handle(ActionEvent ev)
         {
            System.out.println("Olá, mundo!");
         }
      });
      
      Button button3 = new Button("Hola");
      box.getChildren().add(button3);
      button3.setOnAction(ev -> System.out.println("Hola!"));
      
      Scene scene = new Scene(box, 300, 200);
      
      stage.setScene(scene);
      
      stage.show();
   }

}
