package util;

import java.util.Scanner;
import java.util.function.Predicate;

public class Prompt
{
   public static int promptInt(Scanner keyboard, String msg, Predicate<Integer> val)
   {
      int x;
      while (true)
      {
         System.out.print(msg);
         if (keyboard.hasNextInt())
         {
            x = keyboard.nextInt();
            if (val.test(x))
            {
               keyboard.nextLine();
               break;
            }
         }
         System.out.println("Valor inválido.");
         keyboard.nextLine();
      }

      return x;
   }
   
   public static double promptDouble(Scanner keyboard, String msg, Predicate<Double> val)
   {
      double x;
      while (true)
      {
         System.out.print(msg);
         if (keyboard.hasNextDouble())
         {
            x = keyboard.nextDouble();
            if (val.test(x))
            {
               keyboard.nextLine();
               break;
            }
         }
         System.out.println("Valor inválido.");
         keyboard.nextLine();
      }

      return x;
   }
   
   
   public static String promptLine(Scanner teclado, String msg, Predicate<String> validate)
   {
      String x;
      while (true)
      {
         System.out.print(msg);
         x = teclado.nextLine();
         if (validate == null || validate.test(x))
            break;
         System.out.println("Valor inválido.");
      }
      return x;
   }
   
   public static String promptLine(Scanner teclado, String msg)
   {
      return promptLine(teclado, msg, null);
   }
   
}
