package util;
import java.util.Scanner;

public class Menu
{
   @SafeVarargs
   public static void menu(Scanner teclado, String title, MenuItem... itens)
   {
      while (true)
      {
         System.out.println(title);
         System.out.println("-------------------------------------");
         for (int i = 0; i < itens.length; i++)
            System.out.printf("%3d. %s\n", i + 1, itens[i].getLabel());
         System.out.printf("%3d. %s\n", 0, "Terminar");
         System.out.println("-------------------------------------");
         int opcao = Prompt.promptInt(teclado,
                                      "Digite uma opção: ",
                                      x -> x >= 0 && x <= itens.length);
         if (opcao == 0)
            break;
         else
            itens[opcao-1].getAction().accept(teclado);
         System.out.println();
         System.out.println();
         System.out.println("Digite ENTER para continuar.");
         if (teclado.hasNextLine()) teclado.nextLine();
         teclado.nextLine();
      }
   }
}
