package banco;

import java.io.Serializable;
import java.util.Date;

public class Movimento implements Serializable
{
   private final Date data;
   private final String descricao;
   private final double valor;
   private final double saldo;

   public Movimento(Date data, String descricao, double valor, double saldo)
   {
      this.data = data;
      this.descricao = descricao;
      this.valor = valor;
      this.saldo = saldo;
   }

   public Date getData()
   {
      return data;
   }

   public String getDescricao()
   {
      return descricao;
   }

   public double getValor()
   {
      return valor;
   }

   public double getSaldo()
   {
      return saldo;
   }

   @Override
   public String toString()
   {
      return String.format(
            "Movimento [data=%s, descricao=%s, valor=%s, saldo=%s]", data,
            descricao, valor, saldo);
   }
}
