package banco;

public class ContaEspecial extends Conta
{
   private double limite;

   public ContaEspecial(int numero, int titular, double saldo, double limite)
   {
      super(numero, titular, saldo);
      this.limite = limite;
   }

   public double getLimite()
   {
      return limite;
   }

   @Override
   public boolean saldoSuficiente(double valor)
   {
      return getSaldo() + limite >= valor;
   }

   @Override
   public String toString()
   {
      return String
            .format(
                  "ContaEspecial [limite=%s, getNumero()=%s, getTitular()=%s, getSaldo()=%s, getHistorico()=%s]",
                  limite, getNumero(), getTitular(), getSaldo(), getHistorico());
   }
   
   
}
