package banco;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Conta implements Serializable
{
   private int numero;
   private int titular;
   private double saldo;
   private List<Movimento> historico;
   
   public Conta(int numero, int titular, double saldo)
   {
      this.numero = numero;
      this.titular = titular;
      this.saldo = saldo;
      historico = new LinkedList<Movimento>();
      registra(new Date(), "Abertura", saldo);
   }

   public int getNumero()
   {
      return numero;
   }

   public int getTitular()
   {
      return titular;
   }

   public double getSaldo()
   {
      return saldo;
   }

   public List<Movimento> getHistorico()
   {
      return historico;
   }

   public void registra(Date data, String descricao, double valor)
   {
      historico.add(new Movimento(data, descricao, valor, saldo));
   }
 
   public void deposito(double valor) throws ValorInvalido
   {
      if (valor > 0)
      {
         saldo += valor;
         registra(new Date(), "Depósito", valor);
      }
      else
         throw new ValorInvalido();
   }
   
   public boolean saldoSuficiente(double valor)
   {
      return saldo >= valor;
   }
   
   public void saque(double valor) throws ValorInvalido
   {
      if (valor > 0)
         if (saldoSuficiente(valor))
         {
            saldo -= valor;
            registra(new Date(), "Saque", valor);
         }
         else
            throw new SaldoInsuficiente();
      else
         throw new ValorInvalido();
   }

   @Override
   public String toString()
   {
      return String.format(
            "Conta [numero=%s, titular=%s, saldo=%s, historico=%s]", numero,
            titular, saldo, historico);
   }
}
