package banco;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

import util.Prompt;

public class Banco implements Serializable
{
   private List<Cliente> clientes;
   private List<Conta> contas;
   private int ultimaConta;

   public Banco()
   {
      clientes = new LinkedList<Cliente>();
      contas = new LinkedList<Conta>();
      ultimaConta = 0;
   }

   public Cliente buscaCliente(int cpf)
   {
      Cliente x;
      Iterator<Cliente> it = clientes.iterator();
      while (it.hasNext())
      {
         x = it.next();
         if (x.getCpf() == cpf)
            return x;
      }
      return null;
   }

   public Cliente buscaCliente1(int cpf)
   {
      Cliente x = null;
      for (Iterator<Cliente> it = clientes.iterator();
           it.hasNext();
           x = it.next())
         if (x.getCpf() == cpf)
            return x;
      return null;
   }

   public Cliente buscaCliente2(int cpf)
   {
      for (int i = 0; i < clientes.size(); i++)
         if (clientes.get(i).getCpf() == cpf)
            return clientes.get(i);
      return null;
   }

   public Cliente buscaCliente3(int cpf)
   {
      for (Cliente x : clientes)
         if (x.getCpf() == cpf)
            return x;
      return null;
   }

   public Conta buscaConta(int numero)
   {
      for (Conta x : contas)
         if (x.getNumero() == numero)
            return x;
      return null;
   }
   
   public void cadastraCliente(Scanner teclado)
   {
      System.out.println("Cadastramento de cliente");
      System.out.println("----------------------------------------");

      int cpf = Prompt.promptInt(teclado, "CPF.......: ", x -> x > 0);

      if (buscaCliente(cpf) != null)
         System.out.println("CPF já cadastrado!");
      else
      {
         String nome = Prompt.promptLine(teclado, "Nome......: ");
         String endereco = Prompt.promptLine(teclado, "Endereco..: ");
         clientes.add(new Cliente(cpf, nome, endereco));
      }
   }
   
   public void consultaCliente(Scanner teclado)
   {
      System.out.println("Consulta de cliente");
      System.out.println("----------------------------------------");

      int cpf = Prompt.promptInt(teclado, "CPF.......: ", x -> x > 0);

      Cliente x = buscaCliente(cpf);
      if (x == null)
         System.out.println("CPF não cadastrado!");
      else
      {
         System.out.printf("Nome......: %s\n", x.getNome());
         System.out.printf("Endereço..: %s\n", x.getEndereco());
      }
   }
   
   public void abreConta(Scanner teclado)
   {
      System.out.println("Abertura de conta");
      System.out.println("----------------------------------------");
      
      int tipo = Prompt.promptInt(teclado, "Tipo da conta (1-simples, 2-especial): ",
            k -> k == 1 || k == 2);
      
      int numero = ++ultimaConta;
      System.out.printf("Número da conta..: %d\n", numero);
 
      int titular = Prompt.promptInt(teclado, "CPF do titular...: ", x -> x > 0);
     
      if (buscaCliente(titular) == null)
         System.out.println("Cliente não cadastrado!");
      else
      {
         switch (tipo)
         {
         case 1:
            contas.add(new Conta(numero, titular, 0.0));
            break;
         case 2:
            double limite = Prompt.promptDouble(teclado, "Limite...........: ", x -> x >= 0);
            contas.add(new ContaEspecial(numero, titular, 0, limite));
            break;
         }
      }
   }
   
   public void consultaSaldo(Scanner teclado)
   {
      System.out.println("Consulta de saldo");
      System.out.println("----------------------------------------");

      int numero = Prompt.promptInt(teclado, "Numero...: ", x -> x > 0);

      Conta x = buscaConta(numero);
      if (x == null)
         System.out.println("Conta não cadastrada!");
      else
      {
         System.out.printf("Titular..: %d [%s]\n", x.getTitular(), buscaCliente(x.getTitular()).getNome());
         System.out.printf("Saldo....: %s\n", x.getSaldo());
      }
   }
   
   public void consultaExtrato(Scanner teclado)
   {
      System.out.println("Consulta de extrato");
      System.out.println("----------------------------------------");

      int numero = Prompt.promptInt(teclado, "Numero...: ", x -> x > 0);

      Conta x = buscaConta(numero);
      if (x == null)
         System.out.println("Conta não cadastrada!");
      else
      {
         System.out.printf("Titular..: %d [%s]\n", x.getTitular(), buscaCliente(x.getTitular()).getNome());
         System.out.printf("Saldo....: %s\n", x.getSaldo());
         System.out.println();
         for (Movimento m : x.getHistorico())
            System.out.printf("%-20s %-20s %10.2f %10.2f\n",
                  new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(m.getData()),
                  m.getDescricao(),
                  m.getValor(),
                  m.getSaldo());
      }
   }
   
   public void deposita(Scanner teclado)
   {
      System.out.println("Depósito em conta");
      System.out.println("----------------------------------------");

      int numero = Prompt.promptInt(teclado, "Numero..: ", x -> x > 0);

      Conta x = buscaConta(numero);
      if (x == null)
         System.out.println("Conta não cadastrada!");
      else
      {
         double valor = Prompt.promptDouble(teclado, "Valor...: ", v -> v > 0);
         try {
            x.deposito(valor);
         }
         catch (ValorInvalido e) { System.out.println("Valor inválido!"); }
      }
   }
   
   public void saque(Scanner teclado)
   {
      System.out.println("Saque em conta");
      System.out.println("----------------------------------------");

      int numero = Prompt.promptInt(teclado, "Numero..: ", x -> x > 0);

      Conta x = buscaConta(numero);
      if (x == null)
         System.out.println("Conta não cadastrada!");
      else
      {
         double valor = Prompt.promptDouble(teclado, "Valor...: ", v -> v > 0);
         try {
            x.saque(valor);
         }
         catch (ValorInvalido e)     { System.out.println("Valor inválido!"); }
         catch (SaldoInsuficiente e) { System.out.println("Saldo insuficiente!"); }
      }
   }
}
