import java.util.Scanner;
import java.util.function.Predicate;

import util.Prompt;

public class TestePrompt
{
   public static void main(String[] args)
   {
      Scanner sc = new Scanner(System.in);

      int a = Prompt.promptInt(sc, "digite um inteiro negativo: ", new Neg());
      int b = Prompt.promptInt(sc, "digite um inteiro positivo: ", new Pos());
      int c = Prompt.promptInt(sc, "digite um inteiro entre " + a + " e " + b + ": ", new Entre(a, b));
      
      class ParEntreAB implements Predicate<Integer>
      {
         @Override
         public boolean test(Integer t)
         {
            return t >= a && t <= b && t % 2 == 0;
         }
         
      }

      int d = Prompt.promptInt(sc, "digite um inteiro par entre " + a + " e " + b + ": ", new ParEntreAB());

      int e = Prompt.promptInt(
            sc,
            "digite um inteiro ímpar entre " + a + " e " + b + ": ",
            new Predicate<Integer>()
            {
               @Override
               public boolean test(Integer t)
               {
                  return  t >= a && t <= b && t % 2 != 0;
               }
            }
      );


      int f = Prompt.promptInt(
            sc,
            "digite outro inteiro ímpar entre " + a + " e " + b + ": ",
            t -> t >= a && t <= b && t % 2 != 0
      );

      System.out.printf("a = %d\n", a);
      System.out.printf("b = %d\n", b);
      System.out.printf("c = %d\n", c);
      System.out.printf("d = %d\n", d);
      System.out.printf("e = %d\n", e);
      System.out.printf("f = %d\n", f);

      System.out.print("Digite um texto: ");
      System.out.println("|" + sc.nextLine() + "|");
   }

   private static class Pos implements Predicate<Integer>
   {
      @Override
      public boolean test(Integer value)
      {
         return value > 0;
      }
   }
   
   private static class Entre implements Predicate<Integer>
   {
      private Integer x;
      private Integer y;
      
      public Entre(Integer x, Integer y)
      {
         this.x = x;
         this.y = y;
      }
      
      @Override
      public boolean test(Integer value)
      {
         return value >= x && value <= y;
      }
   }
   
}

class Neg implements Predicate<Integer>
{
   @Override
   public boolean test(Integer value)
   {
      return value < 0;
   }

}
