#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "funcoes.h"


/* cria memoria para um vetor de tam posicoes */
int *cria_vetor(int tam)
{
  int *vetor;

  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}

void le_arqlc(char nomearq[], int nlinhas, int ncolunas,
              float **matriz)
{
  FILE *arquivo;
  int i, j;
  float valor;

  i = 0;
  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  while (i < nlinhas){
    j = 0;
    while (j < ncolunas){
      fscanf(arquivo, "%f",&valor);
      matriz[i][j] = valor;
      j++;
    }
    i++;
  }
  fclose(arquivo);
}

/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
float **cria_matriz_float(int nlinhas, int ncolunas)
{
  register int i;
  float **matriz;

  matriz = (float **) malloc(nlinhas*sizeof(float *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (float *) malloc(ncolunas*sizeof(float));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}


/* libera memoria de um vetor */
void libera_vetor(int *vetor)
{
  free(vetor);
}

void libera_matriz_float(float **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((float *) matriz[i]);
  free((float *) matriz);
}


/* constri soluo inicial */
void constroi_solucao_inicial(int *s, int nminas, int nprojetos)
{
  int i;

  for (i=0; i<nminas; i++){
    s[i] = random(nprojetos);
  }
}


/* Gera numero aleatorio entre min e max */
 float randomico(float min, float max)
{
  if (min == max) return min;
  return ((float) (rand()%10000/10000.0)*(max-min) + min);
}

/* atualiza a melhor solucao */
void atualiza_vetor(int *recebe, int *doa, int n)
{
   for (int j=0; j < n; j++) recebe[j] = doa[j];
}


void imprime_solucao(int *s, int nminas)
{
  int i;

  for (i=0; i < nminas; i++){
    printf("s[%d]= %d \n",i+1,s[i]);
  }

}

float calcula_fo(int *s,
                 float **vpl,
                 float **prod,
                 float metaprod,
                 int nminas,
                 int nprojetos,
                 float pfalta,
                 float pexc)
{
  int i;
  float somavpl, somaprod;
  somavpl = 0;
  somaprod = 0;
  for (i=0; i < nminas; i++){
    somavpl = somavpl + vpl[i][s[i]];
    somaprod = somaprod + prod[i][s[i]];
  }
  if (somaprod > metaprod)
     somavpl = somavpl - pexc*(somaprod - metaprod);
  else
     somavpl = somavpl - pfalta*(metaprod - somaprod);

  return somavpl;
}

float melhorvizinho(int *s,
                    float **vpl,
                    float **prod,
                    float metaprod,
                    int nminas,
                    int nprojetos,
                    float pfalta,
                    float pexc,
                    int *mina,
                    int *projeto)
{
  int i, j, aux;
  float foviz, melhorfoviz;
  melhorfoviz = 0;

  for (i=0; i < nminas; i++){
    aux = s[i];
    for (j=0; j < nprojetos; j++){
       s[i] = j;
       foviz = calcula_fo(s,vpl,prod,metaprod,nminas,nprojetos,pfalta,pexc);
       if (foviz > melhorfoviz){
         melhorfoviz = foviz;
         *mina = i;
         *projeto = j;
       }
    }
    s[i] = aux;
  }
  return melhorfoviz;
}


float descida(int *s,
              float **vpl,
              float **prod,
              float metaprod,
              int nminas,
              int nprojetos,
              float pfalta,
              float pexc)
{
  int i, mina, projeto;
  float foviz, fo;
  bool melhorou;
  melhorou = true;
  fo = calcula_fo(s,vpl,prod,metaprod,nminas,nprojetos,pfalta,pexc);

  while (melhorou){
     foviz = melhorvizinho(s,vpl,prod,metaprod,nminas,nprojetos,pfalta,pexc,&mina,&projeto);
     if (foviz > fo){
       fo = foviz;
       s[mina] = projeto;
     }
     else
       melhorou = false;
  }
  return fo;
}
