//---------------------------------------------------------------------------

#ifndef TabuSearchH
#define TabuSearchH
#include<iostream>
#include<vector>
#include<ctime>
#include<fstream>
#include<cassert>
#include "config.hpp"
#include "Crew.h"
#include "Pesos.h"
#include "CrewUtil.h"
using namespace std;

class solucao
{
    public:

    int src_trip;
    int dst_trip;
    int n_tarefa;
    int vi;
    int vj;
    unsigned long int objetivo;
    Task task;

};

class TabuSearch{
        public:

        //Parametros:
        void do_tabu(vector<Crew>&, double, int, int, int);


        private:
        //Dados
        vector<Crew> melhor_solucao; //Vetor onde sera armazenado a melhor solucao
        unsigned long int melhor_fobjetivo;
        list<solucao> tabu_list; //Lista Tabu
        solucao sol;
        int list_size;
        ofstream file_obj;

         //Metodos
        bool is_tabu(const solucao&);
        void insere_tabu(const solucao);
        unsigned long int melhor_vizinho(vector<Crew>&, solucao &,unsigned long int);
        void randomize_vector(const vector<Crew>&, vector<Crew>& );
        unsigned long int movimento(Crew,Crew,int,unsigned long int,Task&);

};

//---------------------------------------------------------------------------
#endif
