//---------------------------------------------------------------------------
#include "TabuSearch.h"



unsigned long int TabuSearch::movimento(Crew src_trip, Crew dst_trip, int i, unsigned long int objetivo,Task& task)
{

    unsigned long int old_src_trip, //Valor antigo da funcao objetivo do tripulante onde a tarefa sera retirada.
                      new_src_trip, //Novo valor da funcao objetivo de onde a tarefa sera retirada.
                      old_dst_trip, //valor antigo da funcao objetivo de onde a tarefa sera inserida.
                      new_dst_trip, //Novo valor da funcao objetivo de onde a tarefa sera inserida.
                      old_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera retirada.
                      old_dst_pdupla, // Novo valor da pegada dupla do tripulante onde a tarefa sera retirada.
                      new_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.
                      new_dst_pdupla;   //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.
    Task t;

    old_src_pdupla = pesos.p_duplas*src_trip.p_duplas();
    old_dst_pdupla = pesos.p_duplas*dst_trip.p_duplas();
    old_src_trip = src_trip.f_objetivo();
    old_dst_trip = dst_trip.f_objetivo();

    t = src_trip.remover_tarefa(i);
    task = t;
    dst_trip.adicionar_tarefa(t);

    new_src_pdupla = pesos.p_duplas*src_trip.p_duplas();
    new_dst_pdupla = pesos.p_duplas*dst_trip.p_duplas();
    new_src_trip = src_trip.f_objetivo();
    new_dst_trip = dst_trip.f_objetivo();


    objetivo = objetivo - old_src_trip - old_dst_trip - old_src_pdupla
               - old_dst_pdupla + new_src_pdupla + new_dst_pdupla +
               new_src_trip + new_dst_trip;

    return objetivo;
}

//Parametros: vc, vetor onde esta armazenada a solucao.
//t_vizinhanca, tamanho da vizinhanca.
//btmax, maximo de iteracoes sem melhora.
//list_size, tamanho da lista tabu.
//n_iter, numero de iteracoes onde o tamanho da lista tabu ira ser alterada.
void TabuSearch::do_tabu(vector<Crew>& vc, double t_vizinhanca, int btmax, int list_size, int n_iter)
{

    int sem_melhora,vi,vj,tamanho,n_tarefa;
    int iter, melhor_iter,iteracoes = 0,total_iter=0;
    unsigned long int f_objetivo,movimento_atual,melhor_movimento;
    Task t;
    CrewUtil util;

    t_vizinhanca = t_vizinhanca/100;
    tamanho = max(1,(int)(t_vizinhanca*vc.size()));

    vector<Crew> vetor(tamanho);

    f_objetivo =  util.f_objetivo_global(vc);
    this->melhor_fobjetivo = f_objetivo;

    cout << "\nFuncao Objetivo atual: " << f_objetivo;
    sem_melhora=0;

    file_obj.open("file_obj.txt", ios::out | ios::app);

    assert(file_obj);

    this->list_size = list_size;
    iter = 0;
    melhor_iter = 0;
    this->melhor_solucao = vc;
    util.dump_file2(this->melhor_solucao, "teste_solucao.txt");

    while((iter - melhor_iter) < btmax){
         ++iter;
         ++iteracoes;
         ++total_iter;

        /*Inicializacao do vetor onde estarao os tripulantes a serem percorridos*/
        randomize_vector(vc,vetor);

        f_objetivo  = melhor_vizinho(vetor,sol,f_objetivo);

        t = vc[sol.src_trip].remover_tarefa(sol.n_tarefa);
        vc[sol.dst_trip].adicionar_tarefa(t);

        tabu_list.push_back(sol);

        if(iteracoes >= n_iter)
        {
                util.dump_file2(this->melhor_solucao, "melhor_solucao.txt");
                this->list_size = list_size + (rand()%10);
                cout << "\nAlterando o tamanho da lista tabu para: " << this->list_size;
                iteracoes = 0;
        }

        if(tabu_list.size() > this->list_size)
                tabu_list.pop_front();

        cout << "\n[" << sem_melhora << "]" << " Funcao Objetivo atual: " << f_objetivo;
        cout << "  Fonte Destino: " << sol.src_trip << " " << sol.dst_trip;

        if(f_objetivo < this->melhor_fobjetivo){
                this->melhor_solucao = vc;
                this->melhor_fobjetivo = f_objetivo;
                melhor_iter=iter;
                sem_melhora=0;
                cout << "  Melhora Global.";
          // melhor_iter = iter;
        }
        else{
            ++sem_melhora;
        }

     file_obj << total_iter << "\t" << this->melhor_fobjetivo << "\t" << f_objetivo <<  "\n";
           //file_obj.flush();

    }//while

     file_obj.flush();
     file_obj.close();

     util.dump_file2(this->melhor_solucao, "melhor_solucao.txt");
     cout << "\n\nEnd of LeoXT Dummie Seacrh.\t"
          << "Objective Value Found: " << this->melhor_fobjetivo  << "\n";
     vc = this->melhor_solucao;
     cin.get();
}
//Retorna true caso a movimento passado  tabu.
bool TabuSearch::is_tabu(const solucao& sol)
{
    list<solucao>::iterator iter;

    for(iter = tabu_list.begin(); iter != tabu_list.end(); ++iter){
        if(iter->src_trip == sol.dst_trip && iter->dst_trip == sol.src_trip
             && iter->task == sol.task)

            return true;
    }

    return false;
}
//Calcula o melhor vizinho de um subonjunto dos tripulantes(vetor) e retorna o valor da funcao objetivo
//que esse movimento ira gerar.
//E passsado o vetor de tripulantes a qual a vizinhanca sera analisada, uma variavel do tipo solucao a qual sera
//passada o movimento do melhor vizinho e o valor da funcao objetivo da solucao corrente.
unsigned long int TabuSearch::melhor_vizinho(vector<Crew>& vetor, solucao &sol,  unsigned long int f_objetivo)
{
        int tamanho = 0;
        unsigned long int movimento_atual,melhor_movimento,melhor_vizinho;
        solucao sol_aux;

        melhor_vizinho = 100000000;

        for(int i = 0; i < (int)vetor.size(); ++i){
            for(int j = 0; j < (int)vetor.size(); ++j){
                if(i != j)
                {
                    tamanho = vetor[i].jornada.size();
                  //  cout << "Tgamnho: " << tamanho;

                    if(vetor[i].possui_artificial())
                    {
                        --tamanho;
                    }

                    for(int k = 0; k < tamanho; ++k){
                        movimento_atual = this->movimento(vetor[i], vetor[j],k,f_objetivo,sol_aux.task);
                        sol_aux.src_trip = vetor[i].numero;
                        sol_aux.dst_trip = vetor[j].numero;

                        if((movimento_atual < melhor_vizinho && !this->is_tabu(sol_aux)) || (movimento_atual < this->melhor_fobjetivo))
                        {
                            melhor_vizinho = movimento_atual;
                            sol.n_tarefa = k;
                            sol.vi=i;
                            sol.vj=j;
                            sol.src_trip = vetor[sol.vi].numero;
                            sol.dst_trip = vetor[sol.vj].numero;
                         }
                    }//for
                }//if
            }//for
        }//for

        return melhor_vizinho;
}

//Embaralha o vetor da vizinhanca a ser pesquisada.
void TabuSearch::randomize_vector(const vector<Crew>& vetor_principal, vector<Crew>& vetor_aux)
{
        int aux;

        srand((int)time(NULL));

        for(int i = 0; i < (int)vetor_aux.size(); ++i){
            aux = rand()%(vetor_principal.size()-1);
            vetor_aux[i] = vetor_principal[aux];
            vetor_aux[i].numero = aux;
        }

}
