
/***************************************************************************
                          Grasp.cpp  -  description
                             -------------------
    begin                : Fri Aug 9 2002
    copyright            : (C) 2002 by leoxt
    email                : leoxt@arbornet.org
 ***************************************************************************/
#include "Grasp.h"


bool high_task(Task& t1, Task& t2)
{
      return t1.duracao( ) > t2.duracao( );
}


bool less_sol(Solucao& sol1, Solucao& sol2)
{
      return sol1.objetivo < sol2.objetivo;
}

Task Grasp::get_task(l_tarefas &l, int pos)
{
	Task task;
	l_iterator iter;
	int i = 0;

	for(iter = l.begin(); i < pos; ++iter)
		++i;

	task = *iter;
	l.erase(iter);

	return task;
}

Solucao Grasp::get_sol(l_solucao &l, int pos)
{
	Solucao sol;
	s_iterator iter;
	int i = 0;

	for(iter = l.begin(); i < pos; ++iter)
		++i;

 	sol = *iter;
 	l.erase(iter);

 	return sol;
}

void Grasp::remove_task(l_tarefas& l, const Task& task)
{
        l_iterator iter;

        for(iter = l.begin(); iter != l.end(); ++iter ){
                if ( *iter == task ){
                        l.erase(iter);
                        return;
                }
        }
}


void Grasp::do_grasp(l_tarefas& l, vector<Crew>& v, double alfa, double beta)
{
	int n_task,n_sol,random;
	l_solucao sol;
	Solucao p_sol;
	double d_alfa,d_beta;
	Task task;

	d_alfa = alfa/100;
	d_beta = beta/100;

	l.sort(high_task);

	srand((int)time(NULL));

    while(!l.empty())
	{

	  n_task = max(1, (int)(l.size() * d_beta)); // calcula d_beta% de l.size().
	  random = (rand()%n_task);  // obtem qual tarefa ele devera pegar.
      task = get_task(l, random );  //retorna a tarefa, retirando-a da lista.

	  for(int i  = 0; i < (int)v.size(); ++i) //testa para todos os tripulantes
	  {
	  	v[i].adicionar_tarefa(task);
        v[i].ordena_jornada();
	  	p_sol.numero = i;
	  	p_sol.objetivo = v[i].f_objetivo();
	  	sol.push_back(p_sol);
       // this->remove_task(v[i].jornada, task);
	  	v[i].remover_tarefa(task);
      }

	  sol.sort(less_sol);
      n_sol = (int)sol.size() * d_alfa;
      random = (rand()%n_sol);

	  p_sol = get_sol(sol, random);
      v[p_sol.numero].adicionar_tarefa(task);
      sol.clear();
      if((l.size()%10) == 0)
          cout << ".";
    }
}



