#include "CrewUtil.h"

int CrewUtil::pduplas_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        if(vc[i].p_duplas())
        {
            ++total;
        }
    }

    return total;
}

int CrewUtil::et_jornada_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].et_jornada();
    }

    return total;
}

int CrewUtil::np_duplas(vector<Crew>& vc)
{
  int total = 0;

  for(int i = 0; i < vc.size(); ++i){
    if(vc[i].p_duplas())
        ++total;
  }

  if(total == 0)
    return total;
  else
    return total-NP_DUPLASMAX;
}
  /* int cont = 0;
   cl_iterator iter,
         	next; //Apontador para o proximo elemento do conteiner


   for(int i = 0; i < (int)vc.size(); ++i)
        if(vc[i].jornada.size() > 1){
                vc[i].jornada.sort();
                iter = vc[i].jornada.begin();
                next = vc[i].jornada.begin();
                ++next;
   	        do{
               if((next->h_inicial - iter->h_final) > 120)
   	   	        cont+=1;
                ++next;
	            ++iter;
	        }while(next != vc[i].jornada.end());
         }
   cont=cont-NP_DUPLASMAX;
   return cont;
}

 */


int CrewUtil::tveiculos_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].t_veiculo();
    }

    return total;
}

int CrewUtil::hextra_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].h_extra();
    }

    return total;
}

int CrewUtil::t_sobreposicao_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].t_sobreposicao();
    }

    return total;
}

void CrewUtil::ordena_vetor_trip(vector<Crew>& vc)
{

    for(int i = 0; i < (int)vc.size(); ++i){
        vc[i].jornada.sort();
    }
}

unsigned long int CrewUtil::f_objetivo_global(vector<Crew>& vc)
{
    unsigned long int s_global = 0;


    for(int i = 0; i < (int)vc.size(); ++i){
       s_global = s_global + vc[i].f_objetivo();
    }

    s_global = s_global + pesos.p_duplas*np_duplas(vc);

    return s_global;
}

int CrewUtil::nsem_tarefas(vector<Crew>& vc)
{
    int n = 0;

    for(int i = 0; i < (int)vc.size(); ++i){
        if (vc[i].jornada.size()==0)
            n++;
    }
    return n;
}

int CrewUtil::tp_permitida_total(vector<Crew>& vc)
{
    int n = 0;

    for(int i = 0; i < (int)vc.size(); ++i){
        n = n + vc[i].tp_permitida();
    }

    return n;
}

int CrewUtil::tp_proibida_total(vector<Crew>& vc)
{
    int n = 0;

    for(int i = 0; i < (int)vc.size(); ++i){
        n = n + vc[i].tp_proibida();
    }

    return n;
}


void CrewUtil::dump_file2(const vector<Crew>& v, char* filename)
{
    cl_iterator iter;
    ofstream out_file( filename, ios::out | ios::trunc);
    int n_tarefa;

    assert(out_file);

     out_file << "\t\tPesos usados nessa solucao:\n"
             << "p_duplas: " << pesos.p_duplas
             << "\np_duplas: " << pesos.np_duplas
             << "\nh_extra: " << pesos.h_extra
             << "\ni_jornada: " << pesos.i_jornada
             << "\nf_acumulada: " << pesos.f_acumulada
             << "\nd_jornada: " << pesos.d_jornada
             << "\nt_ocioso: " << pesos.t_ocioso
             << "\nt_sobreposicao: " << pesos.t_sobreposicao
             << "\ntp_proibida: " << pesos.tp_proibida
             << "\ntp_permitida: " << pesos.tp_permitida
             << "\nt_veiculo " << pesos.t_veiculo;

    out_file << "\n\n\t\tProgramacao dos Tripulantes.\n";
    out_file << "A solucao abaixo possui funo objetivo global = " << f_objetivo_global(v) << "\n"
             << "\nSobreposicao Total: " << this->t_sobreposicao_total(v)
             << "\nHoras Extras: " << this->hextra_total(v)
             << "\nHoras Excedentes: " << this->et_jornada_total(v)
             << "\nTripulantes sem Tarefas: " << this->nsem_tarefas(v)
             << "\nPegadas duplas: " << this->pduplas_total(v)
             << "\nTrocas de Veiculos: " << this->tveiculos_total(v)
             << "\nTripulantes com pegada dupla: " << this->pduplas_total(v)
             << "\nTrocas de ponto permitida: " << this->tp_permitida_total(v)
             << "\nTrocas de ponto proibida: " << this->tp_proibida_total(v) << "\n";

    out_file << "____________________________________________________________________________________________________________________________\n";

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "\n\n========================================================================================================\n";
        out_file << "\n\t\t\tTripulao " << i << "\n";
        //out_file << "Funcao objetivo do tripulante: " << v[i].f_objetivo() << "\n";
        out_file << "============================================================================================================\n";
        out_file << "\t\t\tN_Vei\t\tH_Inic\tH_Fin\t\tP_Ini\t\tP_Fina\tF_Acum\tL_Ini\t\tL_Fina\n";
        out_file << "_____________________________________________________________________________________________________________\n";
        n_tarefa=0;
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter){
            out_file << "Tarefa " << n_tarefa << "\t\t" << iter->n_veiculo << "\t\t"
                      << iter->h_inicial << "\t\t" << iter->h_final << "\t\t"
                      << iter->p_inicial << "\t\t" << iter->p_final << "\t\t"
                      << iter->f_acumulada << "\t\t" << iter->l_inicial << "\t\t" << iter->l_final;

            if(iter->artificial)
                out_file << "**\n";
            else
                out_file << "\n";

             out_file << "_____________________________________________________________________________________________________________\n";
             ++n_tarefa;
        }
        out_file << "Tempo total de trabalho (minutos): " << v[i].d_jornada() << endl;
        out_file << "Tempo ocioso (minutos): " << v[i].t_ocioso() << endl;
        out_file << "Hora Extra (minutos): " << v[i].h_extra() << endl;

        if(v[i].p_duplas())
        {
                out_file << "Tripulante com pegada dupla. " << endl;
        }

    }

    out_file.close();
}

void CrewUtil::dump_file(const vector<Crew>& v, char* filename)
{
    cl_iterator iter;
    ofstream out_file( filename, ios::out | ios::trunc);

    assert(out_file);

    out_file << "\t\tPesos usados nessa solucao:\n"
             << "p_duplas: " << pesos.p_duplas
             << "\np_duplas: " << pesos.np_duplas
             << "\nh_extra: " << pesos.h_extra
             << "\ni_jornada: " << pesos.i_jornada
             << "\nf_acumulada: " << pesos.f_acumulada
             << "\nd_jornada: " << pesos.d_jornada
             << "\nt_ocioso: " << pesos.t_ocioso
             << "\nt_sobreposicao: " << pesos.t_sobreposicao
             << "\ntp_proibida: " << pesos.tp_proibida
             << "\ntp_permitida: " << pesos.tp_permitida
             << "\nt_veiculo " << pesos.t_veiculo;




    out_file << "\t\tProgramacao dos Tripulantes.\n";
    out_file << "A solucao abaixo possui funo objetivo global = " << f_objetivo_global(v) << "\n"
             << "\nSobreposicao Total: " << this->t_sobreposicao_total(v)
             << "\nHoras Extras: " << this->hextra_total(v)
             << "\nTripulantes sem Tarefas: " << this->nsem_tarefas(v)
             << "\nPegadas duplas: " << this->pduplas_total(v)
             << "\nTrocas de Veiculos: " << this->tveiculos_total(v) << "\n";
    out_file << "_________________________________________________________________________\n";

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "\n_________________________________________________________\n";
        out_file << "\n\t\tTarefas do Tripulante " << i << "\n";
        //out_file << "Funcao objetivo do tripulante: " << v[i].f_objetivo() << "\n";
        out_file << "_________________________________________________________\n";
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter)
            out_file << *iter;
        }

    out_file.close();
}

void CrewUtil::init_vector_crew(vector<Crew>& vc)
{
        for(int i = 0; i < (int)vc.size(); i++)
                vc[i].numero = i;
}

void CrewUtil::write_vector_crew(const vector<Crew>& vc, char* filename)
{
        vector<CrewFile> vector_crew;
        list<Task>::const_iterator iter;
        int n_tarefas = 0;
        int tamanho = 0;

        ofstream arquivo(filename, ios::binary);

        assert(arquivo);

        vector_crew.resize(vc.size());

         for(int i = 0; i < (int)vc.size(); ++i){
                vector_crew[i].numero = i;
                for(iter = vc[i].jornada.begin();
                                iter != vc[i].jornada.end(); ++iter)
                {
                        n_tarefas++;
                        vector_crew[i].vector_tasks.push_back(*iter);
                 }
        }

         for(int i = 0; i < (int)vector_crew.size(); ++i){
                cout << "Tamanho: " << vector_crew[i].vector_tasks.size();
                 //cout <<  vector_crew[i].vector_tasks[0];
        }

        //cout << "Tamanho: " << sizeof(vector_crew) + n_tarefas*sizeof(Task);

        tamanho = sizeof(vector_crew) + n_tarefas*sizeof(Task) + sizeof(vector<Task>);
        cout << "Tamanho: " << tamanho;

        cin.get();
        for(int i = 0; i < (int)vector_crew.size(); ++i){
                 arquivo.write((char*)(&vector_crew[i].vector_tasks), 25*36+sizeof(vector<Crew>));//(vector_crew[i].vector_tasks.size()*sizeof(Task)));

        }

       // arquivo.write((char*)(&vector_crew), 20000);
         arquivo.flush();

        arquivo.close();
}

 void CrewUtil::read_vector_crew(vector<Crew>& vc, char* filename)
 {
        vector<CrewFile> vector_crew;
        vector<Task>::iterator iter;
        Task teste;

        ifstream arquivo(filename, ios::binary);

        assert(arquivo);
        vector_crew.resize(vc.size());

       for(int i = 0; i < (int)vector_crew.size(); ++i){
          //       vector_crew[i].vector_tasks.resize(10,teste);
                //cout << "Tamanho: " << vector_crew[i].vector_tasks.size();
              //vector_crew[i].vector_tasks.resize(9,teste);
              arquivo.read((char*)&vector_crew[i].vector_tasks,25*36+sizeof(vector<Crew>));//sizeof(vector_crew[i].vector_tasks)+32);
        }

        for(int i = 0; i < (int)vector_crew.size(); ++i){
                cout << "Tamanho: " << vector_crew[i].vector_tasks.size();
        }

       // cin.get();
        for(int i = 0; i < (int)vector_crew.size(); ++i){
                vc[i].jornada.clear();
                cin.get();
               /* for(int j = 0; j < (int)vector_crew[i].vector_tasks.size();++i)
                {
                        cout <<  vector_crew[i].vector_tasks[j];
                        //vc[i].jornada.push_back(vector_crew[i].vector_tasks[j]);
                } */
                for(iter = vector_crew[i].vector_tasks.begin();
                        iter != vector_crew[i].vector_tasks.end(); ++iter)
                {
                        cout <<  vector_crew[i].vector_tasks[0];
                        //cout << "Tamanhox: " <<  vector_crew[i].vector_tasks.size();
                        //cout << vector_crew[i].vector_tasks.size();//vector_crew[i].vector_tasks;
                        //vc[i].jornada.push_back(*iter);
                }
        }

        arquivo.close();
 }

void CrewUtil::gravar_solucao(const vector<Crew>& v, char* filename)
{
    cl_iterator iter;
    ofstream out_file( filename, ios::out | ios::trunc);
    int n_tarefa;

    assert(out_file);


    out_file << v.size();

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "##" << i << "\n";
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter){
            out_file << iter->n_veiculo << "," << iter->h_inicial << "," << iter->h_final << ","
                      << iter->p_inicial << "," << iter->p_final << ","
                      << iter->f_acumulada << "," << iter->l_inicial << "," << iter->l_final;

            if(iter->artificial)
                out_file << ",*\n";
            else
                out_file << "\n";
        }
    }

    out_file.close();
}

void CrewUtil::ler_solucao(vector<Crew>& vc, char* filename)
{
        int indice = -1,trips;
        char aux,art,comentario;
        char buffer[100];
	Task task;

	ifstream task_file(filename, ios::in );

	assert(task_file);

        //le o numero de tripulantes presentes na solucao redimensionando o vetor.
       // task_file >> trips;
        //vc.resize(trips);

        memset(buffer, '\0', sizeof(buffer));

        while(task_file.getline(buffer,100))
        {
            if(buffer[0] == '#'){
                  indice++;
                  continue;
            }

            sscanf(buffer,"%d,%d,%d,%d,%d,%d,%d,%d,%c", &task.n_veiculo,&task.h_inicial,&task.h_final,&task.p_inicial,&task.p_final
	     		,&task.f_acumulada,&task.l_inicial,&task.l_final,&art);

            if(art == '*') {
                task.artificial == true;
            }
            else{
                task.artificial = false;
            }

            vc[indice].jornada.push_back(task);
            memset(buffer, '\0', sizeof(buffer));
       }


}







