/***************************************************************************
                          Crew.hpp
--------------------------------------------------------------------------------------------------------------------
    begin                 : Sat Jul 27 2002
    copyright          : (C) 2002 by Leonardo X. T. Cardoso
    email                 : leoxt@arbornet.org
 ***************************************************************************/

/*Classe Crew: Contem as definicoes sobre a jornada de trabalho.
 *------------------------------------------------------------------------------
 * Variaveis: 
 * numero - Identificacao da tripulacao.
 * jornada - Lista de tarefas do tripulante (jornada de trabalho)
 *------------------------------------------------------------------------------
 *
 * Metodos:
 * ordena_jornada(): Ordena a jornada de trabalho por hora inicial das tarefas.  						OK.
 * d_jornada(): Retorna a duracao da jornada de trabalho em minutos.             							OK.
 * i_jornada(): Retorna o intervalo entre as jornadas.                           										OK.
 * f_acumulada(): Retorna a folga acumulada total da jornada de Trabalho.        						OK.
 * h_extra(): Retorna o numero de horas extra da jornada.                        									OK.
 * n_tarefas(): Retorna o numero de tarefas do tripulante.                       										OK
 * m_intervalo(): Retorna o maior intervalo entre tarefas.                       										OK.
 * possui_folga():Retorna TRUE caso o tripulante possua os 15 minutos de folga. 						OK.
 * p_duplas(): Retorna o numero de pegadas dupla do tripulante.                  								OK.
 * tp_proibida(): Retorna o numero de troca de ponto proibidas                  									OK
 * tp_permitida(): Retorna o numero de troca de ponto permitidas.              									OK
 * t_veiculos(): Retorna o numero de troca de veiculos.                          									OK
 * ft_jornada(): Falta de tempo entre jornadas......???????                      										NN
 * t_ocioso(): Retorna o tempo ocioso da jornada em minutos.             											OK
 * t_sobreposicao(): Retornar o numero de sobreposicoes ou o tempo  											OK
 * et_jornada(): Retorna o excesso de tempo de trabalho ( > 9:10) da jornada em minutos. 		OK
 * fte_jornada(): Retorna a falta de tempo entre jornada em minutos ( tempo < 11:00).          	OK
 * -------------------------------------------------------------------------------------------------
 * */

#ifndef CREW_H
#define CREW_H

#include<algorithm>
#include<cstdlib>
#include<cassert>
#include "Pesos.h"
#include "config.hpp"


const int MAX_HORAS =  430; /* Duracao maxima da jornada sem hora extra em minutos sem pegada dupla. 7:10h */
const int MAX_HORAS_D = 400; /* Duracao maxima da jornada sem hora extra com pegada dupla. 6:40h */
const int T_DIA = 1440;  /* Duracao de um dia em Minutos */
const int MAX_DIA = 550;  /* Tempo maximo da jornada em minutos. 9:10h */
const int I_JORNADA =  660; /* Intervalo que se deve ter entre jornadas. 11h */
const int T_FOLGA = 15; /*Folga obrigatoria (continua) que o tripulante deve ter na jornada. */
const int NP_DUPLASMAX = 20; /*Numero maximo de tripulantes com pegadas duplas*/
const int FOLGA_TOTAL_OBRIGATORIA = 30;  /**/

template <class T>
inline const T& max(const T& a, const T& b){
	return a < b ? b : a;
}


class Crew{
	public:
		int numero;
		l_tarefas jornada;

		Crew();
		Crew(int);
        void adicionar_tarefa(Task&);
		void ordena_jornada();
		int d_jornada() const;
		int i_jornada() const;
		int f_acumulada() const;
		int h_extra() const;
		int n_tarefas() const;
		int m_intervalo() const;
		bool possui_folga() const;
        bool possui_artificial() const;
		int p_duplas() const;
        int t_sobreposicao() const;
		unsigned long int f_objetivo();
		int t_veiculo() const;
		int tp_proibida()const;
		int tp_permitida() const; // ??
		int t_ocioso() const; //$$verificar codigo
		int et_jornada() const;
		int fte_jornada() const;
        int ft_folga() const;
        Task remover_tarefa(int);
        void remover_tarefa(const Task&);

	private:
  	   int folga_total() const;
};

#endif
