/***************************************************************************
                          Crew.cpp
------------------------------------------------------------------------------------------------------------------------
    begin                 : Sat Jul 27 2002
    copyright             : (C) 2002 by Leonardo X. T. Cardoso
    email                 : leoxt@arbornet.org
 ***************************************************************************/
//duvidas procurar string: $$
#include "Crew.h"


Crew::Crew()
{
   numero = 0;
}

Crew::Crew(int numero)
{
   this->numero = numero;
}

/*************************************************************************************
 * Metodo: adicionar_tarefa()
 * Objetivo: Atrbuir uma tarefa ao tripulante, incluindo tarefa virtual se necessario.
 * Autor: Leonardo X. T. Cardoso
 * Data de Criacao: 25/08/02
 * Ultima alteracao: 25/08/02
 ************************************************************************************/
void Crew::adicionar_tarefa(Task& task)
{//verificar p_dupla. nao precisa virtual.
    l_iterator iter;

    if(task.artificial)
    {
        cout << "ERRO FATAL, TENTATIVA DE ATRIBUIR TAREFA VIRTUAL!!\n";
        abort();
    }

    if(jornada.size() == 0)
    {
        jornada.push_back(task);
    }
    else
    {
        //verifica se o tripulante possui tarefa virtual.
        iter = jornada.end();
        --iter;

        if(iter->artificial)
        {
            jornada.erase(iter);
            jornada.push_back(task);
        }
        else
        {
            jornada.push_back(task);

        }
    }

    jornada.sort();

    if(!this->possui_folga())
    {
        l_iterator iter1;
        Task t;

        iter1 = jornada.end();
        --iter1;

        t = *  new Task(iter1->n_veiculo, iter1->h_final, iter1->h_final + this->ft_folga(),
                        iter1->p_final, iter1->p_final, 0, iter1->l_final,
                        iter1->l_final, true);

        jornada.push_back(t);
        delete(t);

    }
    else if((this->folga_total() + this->f_acumulada()) < FOLGA_TOTAL_OBRIGATORIA)
    {
        l_iterator iter1;
        Task t;
        int tempo;

        iter1 = jornada.end();
        --iter1;

        tempo = FOLGA_TOTAL_OBRIGATORIA - (this->folga_total() + this->f_acumulada());

        t = *  new Task(iter1->n_veiculo, iter1->h_final, iter1->h_final + tempo,
                        iter1->p_final, iter1->p_final, 0, iter1->l_final,
                        iter1->l_final, true);

        jornada.push_back(t);
    }
}


void Crew::ordena_jornada()
{
   jornada.sort();
}


/********************************************************************
 * Metodo: d_jornada()
 * Objetivo: Calcular a duracao da jornada de trabalho do tripulante.
 * Autor: Leonardo X. T. Cardoso
 * ******************************************************************/
int Crew::d_jornada() const
{
   cl_iterator first, last;
   int total,maior;

   first = jornada.begin();
   last = jornada.end();
   last--;

   total = last->h_final - first->h_inicial;
   maior = this->m_intervalo();

   if(maior > 120)
   	return total - maior;
   else
   	return total;
}

/*******************************************************************
 * Metodo: i_jornada()
 * Objetivo: Calcular o intervalo entre as jornadas do tripulante.
 * Intervalo entre o fim de uma jornada e inicio de outra.
 * Autor: Leonardo X. T. Cardoso.
 * *****************************************************************/
int Crew::i_jornada() const
{
  cl_iterator first, last;
  int duracao;

  first = jornada.begin();
  last = jornada.end();
  last--;

  duracao = this->d_jornada();

  return T_DIA - duracao;

//	if(((T_DIA - last->h_final) + first->h_inicial) > 0)
//  return ((T_DIA - last->h_final) + first->h_inicial);

}
/******************************************************************
 * Metodo: f_acumulada()
 * Objetivo: Calcular a folga acumulada total do tripulante.
 * Autor: Leonardo X. T. Cardoso
 * ***************************************************************/
int Crew::f_acumulada() const
{
  int Total = 0;
  cl_iterator iter;
  
  for(iter = jornada.begin(); iter != jornada.end(); iter++){
  	Total = Total + iter->f_acumulada;
  }

  return Total;
}


/********************************************************************
 * Metodo: h_extra()
 * Objetivo: Calcular a hora extra do tripulante em minutos.
 * Autor: Leonardo X. T. Cardoso.
 *******************************************************************/
int Crew::h_extra() const 
{
  int d_jornada = 0;
  d_jornada = this->d_jornada();

  if(d_jornada > MAX_HORAS_D)
  {
    if(!p_duplas())
    {
        return  (d_jornada < MAX_HORAS ) ?  0 : (d_jornada - MAX_HORAS);
    }
    else
    {
    	return max(0,(d_jornada - this->m_intervalo()) - MAX_HORAS_D);
    }
  }
  else
  {
  	return 0;
  }

}

/******************************************************************
 * Metodo: n_tarefas()
 * Objetivo: Calcular o numero de tarefas do tripulante.
 * Autor: Leonardo X. T. Cardoso.
 * ****************************************************************/
int Crew::n_tarefas() const
{
  return jornada.size();
}

/******************************************************************
 * Metodo: m_intervalo()
 * Objetivo: Calcular o maior intervalo entre tarefas do tripulante.
 * Autor: Leonardo X. T. Cardoso.
 * ****************************************************************/
int Crew::m_intervalo() const
{
   cl_iterator iter,
   		next; //Apontador para o proximo elemento do conteiner
   int maior = 0;

   //this->ordena_jornada();

   if(jornada.size() == 1)
   {
      return maior;
   }
   else
   {
   	iter = jornada.begin();
   	next = 	jornada.begin();
   	++next;
   	do{
            if((next->h_inicial - iter->h_final) > maior)
	   	maior = (next->h_inicial - iter->h_final);
	    ++next;
	    ++iter;
	  }while(next != jornada.end());
	}

  return maior;
}

/***************************************************************************************
 * Metodo: possui_folga()
 * Objetivo: Verificar se o tripulante possui os 15 minutos de folga tripulante. Retorna true caso ele tenha
 * Autor: Leonardo X. T. Cardoso.
 * Ultima Alteracao: 25/08/02
 * Descricao: passa a verificar se possui pegada dupla.
 **************************************************************************************/
bool Crew::possui_folga() const
{
   int i,d;

   i = m_intervalo();


   if(!this->p_duplas())
   {
      // Se o maior intervalo for maior que 15
    if(i>=T_FOLGA)
        return true;
    else
        return false;
   }
   else //p_duplas
   {
     return true;
   }
}

/********************************************************************
 * Metodo: p_duplas()
 * Objetivo: Calcular o numero de pegadas duplas da jornada.
 * Autor: Leonardo X. T. Cardoso.
 * Ultima alteracao: 25/08/02, Leonardo XT Cardoso
 *******************************************************************/
int Crew::p_duplas() const
{

   //this->ordena_jornada();

   if((jornada.size() <= 1))
   {
   	return 0;
   }
   else if(this->m_intervalo() > 120)
   {
     return 1;
   }
   else
   {
    return 0;
   }
}

/*******************************************************************************
 * Metodo: t_sobreposicao()
 * Objetivo: Calcular tempo de sobreposicao da jornada em minutos.
 * Autor: Leonardo X. T. Cardoso.
 *********************************************************************************/
int Crew::t_sobreposicao() const 
{
   int total = 0;
   cl_iterator iter,next;

   if(jornada.size() == 1)
   {
   	return 0;
   }
   else
   {
   	iter = jornada.begin();
   	next = 	jornada.begin();
   	++next;
   	do{
           if(next->h_inicial < iter->h_final )
   		total = total + (iter->h_final - next->h_inicial);
           ++next;
           ++iter;
   	}while(next != jornada.end());
   }

   return total;
}

/*******************************************************************************
 * Metodo: t_veiculo()
 * Objetivo: Calcularo numero de troca de veiculos da jornada
 * Autor: Leonardo X. T. Cardoso.
 *********************************************************************************/
int Crew::t_veiculo() const 
{

   int total = 0;
   cl_iterator iter,next;

   if(jornada.size() == 1)
   {
   	return 0;
   }
   else
   {
   	iter = jornada.begin();
   	next = 	jornada.begin();
   	++next;
   	do{
   	  if(next->n_veiculo != iter->n_veiculo )
   			total++;
          ++next;
   	  ++iter;
   	}while(next != jornada.end());
	}

   return total;
}

/*******************************************************************************
 * Metodo: tp_proibida()
 * Objetivo: Calcular o numero de trocas de ponto proibida da jornada.
 * Autor: Leonardo X. T. Cardoso.
 *********************************************************************************/
int Crew::tp_proibida() const 
{
   int total = 0;
   cl_iterator iter,next;

   if(jornada.size() == 1)
   {
   	return 0;
   }
   else
   {
        iter = jornada.begin();
	next = 	jornada.begin();
	++next;
	do{
           if(next->p_inicial != iter->p_final )
	        total++;
           ++next;
	   ++iter;
	  }while(next != jornada.end());
    }

    return total;
}

/**********************************************************************************
 * Metodo: tp_permitida()
 * Objetivo: Calcular o numero de trocas de ponto permitida da jornada.
 * Autor: Leonardo X. T. Cardoso.
 *********************************************************************************/
int Crew::tp_permitida() const
{
   int total = 0,m_intervalo;
   cl_iterator iter,next;

   if(jornada.size() == 1)
   {
       return 0;
   }
   else
   {
   	iter = jornada.begin();
   	next = 	jornada.begin();
    m_intervalo = this->m_intervalo();
   	++next;
   	do{
       if(((next->h_inicial - iter->h_final) == m_intervalo)
               && (next->p_inicial != iter->p_final))
       	total++;
       	++next;
    	++iter;
   	}while(next != jornada.end());
   }

	return total;
}

/**********************************************************************************
 * Metodo: t_ocioso()
 * Objetivo: Calcular o tempo ocioso da jornada em minutos.
 * Autor: Leonardo X. T. Cardoso.
 * Ultima alteracao: 12/08/02 - 01:30 a.m
************************************************************************************/
int Crew::t_ocioso() const
{   //$$calcular tempo que esteja faltando para completar jornada.


   int total = 0, duracao = 0, sobra = 0;
   cl_iterator iter,next;
   int f_acum;

   /*if(jornada.size() == 1)
   {
        return 0;
   }
   else
   { */

   //Verificacao de sobra no fim da jornada.
   duracao = this->d_jornada();
   if(!this->p_duplas())
   {
      if(duracao <= MAX_HORAS)
          sobra  = MAX_HORAS - duracao;
   }
   else
   {
      if(duracao <= MAX_HORAS_D)
          sobra = MAX_HORAS_D - duracao;
   }

   if(jornada.size() != 1)
   {
     iter = jornada.begin();
     next = jornada.begin();
     ++next;
     do{
        if((next->h_inicial - iter->h_final) > 0 ) //verificar ociosidade p_dupla.
             total = total + (next->h_inicial - iter->h_final);
     ++next;
     ++iter;
     }while(next != jornada.end());
   }

   f_acum = this->f_acumulada();
   return total + f_acum + sobra;
}


/**********************************************************************************
 * Metodo: et_jornada()
 * Objetivo: Calcular o excesso de tempo ( > 9:10) da jornada em minutos.
 * Autor: Leonardo X. T. Cardoso.
*************************************************************************************/
int Crew::et_jornada() const
{
   return  max(0, (this->d_jornada() - MAX_DIA));
}


/**********************************************************************************
 * Metodo: fte_jornada()
 * Objetivo: Calcular a falta de tempo entre jornadas  em minutos.
 * Autor: Leonardo X. T. Cardoso.
*************************************************************************************/
int Crew::fte_jornada() const
{
   return max(0, (I_JORNADA - this->i_jornada()));
}


/****************************************************************************************************
 * Metodo: f_objetivo()
 * Objetivo: Calcular a funcao objetivo do tripualnte.
 * Autor: Leonardo X. T. Cardoso.
 * Ultima Alterecao: 30/08/02. Nao esta avaliando hora extra. Pois isto agora e feito na avaliacao global.
*****************************************************************************************************/
unsigned long int Crew::f_objetivo()
{
   unsigned long int total;

   jornada.sort();

   total = (pesos.t_ocioso * this->t_ocioso() +
       	    pesos.h_extra * this->h_extra() +
            pesos.d_jornada * this->et_jornada() +
   	    pesos.t_sobreposicao * this->t_sobreposicao() +
	    pesos.tp_proibida * this->tp_proibida() +
	    pesos.tp_permitida * this->tp_permitida() +
	    pesos.t_veiculo * this->t_veiculo() +
	    pesos.i_jornada * this->fte_jornada() );

   return total;
}


/**********************************************************************************
 * Metodo: possui_artificial()
 * Objetivo: Verificar se o tripulante possui tarefa virtual. Retorna true caso tenha.
 * Autor: Leonardo X. T. Cardoso.
 * Data: 25/08/02
*************************************************************************************/
bool Crew::possui_artificial() const
{
    cl_iterator iter;

    if(jornada.size() == 0 )
        return false;
    else
    {
        iter = jornada.end();
        --iter;
        return iter->artificial == true;
    }
}




/******************************************************************************************
 * Metodo: ft_folga()
 * Objetivo: Calcular o tempo que falta para completar a folga obrigatoria do tripulante.
 * Autor: Leonardo X. T. Cardoso.
 * Data: 30/08/02
*******************************************************************************************/
int Crew::ft_folga() const
{
   int total = 0;


  total = this->folga_total() + this->f_acumulada();

  if(total < T_FOLGA){
    return FOLGA_TOTAL_OBRIGATORIA - total;
   }
   else{
    return 15;
   }



}

/******************************************************************************************
 * Metodo: folga_total()
 * Objetivo: Calcular a folga total do tripulante.
 * Autor: Leonardo X. T. Cardoso.
 * Data: 30/08/02
*******************************************************************************************/
int Crew::folga_total() const
{
   int total = 0;

   cl_iterator iter,next;

   if(jornada.size() == 0 || jornada.size() == 1)
   {
    return total;
   }
   else
   {
     iter = jornada.begin();
     next = jornada.begin();
     ++next;
     do{
        if((next->h_inicial - iter->h_final) > 0 )
             total = total + (next->h_inicial - iter->h_final);
     ++next;
     ++iter;
     }while(next != jornada.end());
   }

   return total;

}

/******************************************************************************************
 * Metodo: remover_tarefa()
 * Objetivo: Remover a enesima tarefa do tripulante.
 * Autor: Leonardo X. T. Cardoso.
 * Data: 30/08/02
 * OBS: CUIDADO.O metodo nao verifica se o tripulante possui a tarefa.
*******************************************************************************************/

Task Crew::remover_tarefa(int n)
{
    l_iterator iter;
    Task task;

    //verifica se o tripulante possui tarefa virtual.
    iter = jornada.end();
    --iter;

    if(iter->artificial)
    {
        jornada.erase(iter);
    }

    //posiciona o ponteiro na enesima tarefa
	int i = 0;
    for(iter = jornada.begin(); i < n; ++iter)
		++i;

	task = *iter;
	jornada.erase(iter); //remove


    //verifica se o tripulante possui folga caso positivo adiciona uma tarefa virtual.
    if(!this->possui_folga())
    {
        l_iterator iter1;
        Task t;

        iter1 = jornada.end();
        --iter1;

        t = *  new Task(iter1->n_veiculo, iter1->h_final, iter1->h_final + this->ft_folga(),
                        iter1->p_final, iter1->p_final, 0, iter1->l_final,
                        iter1->l_final, true);

        jornada.push_back(t);
    }
    else if((this->folga_total() + this->f_acumulada()) < FOLGA_TOTAL_OBRIGATORIA)
    {
        l_iterator iter1;
        Task t;
        int tempo;

        iter1 = jornada.end();
        --iter1;

        tempo = FOLGA_TOTAL_OBRIGATORIA - (this->folga_total() + this->f_acumulada());

        t = *  new Task(iter1->n_veiculo, iter1->h_final, iter1->h_final + tempo,
                        iter1->p_final, iter1->p_final, 0, iter1->l_final,
                        iter1->l_final, true);

        jornada.push_back(t);
    }

	return task;

}

void Crew::remover_tarefa(const Task& task)
{
    l_iterator iter;

    if(jornada.size() == 0)
     {
        return;
     }
     else
     {
         //verifica se o tripulante possui tarefa virtual.
        iter = jornada.end();
        --iter;

        if(iter->artificial)
        {
            //jornada.erase(iter);
            jornada.erase(iter);
        }


        for(iter = jornada.begin(); iter != jornada.end(); ++iter)
		    if ( *iter == task ){
                jornada.erase(iter);
                break;
            }
     }

     if(jornada.size() == 0)
     {
        return;
     }

     jornada.sort();

    //verifica se o tripulante possui folga caso negativo adiciona uma tarefa virtual.
    if(!this->possui_folga())
    {
        l_iterator iter1;
        Task t;

        iter1 = jornada.end();
        --iter1;

        t = *  new Task(iter1->n_veiculo, iter1->h_final, iter1->h_final + this->ft_folga(),
                        iter1->p_final, iter1->p_final, 0, iter1->l_final,
                        iter1->l_final, true);

        jornada.push_back(t);
    } 
    else if((this->folga_total() + this->f_acumulada()) < FOLGA_TOTAL_OBRIGATORIA)
    {
        l_iterator iter1;
        Task t;
        int tempo;

        iter1 = jornada.end();
        --iter1;

        tempo = FOLGA_TOTAL_OBRIGATORIA - (this->folga_total() + this->f_acumulada());

        t = *  new Task(iter1->n_veiculo, iter1->h_final, iter1->h_final + tempo,
                        iter1->p_final, iter1->p_final, 0, iter1->l_final,
                        iter1->l_final, true);

        jornada.push_back(t);
    }  

}
