//---------------------------------------------------------------------------
#include <vcl>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>

#define MAX(x,y) ((x)<(y) ? (y) : (x))

#pragma hdrstop



int *cria_vetor(int tam);

double *cria_vetor_double(int tam);

void libera_vetor(int *vetor);

void le_arq_vetor(char nomearq[],
                  int *vetor);

void le_arq_vetor_denso(char nomearq[],
                        int *vetor);

void constroi_solucao_aleatoria(int *s,
                                int num_objetos,
                                int *lim);
void imprime_solucao(int *s,
                     int num_objetos);

int calcula_fo(int *s,
               int num_objetos,
               int *p,
               int inviabilidade,
               int penalidade);

int troca_quantidade(int *s,
                      int j,
                      int q,
                      int *lim);

int calcula_peso_objetos(int *s,
                         int num_objetos,
                         int *w);

int calcula_inviabilidade(int peso_objetos,
                          int capacidade);

int calcula_penalidade(int *w,
                       int num_objetos,
                       int *lim);

void imprime_solucao(int *s,
                     int *w,
                     int num_objetos);

void inicializa_vetor(int *vetor,
                      int tam);

void imprime_fo(char nomearq[],
                float tempo,
                int fo,
                int iteracao);

void limpa_arquivo(char nomearq[]);

int menu_solucao_inicial(void);


int menu_principal(void);

void descida1opt(int n,
                 int *s,
                 int *p,
                 int *w,
                 int b,
                 int penalidade,
                 int *peso_objetos,
                 int *fo,
                 int *lim,
                 int inv,
                 double percentual);

void descida2opt(int n,
                 int *s,
                 int *p,
                 int *w,
                 int b,
                 int penalidade,
                 int *peso_objetos,
                 int *fo,
                 int *lim);

void vnd(int n,
         int *s,
         int *p,
         int *w,
         int b,
         int penalidade,
         int *peso_objetos,
         int *fo,
         int *lim);

void vizqq1opt(int n,
               int *s,
               int *p,
               int *w,
               int b,
               int penalidade,
               int *peso_objetos,
               int *fo,
               int *lim);

void vizqq2opt(int n,
               int *s,
               int *p,
               int *w,
               int b,
               int penalidade,
               int *peso_objetos,
               int *fo,
               int *lim);

void vns(int n,
         int *s,
         int *p,
         int *w,
         int b,
         int penalidade,
         int *peso_objetos,
         int *fo,
         int *lim,
         double tempo);

//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char **argv)
{
  int n;                // numero de objetos
  int b;                // capacidade da mochila
  int *s;               // vetor solucao corrente
  int *w;               // vetor de peso de cada objeto
  int *p;               // vetor de beneficio de cada objeto
  int fo;               // funcao objetivo corrente
  int inv;              // quantidade de inviabilidade da solucao corrente
  int penalidade;       // penalidade por superar a capacidade da mochila
  int peso_objetos;     // peso dos objetos na solucao corrente
  int *lim;             // limite de um dado objeto na mochila
  int choice;           // escolha do menu

  int delta;            // variacao de energia
  srand(1000);          // pega o numero 1000 como semente de numeros aleatorios
  //srand((unsigned) time(NULL)); // pega a hora do relogio como semente
  //n = 10;
  n = 50;
  //b = 30;
  b = 100;

  s = cria_vetor(n);
  w = cria_vetor(n);
  p = cria_vetor(n);
  lim = cria_vetor(n);
  inicializa_vetor(w,n);
  inicializa_vetor(p,n);
  inicializa_vetor(lim,n);

  //le_arq_vetor_denso("peso10.txt", w);
  //le_arq_vetor_denso("beneficio10.txt", p);
  //le_arq_vetor_denso("limite10.txt", lim);

  le_arq_vetor_denso("peso50.txt", w);
  le_arq_vetor_denso("beneficio50.txt", p);
  le_arq_vetor_denso("limite50.txt", lim);

  penalidade = calcula_penalidade(w, n, lim);

  do {
    choice = menu_principal();
    switch (choice)
    {
    case 1: // Geracao de uma solucao inicial
         constroi_solucao_aleatoria(s, n, lim);
         printf("Solucao aleatoria:\n");
         imprime_solucao(s,w,n);
         peso_objetos = calcula_peso_objetos(s, n, w);
         inv = calcula_inviabilidade(peso_objetos, b);

         fo = calcula_fo(s, n, p, inv, penalidade);
         printf("funcao objetivo = %3d \n",fo);
         printf("peso dos objetos = %2d inviabilidade = %d \n",peso_objetos, inv);
         break;

    case 2: /* VND */
          if (fo != 0) vnd(n, s, p, w, b, penalidade, &peso_objetos, &fo, lim);
          else {
             printf("\n ----- Gere uma solucao inicial ------\n");
             getchar();
          }
          break;
    case 3: /* VNS */
          if (fo != 0) vns(n, s, p, w, b, penalidade, &peso_objetos, &fo, lim, 20.0);
          else {
             printf("\n ----- Gere uma solucao inicial ------\n");
             getchar();
          }
          break;
    default:
          break;
    }
  } while (choice != 0);


  libera_vetor(s);
  libera_vetor(w);
  libera_vetor(p);
  libera_vetor(lim);
  return 0;
} // fim do programa principal


//---------------------------------------------------------------------------


// cria memoria para um vetor de tam posicoes
int *cria_vetor(int tam)
{
  int *vetor;

  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}


// cria memoria para um vetor de tam posicoes
double *cria_vetor_double(int tam)
{
  double *vetor;

  vetor = (double *) malloc(tam*sizeof(double));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}


// libera memoria de um vetor
void libera_vetor(int *vetor)
{
  free(vetor);
}


// le um arquivo no formato i, valor
void le_arq_vetor(char nomearq[], int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  while (!feof(arquivo)){
    fscanf(arquivo, "%d, %d", &j, &valor);
    vetor[j] = valor;
  }
  fclose(arquivo);
}

// Nesta leitura, vetor[j] = valor para todo j=0...n
void le_arq_vetor_denso(char nomearq[], int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  j = 0;
  while (!feof(arquivo)){
    fscanf(arquivo, "%d", &valor);
    vetor[j] = valor;
    j++;
  }
  fclose(arquivo);
}



// constroi uma solucao inicial aleatoria
void constroi_solucao_aleatoria(int *s, int num_objetos, int *lim)
{
    for (int j=0; j<num_objetos; j++) s[j] = (int)random(lim[j]+1);
}


// imprime a solucao
void imprime_solucao(int *s, int *w, int num_objetos)
{
    printf(" [s]  |  [w] \n");
    for (int j=0; j<num_objetos; j++)
    {

        printf(" [%d]  |  [%d]\n",s[j], w[j]);

    }
}


// calcula a funcao objetivo
int calcula_fo(int *s, int num_objetos, int *p, int inviabilidade, int penalidade)
{
    //int j;
    int beneficio = 0;

    for (int j=0; j<num_objetos; j++){
    	if (s[j]) {
          beneficio += s[j]*(p[j]);
        }
    }
    return beneficio - (penalidade)*(inviabilidade);
}


// insere ou retira o objeto j da mochila
int troca_quantidade(int *s, int j, int q, int *lim)
{
    //int qt;
    if (q > 0)
    {
        if ((s[j]+q) <= lim[j])
        {
               s[j]+=q;
               return q;
        }
        else
        {
               s[j]=lim[j];
               return 0;
        }
    }
    else
    {
        if ((s[j]+q) < 0)
        {
               int result =s[j];
               s[j] = 0;
               return (-1)*(result);
        }
        else
        {
               s[j]+=q;
               return q;
        }
    }
}


// calcula o peso dos objetos na mochila
int calcula_peso_objetos(int *s, int num_objetos, int *w)
{
    int peso = 0;

    for (int j=0; j<num_objetos; j++)
        peso += (w[j])*(s[j]);
    return peso;
}


// calcula o excesso de peso na mochila
int calcula_inviabilidade(int peso_objetos, int capacidade)
{
    return MAX(0, peso_objetos - capacidade);
}

// calcula a penalidade por exceder a capacidade da mochila
int calcula_penalidade(int *w, int num_objetos, int *lim)
{
    int penalidade = 0;
    for (int j=0; j<num_objetos; j++)
        penalidade += (w[j])*(lim[j]);
    return penalidade;
}


void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++)
        vetor[j] = 0;
}

void imprime_fo(char nomearq[], float tempo, int fo, int iteracao)
{
    FILE *arquivo;
    arquivo = fopen(nomearq,"a+");

    if (!arquivo){
        printf("O arquivo %s nao pode ser aberto",nomearq);
        getchar();
        exit(1);
    }
    fprintf(arquivo,"%4.2f\t  %4d\t  %5d\n",tempo, iteracao, fo);
    fclose(arquivo);
}


void limpa_arquivo(char nomearq[])
{
  FILE *arquivo;
  arquivo = fopen(nomearq,"w");
  if (!arquivo){
     printf("O arquivo %s nao pode ser aberto",nomearq);
     getchar();
     exit(1);
  }
  fclose(arquivo);
}


// Menu principal
int menu_principal(void)
{
  int escolha;

  do {
    printf("\n************************************************* \n");
    printf("         1. Gerar solucao inicial Aleatoria \n");
    printf("         2. VND \n");
    printf("         3. VNS \n");
    printf("         0. Sair \n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 0 || escolha > 3);
  return escolha;
}

void descida1opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, int *lim, double percentual)
{
    int delta, melhor_delta, melhor_posicao, melhor_troca;
    int fa, inv, qt, n_vizinhos = MAX(0, (int)(percentual*n));

    melhor_delta = INT_MAX;




    while(melhor_delta > 0) //while 1
    {
        melhor_delta = 0;


        for (int j=0; j < n_vizinhos; j++) //for 1
        {
            qt = troca_quantidade(s, j, 1, lim);
            if (qt > 0)
            {
                *peso_objetos = calcula_peso_objetos(s,n,w);
                inv = calcula_inviabilidade(*peso_objetos, b);
                fa = calcula_fo(s, n, p, inv, penalidade);
                delta = (fa-(*fo));
                if ((delta > melhor_delta)) //if 1
                //if (fa > *fo)
                {
                        melhor_delta = delta;
                        //*fo = fa
                        melhor_posicao = j;
                        melhor_troca = qt;
                }//if 1


            }
            troca_quantidade(s, j, (-1)*(qt), lim);
            *peso_objetos = calcula_peso_objetos(s,n,w);
             inv = calcula_inviabilidade(*peso_objetos, b);
        }//for 1

        for (int j=0; j < n_vizinhos; j++) //for 2
        {
            qt = troca_quantidade(s, j, (-1), lim);
            if (qt < 0) // if 1
            {
                *peso_objetos = calcula_peso_objetos(s,n,w);
                inv = calcula_inviabilidade(*peso_objetos, b);
                fa = calcula_fo(s, n, p, inv, penalidade);
                delta = (fa-(*fo));
                if ((delta > melhor_delta)) //if 2
                {
                        melhor_delta = delta;
                        melhor_posicao = j;
                        melhor_troca = (-1);
                }//if 2
                troca_quantidade(s, j, (-1)*(qt),lim);
                *peso_objetos = calcula_peso_objetos(s,n,w);
                inv = calcula_inviabilidade(*peso_objetos, b);
            }// if1

        }//for 2

        if (melhor_delta > 0) //if 2
        {
            *fo += melhor_delta;
            troca_quantidade(s, melhor_posicao, melhor_troca, lim); // s <-- s
            *peso_objetos = calcula_peso_objetos(s,n,w);
            inv = calcula_inviabilidade(*peso_objetos, b);

        }//if 2

    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo Metodo da descida 1 Optimal:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
    //libera_vetor(vet);
}//descida1opt

void descida2opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, int *lim)
{
    int delta, inv, fa, qt1, qt2, melhor_delta, melhor_posicao1,melhor_posicao2;

    melhor_delta = INT_MAX;

    while(melhor_delta > 0) //while 1
    {
        melhor_delta = -INT_MAX;

        for (int i = 0; i < n-1; i++)//for1
        {

           qt1 = troca_quantidade(s,i,(-1),lim);
           if (qt1 < 0) // if 1
           {
                for (int j = i+1; j < n; j++) //for2
                {
                        qt2 = troca_quantidade(s,j,1,lim);
                        if (qt2 > 0)// if 2
                        {
                                *peso_objetos = calcula_peso_objetos(s,n,w);
                                inv = calcula_inviabilidade(*peso_objetos, b);
                                fa = calcula_fo(s, n, p, inv, penalidade);
                                delta = (fa-(*fo));

                                if ((delta > melhor_delta)) //if 3
                                {
                                        melhor_delta = delta;
                                        melhor_posicao1 = i;
                                        melhor_posicao2 = j;
                                }//if 3 (delta < melhor_delta
                                troca_quantidade(s, j, (-1)*(qt2) , lim);
                                *peso_objetos = calcula_peso_objetos(s,n,w);
                                inv = calcula_inviabilidade(*peso_objetos, b);
                        }// if 2 qt > 0
                }//for2
                troca_quantidade(s, i, (-1)*(qt1), lim);
                *peso_objetos = calcula_peso_objetos(s,n,w);
                inv = calcula_inviabilidade(*peso_objetos, b);
           } // if 1 qt < 0
        }//for1

        if (melhor_delta > 0) //if 2
        {
            *fo += melhor_delta;
            troca_quantidade(s, melhor_posicao1, (-1), lim); // s <-- s
            troca_quantidade(s, melhor_posicao2, 1, lim);
            *peso_objetos = calcula_peso_objetos(s,n,w);
            inv = calcula_inviabilidade(*peso_objetos, b);
        }//if 2

    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo Metodo da descida 2 Optimal:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
}//descida2opt

void vnd(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, int *lim)
{
    int *sl;
    int peso_objsl,fosl;
    sl = cria_vetor(n);
    inicializa_vetor(sl,n);
    for (int i = 0; i < n; i++)
    {
        sl[i] = s[i];
    }
    peso_objsl = 0;
    peso_objsl += (*peso_objetos);
    fosl = 0;
    fosl += (*fo);

    int k = 1;

    while(k <=2) //while 1
    {
       switch(k)
       {
       case 1: descida1opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl, lim, 0.8);
               break;
       case 2: descida2opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl, lim);
               break;
       }
       if (fosl > (*fo))
       {
          for (int i = 0; i < n; i++)
          {
                s[i] = sl[i];
          }
          *fo = fosl;
          *peso_objetos = peso_objsl;
          k = 1;
       }
       else k++;
    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo VND:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
    printf("Solucao Encontrada:\n");
    imprime_solucao(s,w,n);
    libera_vetor(sl);
}//vnd


void vizqq1opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, int *lim)
{
    int pos, inv, q;
    q = random(2);
    if (q==0) q=(-1);
    pos = random(n);
    troca_quantidade(s, pos, q, lim);
    *peso_objetos = calcula_peso_objetos(s,n,w);
    inv = calcula_inviabilidade(*peso_objetos, b);
    *fo = calcula_fo(s, n, p, inv, penalidade);


}//vizqq1opt

void vizqq2opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, int *lim)
{
    int p1, p2, quanti, inv;
    p1 = random(n);
    p2 = random(n);
    while (p1 == p2) p2 = random(n);
    quanti = troca_quantidade(s, p1, (-1), lim);
    troca_quantidade(s, p2, quanti, lim);
    *peso_objetos = calcula_peso_objetos(s,n,w);
    inv = calcula_inviabilidade(*peso_objetos, b);
    *fo = calcula_fo(s, n, p, inv, penalidade);
}//vizqq2opt


void vns(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, int *lim, double tempo)
{
    int *sl;
    int peso_objsl,fosl;
    sl = cria_vetor(n);
    clock_t inicioCPU, fimCPU;
    inicioCPU = fimCPU = clock();

    while((fimCPU - inicioCPU) / CLK_TCK < tempo) //while1
    {
       int k = 1;
       while(k <= 2) //while2
       {
          for (int i = 0; i < n; i++) sl[i] = s[i];
          peso_objsl = *peso_objetos;
          fosl = *fo;
          switch(k){ //Gere um vizinho qualquer na vizinhanca corrente
          case 1: vizqq1opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl, lim);
                  break;
          case 2: vizqq2opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl, lim);
                  break;
          }
          vnd(n,sl,p,w,b,penalidade,&peso_objsl, &fosl,lim);
          if (fosl > *fo)
          {
             for (int i = 0; i < n; i++) s[i] = sl[i];
             *fo = fosl;
             *peso_objetos = peso_objsl;
             k = 1;
          }
          else k++;
       }//while2
       fimCPU = clock();
    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo VNS em %0.f segundos:\n", tempo);
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
    printf("Solucao Encontrada:\n");
    imprime_solucao(s,w,n);
    libera_vetor(sl);
}//vns
