//---------------------------------------------------------------------------
#include <condefs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <float.h>
#include <errno.h>
#include <math.h>
#include <limits.h>

// Lista tabu
struct listatabu {
	int no1;
        int no2;
  	struct listatabu *proximo;  /* ponteiro para a prxima entrada */
  	struct listatabu *anterior; /* ponteiro para o registro anterior */
};
void apagalistatabu(struct listatabu **iniciotabu,
		    struct listatabu **finaltabu);

void apagaregistrotabu(struct listatabu *registro,
                       struct listatabu **iniciotabu,
                       struct listatabu **finaltabu);
void displaylistatabu(struct listatabu **iniciotabu,
            	      struct listatabu **finaltabu);
bool estalistatabu(int no1,
                   int no2,
                   struct listatabu **iniciotabu);
void inserelistatabu(struct listatabu *i,
                     struct listatabu **iniciotabu,
                     struct listatabu **finaltabu);
int lenghtlistatabu(struct listatabu **iniciotabu,
                    struct listatabu **finaltabu);

struct listatabu *procuraregistrolistatabu(int no1,
                                           int no2,
                                           struct listatabu **iniciotabu);

//Fim das operaes com a lista tabu

double randomico(double min, double max);
float calcula_distancia(int tam_caminho,float **distancia, int *caminho);
int **criamatriz(int nlinhas, int ncolunas);
float **criamatrizfloat(int nlinhas, int ncolunas);
int *criavetor(int tam);
int minimo_de_caminhoes(int *demanda,int tam,int capacidade);
int numero_de_caminhoes(int tam_caminho, int *caminho);
int numero_de_inviabilidades(int tam_caminho, int capacidade,
                             int *caminho, int *demanda);
void atualiza_caminho(int tam_caminho, int *caminho, int *caminho_star);
void BT(float tempo_max, int BT_max, int tam_lista, int tam_caminho, int *caminho,
        float *fo, float **distancia, int n_cidades, int pena, int capacidade,
        int *demanda, float *fomin, int *caminho_star, clock_t inicioCPU,
        int iter_max_planas, int aumento_na_lista);
void Erro(char *texto);
void gera_solucao_inicial(int *demanda, int tam_caminho, int *caminho,
                          int n_cidades, int *caminho_star);
void imprime_matrizcusto(float **distancia, int n_cidades);
void imprime_resultados(float fomin, int *demanda, int n, int capacidade,
                        int *caminho_star, float **distancia,
                        int tam_caminho);
void imprime_valor_fo(char *nomearq, float tempo, float fo, int *iteracao);
void imprime_vetor(int *vetor, int tam);
void inicializamatriz(float **matriz, int nlinhas, int ncolunas);
void inicializavetor(int *vetor, int tam);
void learqmatriz(char *nomearq, float **matriz);
void learqvetor(char *nomearq, int *vetor);
void liberamatrizfloat(float **matriz, int nlinhas);
void liberavetor(int *vetor);
void limpa_arquivo(char *nomearq);
void melhor_vizinho(int *melhor_no1, int *melhor_no2,
                    float *melhor_delta, int tam_caminho,
                    int *caminho, const float fo, float **distancia,
                    int n_cidades, int pena, int capacidade,
                    int *demanda, const float fomin, int *caminho_star,
                    struct listatabu **iniciotabu,
                    struct listatabu **finaltabu);
void SA(float tempo_max, float temperatura, float alfa, int SAmax, int tam_caminho, int *caminho,
        float *fo, float **distancia, int n_cidades, int pena, int capacidade,
        int *demanda, float *fomin, int *caminho_star, clock_t inicioCPU);
void troca(int no1,int no2, int *caminho);

#pragma hdrstop

//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char* argv[])
{
  clock_t inicioCPU, fimCPU;
  inicioCPU = fimCPU = clock();
  float **distancia;     // Matriz com a distncia entre os ns
  int *demanda;        // Vetor com a necessidade de cada n
  int *caminho;        // Caminho percorrido pelo caminho
  int n_cidades = 50;   // Nmero de cidades a serem percorridas
  int capacidade = 160; // Capacidade de cada caminho
  float fo;
  float fomin;
  int *caminho_star;
  int pena = 1000;
  float tempo_max = 30;
  unsigned long seed = 19000;//(unsigned) time(NULL);
  srand(seed);


  //---------------------------------------------------------------------------
  /* INICIALIZANDO AS VARIVEIS */
  distancia = criamatrizfloat(n_cidades + 1, n_cidades + 1);
  inicializamatriz(distancia, n_cidades + 1, n_cidades + 1);
  learqmatriz("distancia.dat", distancia);
  //imprime_matrizcusto(distancia, n_cidades);
  //getchar();

  demanda = criavetor(n_cidades + 1);
  inicializavetor(demanda, n_cidades + 1);
  learqvetor("demanda.dat", demanda);
  //imprime_vetor(demanda, n_cidades + 1);
  int min_cam = minimo_de_caminhoes(demanda, n_cidades + 1, capacidade);
  printf("Minimo de caminhoes = %d\n", min_cam);
  //getchar();

  int tam_caminho = n_cidades + min_cam + 1; // Tamanho do caminho no melhor caso
  caminho = criavetor(tam_caminho);
  caminho_star = criavetor(tam_caminho);
  inicializavetor(caminho, tam_caminho);
  inicializavetor(caminho_star, tam_caminho);
  gera_solucao_inicial(demanda, tam_caminho, caminho, n_cidades,
                       caminho_star);
 //imprime_vetor(caminho, tam_caminho);
 // getchar();
  fo =   calcula_distancia(tam_caminho, distancia, caminho)
       + pena*numero_de_inviabilidades(tam_caminho, capacidade, caminho,
                                       demanda);
  fomin = fo;
  printf("Fo = %f\n", fo);
 // getchar();
//---------------------------------------------------------------------------

  /*PARAMETROS DO SIMULATED ANNEALING */
  float temperatura = 10000; //Temperatura inicial
  float alfa = 0.97;         //Taxa de resfriamento
  int SAmax = 10000;          //Nmero de iteraes a uma certa temperatura
//---------------------------------------------------------------------------
 /*PARAMETROS DO BUSCA TABU */
  int BT_max = 2000;
  int tam_lista = 0.8*n_cidades;
  int iter_max_planas = 5;
  int aumento_na_lista = 10;
//---------------------------------------------------------------------------

  int opcao;
  printf("Digite a sua escolha para rodar o programa \n\n");
  printf("Digite 1 para usar o SIMULATED ANNEALING\n");
  printf("Digite 2 para usar o BUSCA TABU\n");
  printf("Digite 3 para usar o Hibrido\n");
  scanf("%d",&opcao);
  getchar();
//  opcao = 2;
  switch (opcao){
//---------------------------------------------------------------------------
	case  1:
           printf("Tecle enter para entrar no SIMULATED ANNEALING\n");
           //getchar();
                 /* ENTRANDO NO SIMULATED ANNEALING */
           SA(tempo_max, temperatura, alfa, SAmax, tam_caminho, caminho, &fo, distancia, n_cidades,
              pena, capacidade, demanda, &fomin, caminho_star, inicioCPU);
           break;
//---------------------------------------------------------------------------
        case  2:
             /* ENTRANDO NO BUSCA TABU */
             printf("Tecle enter para entrar no BUSCA TABU\n");
             //getchar();
             BT(tempo_max, BT_max, tam_lista, tam_caminho, caminho, &fo, distancia,
                n_cidades, pena, capacidade, demanda, &fomin, caminho_star,
                inicioCPU, iter_max_planas, aumento_na_lista);
             break;
//---------------------------------------------------------------------------
        case  3:
             printf("Tecle enter para entrar no SIMULATED ANNEALING\n");
             //getchar();
             /* ENTRANDO NO SIMULATED ANNEALING */
             SA(tempo_max/20, temperatura, alfa, SAmax, tam_caminho, caminho, &fo, distancia, n_cidades,
                pena, capacidade, demanda, &fomin, caminho_star, inicioCPU);
             fo = fomin;
             atualiza_caminho(tam_caminho, caminho_star, caminho);
//---------------------------------------------------------------------------
             /* ENTRANDO NO BUSCA TABU */
             printf("Tecle enter para entrar no BUSCA TABU\n");
             //getchar();
             BT(tempo_max, BT_max, tam_lista, tam_caminho, caminho, &fo, distancia,
                n_cidades, pena, capacidade, demanda, &fomin, caminho_star,
             inicioCPU, iter_max_planas, aumento_na_lista);
             break;
//---------------------------------------------------------------------------
        default:
             printf("Tecle enter para entrar no SIMULATED ANNEALING\n");
             //getchar();
        /* ENTRANDO NO SIMULATED ANNEALING */
             SA(tempo_max, temperatura, alfa, SAmax, tam_caminho, caminho, &fo, distancia, n_cidades,
                pena, capacidade, demanda, &fomin, caminho_star, inicioCPU);
             break;
  }

  fimCPU = clock();
  imprime_resultados(fomin, demanda, n_cidades, capacidade, caminho_star,
                     distancia, tam_caminho);
  //imprime_vetor(caminho_star, tam_caminho);

  printf("Tempo de execucao do Programa = %15.7f\n\n",(float)(fimCPU - inicioCPU)/CLOCKS_PER_SEC);

  printf("Tecle enter para encerrar o programa");
  getchar();

  liberamatrizfloat(distancia, n_cidades + 1);
  liberavetor(demanda);
  liberavetor(caminho);
  liberavetor(caminho_star);

        return 0;
}
//---------------------------------------------------------------------------
void BT(float tempo_max, int BT_max, int tam_lista, int tam_caminho, int *caminho,
        float *fo, float **distancia, int n_cidades, int pena, int capacidade,
        int *demanda, float *fomin, int *caminho_star, clock_t inicioCPU,
        int iter_max_planas, int aumento_na_lista)
{
  clock_t iniciotabuCPU, fimtabuCPU;
  iniciotabuCPU = inicioCPU;
  fimtabuCPU = clock();
  struct listatabu *tabu;
  struct listatabu *iniciotabu;  /* ponteiro para a primeira entrada da lista */
  struct listatabu *finaltabu;  /* ponteiro para a ltima entrada */
  int iter, melhor_iter;
  int melhor_no1, melhor_no2;
  float melhor_delta;
  int x = 0.7*n_cidades;
  int tamanho_lista_corrente = tam_lista;
  iter = melhor_iter = 0;
  tabu = iniciotabu = finaltabu = NULL;
  int cont = 0;
  limpa_arquivo("fo_BT.out");
  imprime_valor_fo("fo_BT.out", (float)(fimtabuCPU - iniciotabuCPU)/CLOCKS_PER_SEC, *fo, &iter);
  do{
  do{
     iter++;
     int m = 1;
     while ( m == 1){
        melhor_vizinho(&melhor_no1, &melhor_no2, &melhor_delta, tam_caminho,
                       caminho, *fo, distancia, n_cidades, pena,
                       capacidade, demanda, *fomin, caminho_star,
                       &iniciotabu,
                       &finaltabu);

        if (melhor_delta == INT_MAX){
           while (lenghtlistatabu(&iniciotabu, &finaltabu) > 1){
              apagaregistrotabu(iniciotabu, &iniciotabu, &finaltabu);
           }
        }
        else{
          m = m -1;
        }
     }
     printf("melhor delta = %4f\n", melhor_delta);
     printf("no1 = %2d no2 = %2d \n", melhor_no1, melhor_no2);
       /* vou reservar memoria para mais um registro da lista tabu */
     tabu = (struct listatabu *)malloc(sizeof(struct listatabu));
     if (!tabu) {
       printf("Faltando memoria ...\n");
       exit(1);
     }
       /* vou inserir um registro na lista tabu */
     tabu->no1  = melhor_no1;
     tabu->no2 = melhor_no2;
     inserelistatabu(tabu, &iniciotabu, &finaltabu);
       /* vou calcular o tamanho da lista tabu e imprimi-la */
     //printf("Tamanho da lista tabu = %2d\n",lenghtlistatabu(&iniciotabu, &finaltabu));
     //displaylistatabu(&iniciotabu, &finaltabu);
       /* vou manter uma lista tabu com tamanholistamax elementos, isto e',
          se a lista tiver mais que tamanholistamax elementos, vou apagar o
          primeiro registro da lista */
     if (lenghtlistatabu(&iniciotabu, &finaltabu) > tamanho_lista_corrente){
        apagaregistrotabu(iniciotabu, &iniciotabu, &finaltabu);
     }
     troca(melhor_no1, melhor_no2, caminho);
     *fo = *fo + melhor_delta;
     fimtabuCPU = clock();
     if (melhor_delta == 0){
       cont++;
       if (cont >= iter_max_planas){
         tamanho_lista_corrente += aumento_na_lista;
        //printf("novo Tamanho da lista tabu = %2d\n",tamanholistamaxcorrente);
        /*printf("Pressione Enter para continuar o Programa.\n");
        getchar();*/
       }
     }
     else{
         cont=0;
     }
     if(*fo < *fomin){
       fimtabuCPU = clock();
       imprime_valor_fo("fo_BT.out", (float)(fimtabuCPU - iniciotabuCPU)/CLOCKS_PER_SEC, *fo, &iter);
       *fomin = *fo;
       melhor_iter = iter;
       atualiza_caminho(tam_caminho, caminho, caminho_star);
       tamanho_lista_corrente = tam_lista;
       printf("iter = %3d  ***   fomin = %5f\n", iter, *fomin);
       //getchar();
    }
    printf("fo = %5f     iteracoes sem melhora = %5d\n",*fo, iter - melhor_iter);
    //getchar();
    fimtabuCPU = clock();
    if (iter - melhor_iter == (0.8*BT_max)){
         while (lenghtlistatabu(&iniciotabu, &finaltabu) > 1){
            apagaregistrotabu(iniciotabu, &iniciotabu, &finaltabu);
         }

    }

  }while(iter - melhor_iter < BT_max);
    melhor_iter = iter;
    while (lenghtlistatabu(&iniciotabu, &finaltabu) > 1){
      apagaregistrotabu(iniciotabu, &iniciotabu, &finaltabu);
    }
    fimtabuCPU = clock();
    tamanho_lista_corrente = random(x) + 0.2*n_cidades;
    atualiza_caminho(tam_caminho, caminho_star, caminho);
    *fo = *fomin;
  }while(tempo_max > (float)(fimtabuCPU - iniciotabuCPU)/CLOCKS_PER_SEC);
  fimtabuCPU = clock();
  printf("Tempo de execucao da busca tabu = %7.2f segundos\n",(float)(fimtabuCPU - iniciotabuCPU)/CLOCKS_PER_SEC);
  /*printf("Pressione Enter para continuar o Programa.\n");
  getchar();*/
  //printf("fominfinal=%d\n",*fomin);
}
void melhor_vizinho(int *melhor_no1, int *melhor_no2,
                    float *melhor_delta, int tam_caminho,
                    int *caminho, const float fo, float **distancia,
                    int n_cidades, int pena, int capacidade,
                    int *demanda, const float fomin, int *caminho_star,
                    struct listatabu **iniciotabu,
                    struct listatabu **finaltabu)
{
 bool esta_na_lista;
 *melhor_delta = INT_MAX;
 int i,j;
 float delta;
    for (i = 1; i < tam_caminho - 2; i++){
       j = i + 1;
       for (;j < tam_caminho - 1; j++){
          if (caminho[i] != caminho[j]){
            delta = -fo;
            troca(i, j, caminho);
            delta += +calcula_distancia(tam_caminho, distancia, caminho)
                     +pena*numero_de_inviabilidades(tam_caminho, capacidade, caminho,
                                                    demanda);
            troca(i, j, caminho);
            esta_na_lista = (estalistatabu(i, j, iniciotabu))||(estalistatabu(j, i, iniciotabu));
            //if (esta_na_lista) printf("!!!!!A no1 %2d e o no2 %2d estao na lista\n", i, j);
            if (!esta_na_lista || (esta_na_lista && fo + delta < fomin)){
               if(delta < *melhor_delta){
                 *melhor_no1 = i;
                 *melhor_delta = delta;
                 //printf("melhor = %d\n", *melhordelta);
                 /*printf("Pressione Enter para continuar o Programa.\n");
                 getchar();*/
                 *melhor_no2 = j;
               }
            }
          }
          else continue;
       }
    }
}
 /*Imprime os valores de fo em funo da iterao e do tempo*/
 void imprime_valor_fo(char *nomearq, float tempo, float fo, int *iteracao)
{

 FILE *arquivo;
 arquivo = fopen(nomearq,"a+");

 if (!arquivo){
   printf("O arquivo %s nao pode ser aberto",nomearq);
   exit(1);
 }
 fprintf(arquivo,"%4.2f\t  %4.2f\t  %5d\n",tempo, fo, *iteracao);
 fclose(arquivo);
}


void SA(float tempo_max, float temperatura_ini, float alfa, int SAmax, int tam_caminho, int *caminho,
        float *fo, float **distancia, int n_cidades, int pena, int capacidade,
        int *demanda, float *fomin, int *caminho_star, clock_t inicioCPU)
{

  clock_t inicioSA, fimSA;
  inicioSA = fimSA = inicioCPU;
  float aleatorio;
  int no1,no2,x;
  float delta;
  int iter = 0;
  int div = 1;
  float temperatura;
  x = tam_caminho - 2;
  limpa_arquivo("fo_SA.out");
  imprime_valor_fo("fo_SA.out", (float)(fimSA - inicioSA)/CLOCKS_PER_SEC, *fo, &iter);
  do{
    temperatura = temperatura_ini/div;
  while (temperatura > 0.1){
     for(int iteracao = 0; iteracao < SAmax; iteracao++){
        iter ++;
        no1 = random(x) + 1;
        no2 = random(x) + 1;
        while (caminho[no2] == caminho[no1]){
          no2 = random(x) + 1;
        }
        delta = -(*fo);
        troca(no1,no2, caminho);
        delta += +calcula_distancia(tam_caminho, distancia, caminho)
                 +pena*numero_de_inviabilidades(tam_caminho, capacidade, caminho,
                                                demanda);
        if( delta < 0 ){
          (*fo) = (*fo) + delta;
          if( (*fo) < (*fomin)){
            (*fomin) = (*fo);
            printf("Fomin = %f\n", (*fomin));
            fimSA = clock();
            imprime_valor_fo("fo_SA.out", (float)(fimSA - inicioSA)/CLOCKS_PER_SEC, *fo, &iter);
            atualiza_caminho(tam_caminho, caminho, caminho_star);
          }
        }
        else{
           aleatorio = randomico(0,1);
           if (aleatorio < exp((-1)*(double) delta/temperatura)) {
             (*fo) = (*fo) + delta;
           }
           else troca(no1,no2, caminho);
        }

     }
     temperatura = temperatura*alfa;
  }
  fimSA = clock();
  div++;
  }while(tempo_max > (float)(fimSA - inicioSA)/CLOCKS_PER_SEC);
  fimSA = clock();
  printf("Tempo de execucao do Simulated Annealing = %15.7f\n\n",(float)(fimSA - inicioSA)/CLOCKS_PER_SEC);

}
void limpa_arquivo(char *nomearq)
 {
  FILE *arquivo;
  arquivo = fopen(nomearq,"w");
  if (!arquivo){
     printf("O arquivo %s nao pode ser aberto",nomearq);
     exit(1);
  }
  fclose(arquivo);
 }

void imprime_resultados(float fomin,int *demanda, int n_cidades,
                        int capacidade, int *caminho_star,
                        float **distancia, int tam_caminho)
{
  int i, usados,n;
  usados = numero_de_caminhoes(tam_caminho, caminho_star);
  int carga = 0;
  n = 1;
  char *nomearq;
  nomearq = "solucao.dat";
  limpa_arquivo("solucao.dat");

  FILE *arquivo;
  arquivo = fopen(nomearq,"a+");
  if (!arquivo){
    printf("O arquivo %s nao pode ser aberto",nomearq);
    exit(1);
  }
  printf("********************************************************************************\n");
  printf("************************ RELATORIO FINAL ***************************************\n");
  fprintf(arquivo,"*********************************** RELATORIO FINAL ********************************************************\n");

  printf("Valor da funcao objetivo = %f\n",fomin);
  fprintf(arquivo,"Valor da funo objetivo = %f\n",fomin);

  printf("Numero minimo de caminhoes necessarios = %d\n",minimo_de_caminhoes(demanda, n_cidades + 1, capacidade));
  fprintf(arquivo,"Nmero mnimo de caminhes necessrios = %d\n",minimo_de_caminhoes(demanda, n_cidades + 1, capacidade));

  printf("Numero de caminhoes utilizados         = %d\n",usados);
  fprintf(arquivo,"Nmero de caminhes utilizados         = %d\n\n",usados);

  printf("Distancia total percorrida = %f\n",calcula_distancia(tam_caminho, distancia, caminho_star));
  fprintf(arquivo,"Distncia total percorrida = %f Kilometros\n",calcula_distancia(tam_caminho, distancia, caminho_star));

  printf("********************************************************************************\n");
  fprintf(arquivo,"*********************************************************************************************************************\n\n\n\n");

  printf("Tecle enter para continuar");
  getchar();
  printf("************************* ROTEIRO **********************************************\n");
  fprintf(arquivo,"********************************** ROTEIRO DE CADA CAMINHO *******************************************************************\n\n\n\n");

  printf("Caminhao[1] - Deposito --> ");
  fprintf(arquivo,"Caminhao[1] - Deposito --> ");

  for(i=1;i<tam_caminho;i++){
    if(caminho_star[i]!=0){
      carga =  carga + demanda[caminho_star[i]];
      printf("%d --> ",caminho_star[i]);
      fprintf(arquivo,"%d --> ",caminho_star[i]);
    }
    else{
      if(caminho_star[i-1]!=0){
        usados--;
        n++;
        printf("Deposito\n");
        fprintf(arquivo,"Deposito\n");

        printf("Carga[%d] = %d\n",n-1, carga);
        fprintf(arquivo,"Carga[%d] = %d\n",n-1, carga);

        carga = 0;
        printf("********************************************************************************\n\n");
        fprintf(arquivo,"************************************************************************************************\n\n\n");
        if(usados > 0){
          printf("Caminhao[%d] - Deposito --> ",n);
          fprintf(arquivo,"Caminhao[%d] - Deposito --> ",n);
        }
      }
      else continue;
    }
  }
  fclose(arquivo);

}

/* Gera numero aleatorio entre min e max */
double randomico(double min, double max)
{
  if (min == max) return min;
  return ((double) (rand()%10000/10000.0)*(max-min) + min);
}

void atualiza_caminho(int tam_caminho, int *caminho, int *caminho_star)
{
 for(int i = 1; i < tam_caminho -1; i++)
     caminho_star[i] = caminho[i];
}
void troca(int no1,int no2, int *caminho)
{
 int t;
 t = caminho[no1];
 caminho[no1] = caminho[no2];
 caminho[no2] = t;
}
int numero_de_inviabilidades(int tam_caminho, int capacidade,
                             int *caminho, int *demanda)
{
 int i, inv, carga, fim;
 inv = carga = 0;
 fim = tam_caminho;
 if(caminho[1]==0)
    for (int j=0;j<2;j++)
       carga = 0;
 for ( i = 1; i < fim ; i++){
    if(caminho[i]==0){
      if(capacidade - carga < 0){
        inv = inv + carga - capacidade;
      }
      carga = 0;
      continue;
    }
    else{
       carga = carga + demanda[caminho[i]];

    }
 }
 return inv;
}
int numero_de_caminhoes(int tam_caminho, int *caminho)
{
 int i,n,fim;
 n=0;
 fim = tam_caminho-1;
 for(i = 1;i < fim; i++){
    if(caminho[i] != 0 && caminho[i-1] == 0){
      n = n + 1;
    }
 }
 //printf("n = %d\n", n);
 return n;
}
float calcula_distancia(int tam_caminho,float **distancia, int *caminho)
{
 float dist;
 int i;
 int x = tam_caminho;
 dist = 0;
 for(i = 1;i < x; i++){
    dist = dist + distancia[caminho[i-1]][caminho[i]];
 }
 return dist;
}
void gera_solucao_inicial(int *demanda, int tam_caminho, int *caminho,
                          int n_cidades, int *caminho_star)
{
 int i, q , p, x;
 x = tam_caminho - 2;
 for (i = 1;i <= n_cidades;i++){
    p = random(x) + 1;
    if( caminho[p] != 0){
      while (caminho[p] != 0){
         p = random(x) + 1;
      }
    }
    caminho[p] = i;
    caminho_star[p] = i;
 }
}
int minimo_de_caminhoes(int *demanda,int tam,int capacidade)
{
 int total,i,minimo;
 float m;
 total = 0;
 for(i = 1;i < tam;i++){
    total = total + demanda[i];
    //printf("Numero de pedidos do cliente  %d   = %d\n",i, demanda[i]);
 }
// printf("\n********************************************************************************\n");
// printf("Carga total = %d\n",total);
 m = total%capacidade;
 //printf("M = %f\n", m);
 if( m != 0){
   minimo = total/capacidade +1;
 }
 else minimo = total/capacidade;
 //printf("Minimo de caminhoes = %d\n", minimo);
 return minimo;
}
void imprime_matrizcusto(float **distancia, int n_cidades)
{
 int i,j,n;
 n = n_cidades + 1;
 for(i=0;i < n;i++){
    for(j=0;j < n;j++){
     printf(" %4d ",distancia[i][j]);
    }
    printf("\n");
 }
}
void imprime_vetor(int *vetor, int tam)
{
 int i;
 for(i = 0; i < tam; i++){
    printf("%4d", vetor[i]);
 }
  printf("\n");
}
/*Cria os vetores que sero usados*/
int *criavetor(int tam)
{
  int *vetor;
  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor) Erro("Falta memoria para alocar o vetor de ponteiros");
  return vetor;
}
/*Libera os vetores criados*/
void liberavetor(int *vetor)
{
  free(vetor);
}



/*Em caso de erro na leitura de algum arquivo deixa uma mensagem e sa do sistema*/
void Erro(char *texto)
{
  printf("\n ****** %s ******\n",texto);
  printf("... Saindo do sistema ...\n");
  exit(1);
}

/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
float **criamatrizfloat(int nlinhas, int ncolunas)
{
  register int i;
  float **matriz;
  matriz = (float **) malloc(nlinhas*sizeof(float *));
  if (!matriz) Erro("Falta memoria para alocar a matriz de ponteiros");
  for (i=0; i < nlinhas; i++){
     matriz[i] = (float *) malloc(ncolunas*sizeof(float));
     if (!matriz[i])
     printf("Falta memoria para alocar a matriz de ponteiros.\n");
  }
  return matriz;
}
/*Libera as matrizes criadas no inicio do programa*/
void liberamatrizfloat(float **matriz, int nlinhas)
{
  register int i;
  for (i=nlinhas-1; i >= 0; i--)
  free((float *) matriz[i]);
  free((float *) matriz);
}

/* Inicializa uma matriz de inteiros com valor nulo */
void inicializamatriz(float **matriz, int nlinhas, int ncolunas)
{
  register int i, K;
  for (i=0; i < nlinhas; i++)
        for (K=0; K < ncolunas; K++)
              matriz[i][K] = 0.0;
}

/* Inicializa um vetor de ponteiros para inteiros com valor nulo */
void inicializavetor(int *vetor, int tam)
{
  register int j;
  for (j=0; j < tam; j++)
        vetor[j] = 0;
}


/* L uma matriz no formato: linha, coluna, valor */
void learqmatriz(char *nomearq, float **matriz)
{
  int i,         /* origem       */
      j;         /* destino      */
  float  num;    /* distancia    */
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) printf("O Arquivo %s nao pode ser aberto.\n",nomearq);
  while (!feof(arquivo)) {
    fscanf(arquivo, "%d, %d, %f", &i, &j, &num);
    matriz[i][j] = num;
  }
  fclose(arquivo);
}
/*L os arquivos de vetor no formato : coluna, valor*/
void learqvetor(char *nomearq, int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
  while (!feof(arquivo)){
    fscanf(arquivo, "%d, %d", &j, &valor);
    vetor[j] = valor;
  }
 fclose(arquivo);
}

/* INCIO DAS OPERAES FEITAS COM A LISTA TABU */
/* Apaga TODA a lista tabu */
void apagalistatabu(struct listatabu **iniciotabu,
                    struct listatabu **finaltabu)
{
	struct listatabu *registro = *iniciotabu;
  	while(registro) {
            apagaregistrotabu(registro, iniciotabu, finaltabu);
            registro = registro->proximo;   /* obtem prximo endereo */
  	}
}
/* Remove o elemento registro da lista */
void apagaregistrotabu(struct listatabu *registro,
                       struct listatabu **iniciotabu,
                       struct listatabu **finaltabu)
{
  if(registro) {
    if(*iniciotabu==registro) {
      *iniciotabu=registro->proximo;
      if(*iniciotabu) (*iniciotabu)->anterior = NULL;
      else *finaltabu = NULL;
    }
    else {
      registro->anterior->proximo = registro->proximo;
      if(registro!=*finaltabu)
          registro->proximo->anterior = registro->anterior;
      else
        *finaltabu = registro->anterior;
    }
    free(registro); /* devolve memoria para o sistema */
  }
}
/* Mostra o comprimento da lista completa */
void displaylistatabu(struct listatabu **iniciotabu,
        	      struct listatabu **finaltabu)
{
  struct listatabu *registro = *iniciotabu;
  int cont = 0;

  while(registro) {
  	printf("tabu[%2d]   no1 = %2d  no2 = %2d\n",
    		cont, registro->no1, registro->no2);
    registro = registro->proximo;   /* obtem prximo endereo */
  	cont++;
  }
}
/* Encontra um registro na lista tabu */
bool estalistatabu(int no1, int no2, struct listatabu **iniciotabu)
{
  struct listatabu *registro = *iniciotabu;

  while(registro) {
    if (registro->no1 == no1 && registro->no2 == no2)
        return true;
    registro = registro->proximo;  /* obtem novo registro */
  }
  return false; /* nao encontrou */
}
/* Insere o registro i no final de uma lista encadeada */
void inserelistatabu(struct listatabu *i,
                     struct listatabu **iniciotabu,
                     struct listatabu **finaltabu)
{
  struct listatabu *old, *p;

  if (*finaltabu == NULL) {
    i->proximo  = NULL;
    i->anterior = NULL;
    *finaltabu = i;
    *iniciotabu = i;
    return;
  }
  p = *iniciotabu;
  old = NULL;
  while (p) {
    old = p;
    p = p->proximo;
  }
  old->proximo = i;
  i->proximo = NULL;
  i->anterior = old;
  *finaltabu = i;
}
/* Mostra o comprimento da lista completa */
int lenghtlistatabu(struct listatabu **iniciotabu,
		    struct listatabu **finaltabu)
{
  struct listatabu *registro = *iniciotabu;
  int cont = 0;

  while(registro) {
    registro = registro->proximo;   /* obtem prximo endereo */
  	cont++;
  }
  return cont;
}
/* Encontra um registro na lista tabu */
struct listatabu *procuraregistrolistatabu(int no1, int no2,
                                           struct listatabu **iniciotabu)
{
  struct listatabu *registro = *iniciotabu;

  while(registro) {
    if(registro->no1 == no1 && registro->no2 == no2) return registro;
    registro = registro->proximo;  /* obtem novo registro */
  }
  return NULL; /* nao encontrou */
}
/* FIM DAS OPERAES FEITAS COM A LISTA TABU */
