//---------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

//---------------------------------------------------------------------------

FILE *abreArquivo(char nomeArq[]);
void atualiza_melhor_solucao(int **s, int **s_star, int nLinhas, int nColunas);
int calculaExcessoDia(int **matriz, int linha);
int calculaExcessoDiaMatriz(int **matriz, int nLinhas);
int calculaPenalidadeNroVezesProfessor(int **matrizManha, int **matrizTarde, int linha);
int calculaPenalidadeNroVezesProfessorMatriz(int **matrizManha, int **matrizTarde, int nLinhas);
int calculaSobreposicao(int **matrizManha, int **matrizTarde, int coluna);
int calculaSobreposicaoMatriz(int **matrizManha, int **matrizTarde, int nColunas);
double calcula_temperatura_inicial(int p, int hs, int **sManha,int **sTarde, int fo, int sobreposicao,
                                   int excessoDia, int nroVezesProf, double alfa, int SAmax);
int **criaMatriz(int nLinhas, int nColunas);
void criaSolucaoInicialAleatoria(int **matrizManha, int **matrizTarde, int p, int hs);
int *criaVetor(int tamanho);
void imprimeMatriz(int **matriz, int nLinhas, int nColunas);
void imprime_solucao(int **s, int nLinhas, int nColunas);
void imprimeVetor(int *vetor, int tamanho);
void imprimeVetorTurno(int *vetor, int tamanho);
void inicializaMatriz(int **matriz, int nLinhas, int nColunas);
void inicializaVetor(int *vetor, int tamanho);
void leArquivoCh_Turno(int **matriz1, int **matriz2, char arqCh[], char arqTurno[], int horasSemanais);
void leArquivoTurno(int *vetor, char arqTurno[]);
void leArquivoVezes (int *vetor, char arqVezes[]);
void liberaMatriz(int **matriz, int nLinhas);
void liberaVetor(int *vetor);
double randomico(double min, double max);
void SA(int p, int hs, int **sManha, int **sTarde, int fo, int sobreposicao, int excessoDia, int nroVezesProf,
             double alfa, double temperatura_inicial, double temperatura_final, int SAmax);
void separaDias(int **matriz, int i, int j);
void trocaHorarios(int **matriz, int linha, int coluna1, int coluna2);

//---------------------------------------------------------------------------
/* Variaveis Globais */

/* Vetor Turno */
  int *vetorTurno;

/* Vetor N de dias que professor vai  escola */
  int *vetorVezes;

//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char **argv) {
/* Parametros da Tabela */
  int p = 23;                       // Numero de Professores
  int hs = 25;                      // Numero de Horarios Semanais
  int nTurmas = 16;               // Numero de Turmas

  double alfa;
  double temperaturaInicial;        // temperatura inicial de partida do sistema
  double temperatura_final;         // temperatura de congelamento do sistema
  int SAmax;                        // numero maximo de iteracoes em uma dada temperatura

/* Penalidades */

  int sobreposicaoTotal;            // sobreposicao de horarios
  int excessoDiaTotal;              // excesso de aulas no dia
  int nroVezesProfTotal;            // numero de vezes que professor vai a escola
  int funcaoObjetiva;               // funcao objetivo corrente

/* Tabelas Turno Manha e Tarde */
  int **tabManha;                  // Tabela Turno da Manha
  int **tabTarde;                  // Tabela Turno da Tarde

// ************************************************

  tabManha = criaMatriz(p, hs);
  tabTarde = criaMatriz(p, hs);

  vetorTurno = criaVetor(nTurmas);
  vetorVezes = criaVetor(p);

  inicializaMatriz(tabManha, p, hs);
  inicializaMatriz(tabTarde, p, hs);
  inicializaVetor(vetorTurno, nTurmas);
  inicializaVetor(vetorVezes, p);

  leArquivoCh_Turno(tabManha, tabTarde, "ch.txt", "turno.txt", hs);

  criaSolucaoInicialAleatoria(tabManha, tabTarde, p, hs);
  printf("      ******** School Timetabling utilizando Simulated Annealing ********\n\n");
  getchar();
  printf("             ******** Geracao da solucao inicial aleatoria ********\n");
  getchar();
  printf("\n           *********** Solucao Inicial Turno da Manha ***********\n");
  imprimeMatriz(tabManha, p, hs);
  getchar();
  printf("\n           *********** Solucao Inicial Turno da Tarde ***********\n");
  imprimeMatriz(tabTarde, p, hs);
  getchar();

  leArquivoTurno(vetorTurno, "turno.txt");
  leArquivoVezes(vetorVezes, "vezes.txt");

  funcaoObjetiva = 0;
  sobreposicaoTotal = calculaSobreposicaoMatriz(tabManha, tabTarde, hs);
  excessoDiaTotal = calculaExcessoDiaMatriz(tabManha, p) + calculaExcessoDiaMatriz(tabTarde, p);
  nroVezesProfTotal = calculaPenalidadeNroVezesProfessorMatriz(tabManha, tabTarde, p);
  funcaoObjetiva = sobreposicaoTotal*40 + excessoDiaTotal*25 + nroVezesProfTotal*7;

  printf("                ********* Solucao Inicial *********     ");
  printf("\n\n                        Funcao Objetiva = %d", funcaoObjetiva);
  printf("\n*************************************************************************");
  printf("\n  Sobreposicao = %d        ExcessoDia = %d", sobreposicaoTotal, excessoDiaTotal);
  printf("      NroVezesProf = %d", nroVezesProfTotal);
  printf("\n*************************************************************************\n\n");
  getchar();

  if(funcaoObjetiva != 0) {
    alfa = 0.97;
    SAmax = 1500;
    printf("           ***** Calculo da Temperatura Inicial *****\n");
    getchar();
    temperaturaInicial = calcula_temperatura_inicial(p, hs, tabManha, tabTarde, funcaoObjetiva, sobreposicaoTotal,
                                                     excessoDiaTotal, nroVezesProfTotal, alfa, SAmax);
    printf("\n  Temperatura Inicial = %f", temperaturaInicial);
    temperatura_final = 0.001;
    printf("    Temperatura Final = %f", temperatura_final);
    getchar();
    SA(p, hs, tabManha, tabTarde, funcaoObjetiva, sobreposicaoTotal, excessoDiaTotal, nroVezesProfTotal,
             alfa, temperaturaInicial, temperatura_final, SAmax);
  }
  else {
    printf("\n ----- Nao foi gerada uma solucao inicial -------\n");
    getchar();
  }
}

//---------------------------------------------------------------------------

/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
int **criaMatriz(int nLinhas, int nColunas) {
  int **matriz;

  matriz = (int **) malloc(nLinhas*sizeof(int *));
  if(!matriz)
    printf("Falta de memoria para alocar a matriz de ponteiros");
  for (int i = 0; i < nLinhas; i++) {
    matriz[i] = (int *) malloc(nColunas*sizeof(int));
    if(!matriz[i])
     printf("Falta de memoria para alocar a matriz de ponteiros");
  }
  return matriz;
}

//---------------------------------------------------------------------------

// libera matriz da memoria
void liberaMatriz(int **matriz, int nLinhas) {

  for (int i = nLinhas-1; i >= 0; i--)
    free((int *) matriz[i]);
  free((int *) matriz);
}

//---------------------------------------------------------------------------

/* Inicializa matriz de inteiros com valor 99 */
void inicializaMatriz(int **matriz, int nLinhas, int nColunas) {
  int i,j;

  for(i = 0; i < nLinhas; i++)
    for(j = 0; j < nColunas; j++)
      matriz[i][j] = 99;
}

//---------------------------------------------------------------------------

/* abre um arquivo */
FILE *abreArquivo(char nomeArq[]) {
  FILE *arquivo;

  arquivo = fopen(nomeArq,"r");
  if(!arquivo) { // if 1
    printf("Arquivo %s nao pode ser aberto.\n",nomeArq);
    exit(1);
  } // if 1
  return arquivo;
}

//---------------------------------------------------------------------------

/* Imprime uma matriz linha por linha */
void imprimeMatriz(int **matriz, int nLinhas, int nColunas) {
  printf("  |----Segunda----|----Terca-----|----Quarta----|----Quinta----|----Sexta-----|\n");
  printf("  |  0  1  2  3  4| 5  6  7  8  9|10 11 12 13 14|15 16 17 18 19|20 21 22 23 24\n");
  printf("-------------------------------------------------------------------------------\n");
  for(int i = 0; i < nLinhas; i++) {
    if(i+1 >= 10)
      printf("%d| ", i+1);
    else
      printf("%d | ", i+1);
    for(int j = 0; j < nColunas; j++)
      separaDias(matriz, i, j);
    printf("\n");
  }
  printf("  |---------------|--------------|--------------|--------------|--------------|\n");
}

//---------------------------------------------------------------------------

void separaDias(int **matriz, int i, int j) {
  if(j == 4 || j == 9 || j == 14 || j == 19) {
    switch(matriz[i][j]) {
      case 0:
        printf("8A|");
        break;
      case 1:
        printf("8B|");
        break;
      case 2:
        printf("8C|");
        break;
      case 3:
        printf("8D|");
        break;
      case 4:
        printf("7A|");
        break;
      case 5:
        printf("7B|");
        break;
      case 6:
        printf("7C|");
        break;
      case 7:
        printf("7D|");
        break;
      case 8:
        printf("6A|");
        break;
      case 9:
        printf("6B|");
        break;
      case 10:
        printf("6C|");
        break;
      case 11:
        printf("6D|");
        break;
      case 12:
        printf("5A|");
        break;
      case 13:
        printf("5B|");
        break;
      case 14:
        printf("5C|");
        break;
      case 15:
        printf("5D|");
        break;
      default:
        printf("**|");
    }
  }
  else {
    switch(matriz[i][j]) {
      case 0:
        printf("8A ");
        break;
      case 1:
        printf("8B ");
        break;
      case 2:
        printf("8C ");
        break;
      case 3:
        printf("8D ");
        break;
      case 4:
        printf("7A ");
        break;
      case 5:
        printf("7B ");
        break;
      case 6:
        printf("7C ");
        break;
      case 7:
        printf("7D ");
        break;
      case 8:
        printf("6A ");
        break;
      case 9:
        printf("6B ");
        break;
      case 10:
        printf("6C ");
        break;
      case 11:
        printf("6D ");
        break;
      case 12:
        printf("5A ");
        break;
      case 13:
        printf("5B ");
        break;
      case 14:
        printf("5C ");
        break;
      case 15:
        printf("5D ");
        break;
      default:
        printf("** ");
    }
  }
}

//---------------------------------------------------------------------------

/* L os arquivos ch.txt e turno.txt e insere nas matrizes tabManha e tabTarde */
void leArquivoCh_Turno(int **matriz1, int **matriz2, char arqCh[], char arqTurno[], int horasSemanais) {
  int prof,
      turmaCh,
      turmaTurno,
      cargaHoraria,
      turno;
  int i, j;
  FILE *arquivoCh;
  FILE *arquivoTurno;

  arquivoCh = abreArquivo(arqCh);
  while(!feof(arquivoCh)) { // while 1
    fscanf(arquivoCh, "%d,%d,%d",&prof,&turmaCh,&cargaHoraria);
    arquivoTurno = abreArquivo(arqTurno);
    while(!feof(arquivoTurno)) { // while 2
      fscanf(arquivoTurno, "%d,%d",&turmaTurno,&turno);
      if(turmaCh == turmaTurno) {
        if(turno == 0) {  /* Turno Manha */
          for(i = 0; i < horasSemanais; i++) {
            if(matriz1[prof-1][i] == 99) {
              for(j = i; j < cargaHoraria+i; j++) {
                matriz1[prof-1][j] = turmaCh;
              }
              i = horasSemanais;
            }
          }
        }
        else {
          for(i = 0; i < horasSemanais; i++) {
            if(matriz2[prof-1][i] == 99) {
              for(j = i; j < cargaHoraria+i; j++) {
                matriz2[prof-1][j] = turmaCh;
              }
              i = horasSemanais;
            }
          }
        }
      }
    } // while 2
    fclose(arquivoTurno);
  } // while 1
  fclose(arquivoCh);
}

//---------------------------------------------------------------------------

/* cria vetor de comprimento tamanho */
int *criaVetor(int tamanho) {
  int *vetor;

  vetor = (int *) malloc(tamanho*sizeof(int));
  if(!vetor)
    printf("Falta de memoria para alocar a matriz de ponteiros");
  return vetor;
}

//---------------------------------------------------------------------------

/* Inicializa um vetor de ponteiros para inteiros com valor 99 */
void inicializaVetor(int *vetor, int tamanho) {

  for(int i = 0; i < tamanho; i++)
    vetor[i] = 99;
}

//---------------------------------------------------------------------------

/* L o contedo do arquivo turno.txt e insere no vetor vetorTurno */
void leArquivoTurno(int *vetor, char arqTurno[]) {
  int turma,
      turno;
  FILE *arquivoTurno;

  arquivoTurno = abreArquivo(arqTurno);
  while(!feof(arquivoTurno)) {
    fscanf(arquivoTurno, "%d,%d", &turma, &turno);
    vetor[turma] = turno;
  }
  fclose(arquivoTurno);
}

//---------------------------------------------------------------------------

/* imprime o contedo do vetor */
void imprimeVetorTurno(int *vetor, int tamanho) {

  for(int j = 0; j < tamanho; j++) {
    switch(j) {
      case 0:
        printf(" 8A|");
        break;
      case 1:
        printf(" 8B|");
        break;
      case 2:
        printf(" 8C|");
        break;
      case 3:
        printf(" 8D|");
        break;
      case 4:
        printf(" 7A|");
        break;
      case 5:
        printf(" 7B|");
        break;
      case 6:
        printf(" 7C|");
        break;
      case 7:
        printf(" 7D|");
        break;
      case 8:
        printf(" 6A|");
        break;
      case 9:
        printf(" 6B|");
        break;
      case 10:
        printf(" 6C|");
        break;
      case 11:
        printf(" 6D|");
        break;
      case 12:
        printf(" 5A|");
        break;
      case 13:
        printf(" 5B|");
        break;
      case 14:
        printf(" 5C|");
        break;
      case 15:
        printf(" 5D|");
        break;
      default:
        printf(" **|");
    }
  }
  printf("\n|---------------------------------------------------------------|\n");

  for(int i = 0; i < tamanho; i++) {
      printf("  %d|", vetor[i]);
  }
}

//---------------------------------------------------------------------------

/* L o contedo do arquivo vezes.txt e insere no vetor vetorVezes */
void leArquivoVezes(int *vetor, char arqVezes[]) {
  int prof,
      nroVezes;
  FILE *arquivoVezes;

  arquivoVezes = abreArquivo(arqVezes);
  while(!feof(arquivoVezes)) {
    fscanf(arquivoVezes, "%d,%d", &prof, &nroVezes);
    vetor[prof-1] = nroVezes;
  }
  fclose(arquivoVezes);
}

//---------------------------------------------------------------------------

/* imprime o contedo do vetor */
void imprimeVetor(int *vetor, int tamanho) {

  for(int j = 1; j < tamanho+1; j++)
    printf("%d|" , j);
  printf("\n------------------------------------------------------------\n");

  for(int i = 0; i < tamanho; i++) {
    if(i >= 8)
      printf("%d| ", vetor[i]);
    else
      printf("%d|", vetor[i]);
  }
}

//---------------------------------------------------------------------------

// libera vetor da memoria
void liberaVetor(int *vetor) {

  free(vetor);
}

//---------------------------------------------------------------------------

/* Gera numero aleatorio entre min e max */
double randomico(double min, double max) {
  if (min == max) return min;
  return ((double) (rand()%10000/10000.0)*(max-min) + min);
}

//---------------------------------------------------------------------------

void criaSolucaoInicialAleatoria(int **matrizManha, int **matrizTarde, int p, int hs) {
  int **matriz1;
  int **matriz2;
  int coluna;

  matriz1 = criaMatriz(p, hs);
  matriz2 = criaMatriz(p, hs);
  inicializaMatriz(matriz1, p, hs);
  inicializaMatriz(matriz2, p, hs);
  for (int i = 0; i < p; i++) {
    for(int j = 0; j < hs; j++) {
      matriz1[i][j] = matrizManha[i][j];
      matriz2[i][j] = matrizTarde[i][j];
    }
  }
  inicializaMatriz(matrizManha, p, hs);
  inicializaMatriz(matrizTarde, p, hs);

  for (int l = 0; l < p; l++) {
    for (int c = 0; c < hs; c++) {
      if(matriz1[l][c] != 99) {
        do{
          coluna = random(25);
        }while(matrizManha[l][coluna] != 99);
        matrizManha[l][coluna] = matriz1[l][c];
        matriz1[l][c] = 99;
      }
    }
  }
  liberaMatriz(matriz1, p);

  for (int l = 0; l < p; l++) {
    for (int c = 0; c < hs; c++) {
      if(matriz2[l][c] != 99) {
        do{
          coluna = random(25);
        }while(matrizTarde[l][coluna] != 99);
        matrizTarde[l][coluna] = matriz2[l][c];
        matriz2[l][c] = 99;
      }
    }
  }
  liberaMatriz(matriz2, p);
}

//---------------------------------------------------------------------------

/* atualiza a melhor solucao */
void atualiza_melhor_solucao(int **s, int **s_star, int nLinhas, int nColunas) {

   for (int i = 0; i < nLinhas; i++) { // for1
     for (int j = 0; j < nColunas; j++) { // for2
       s_star[i][j] = s[i][j];
     } // for2
   } // for1
}

//---------------------------------------------------------------------------

/* imprime a solucao */
void imprime_solucao(int **matriz, int nLinhas, int nColunas) {
  imprimeMatriz(matriz, nLinhas, nColunas);
}

//---------------------------------------------------------------------------

// cria um vizinho (2-Optimal)
void trocaHorarios(int **matriz, int linha, int coluna1, int coluna2) {
  int aux;

  aux = matriz[linha][coluna1];
  matriz[linha][coluna1] = matriz[linha][coluna2];
  matriz[linha][coluna2] = aux;
}

//---------------------------------------------------------------------------

// calcula a penalidade da sobreposicao de uma coluna
int calculaSobreposicao(int **matrizManha, int **matrizTarde, int coluna) {
  int sobreposicao = 0;
  int aux = -1;

  for(int t = 0; t < 16; t++) { // for2
    // turno Manha
    if(vetorTurno[t] == 0) {
      for(int linha = 0; linha < 23; linha++) { // for
        if(matrizManha[linha][coluna] == t) { // if2
          aux ++;
        } // if2
      } // for3
      if (aux>0) {
        sobreposicao = sobreposicao + aux;
      }
      aux = -1;
    }

    // turno Tarde
    else {
      for(int linha = 0; linha < 23; linha++) { // for3
        if(matrizTarde[linha][coluna] == t) { // if2
          aux ++;
        } // if2
      } // for3
      if (aux>0) {
        sobreposicao = sobreposicao + aux;
      }
      aux = -1;
    }
  } // for2
  return sobreposicao;
}

//---------------------------------------------------------------------------

// calcula a penalidade da sobreposicao de duas matrizes
int calculaSobreposicaoMatriz(int **matrizManha, int **matrizTarde, int nColunas) {
  int sobreposicaoMatriz = 0;

  for(int i = 0; i < nColunas; i++) {

    sobreposicaoMatriz = sobreposicaoMatriz + calculaSobreposicao(matrizManha, matrizTarde, i);
  }
  return sobreposicaoMatriz;
}

//---------------------------------------------------------------------------

// calcula a penalidade do excessoDia de uma linha
int calculaExcessoDia(int **matriz, int linha) {
  int excessoDia = 0;
  int aux = -2;

  for(int t = 0; t < 16; t++) { // for2
    for(int coluna = 0; coluna < 24; coluna++) { // for3
      if(matriz[linha][coluna] == t) { // if2
        aux ++;
      } // if2
      else {
        if(aux>0) {
          excessoDia = excessoDia + aux;
        }
        aux = -2;
      }
    } // for3
    if (aux>0){
      excessoDia = excessoDia + aux;
    }
    aux = -2;
  } // for2
  return excessoDia;
}

//---------------------------------------------------------------------------

// calcula a penalidade do excessoDia de duas matrizes
int calculaExcessoDiaMatriz(int **matriz, int nLinhas) {
  int excessoDiaMatriz = 0;

  for(int i = 0; i < nLinhas; i++) {
    int valor = calculaExcessoDia(matriz, i);
    excessoDiaMatriz = excessoDiaMatriz + valor;
  }
  return excessoDiaMatriz;
}

//---------------------------------------------------------------------------


// Calcula a penalidade do numero minimo de vezes que um professor vai a escola
int calculaPenalidadeNroVezesProfessor(int **matrizManha, int **matrizTarde, int linha) {
  int nroVezesProf = 0;
  int aux = 0;

  for(int coluna = 0; coluna < 25; coluna++) { // for1
    if(matrizManha[linha][coluna] != 99 || matrizTarde[linha][coluna] != 99) { // if1
        // 1 Dia
        if(coluna <= 4) {
          if(aux < 1) {
            nroVezesProf = nroVezesProf + 1;
            aux = 1;
          }
        }
        // 2 Dia
        else if(coluna > 4 && coluna <= 9) {
          if(aux < 2) {
            nroVezesProf = nroVezesProf + 1;
            aux = 2;
          }
        }
        // 3 Dia
        else if(coluna > 9 && coluna <= 14) {
          if(aux < 3) {
            nroVezesProf = nroVezesProf + 1;
            aux = 3;
          }
        }
        // 4 Dia
        else if(coluna > 14 && coluna <= 19) {
          if(aux < 4) {
            nroVezesProf = nroVezesProf + 1;
            aux = 4;
          }
        }
        // 5 Dia
        else if(coluna > 19 && coluna <= 24) {
          if(aux < 5) {
            nroVezesProf = nroVezesProf + 1;
            aux = 5;
          }
        }
    } // fim if1
  } // fim for1
  // se a subtracao for menor ou igual a zero, nao ha penalidade
  if((nroVezesProf - vetorVezes[linha]) <= 0)
    nroVezesProf = 0;
  else
    nroVezesProf = nroVezesProf - vetorVezes[linha];

  return nroVezesProf;
}

//---------------------------------------------------------------------------

// Calcula a penalidade do numero minimo de vezes que todos professor vao a escola
int calculaPenalidadeNroVezesProfessorMatriz(int **matrizManha, int **matrizTarde, int nLinhas) {
  int nroVezesProfMatriz = 0;

  for(int i = 0; i < nLinhas; i++) {
    nroVezesProfMatriz = nroVezesProfMatriz + calculaPenalidadeNroVezesProfessor(matrizManha, matrizTarde, i);
  }

  return nroVezesProfMatriz;
}

//---------------------------------------------------------------------------

// Calcula tempertura inicial
double calcula_temperatura_inicial(int p, int hs, int **sManha,int **sTarde, int fo, int sobreposicao,
                                   int excessoDia, int nroVezesProf, double alfa, int SAmax) {
    double x;                     // numero aleatorio entre ZERO e UM
    double temperatura;           // temperatura corrente
    int iter;                     // numero de iteracoes na temperatura corrente
    int fo1;                      // funco objetiva do vizinho (fo')
    int delta;                    // variacao de energia
    int aceitos, min_aceitos;
    int hEscolhido1;              // 1 horario escolhido aleatoriamente
    int hEscolhido2;              // 2 horario escolhido aleatoriamente
    int pEscolhido;               // professor escolhido aleatoriamente
    int sobreposicaoAnteriorColuna1; // sobreposicao do 1 horario escolhido, anteriormente, aleatoriamente
    int sobreposicaoAnteriorColuna2; // sobreposicao do 2 horario escolhido, anteriormente, aleatoriamente
    int excessoDia_s_lManha;      // excessoDia da linha escolhida da matriz anterior
    int excessoDia_s_lTarde;      // excessoDia da linha escolhida da matriz anterior
    int nroVezesProfAnteriorLinha;   // nroVezesProf do professor escolhido anteriormente

    temperatura = 2;
    printf("Solucao inicial: fo corrente = %d \n", fo);

    aceitos = 0;
    min_aceitos = (int) (0.90*SAmax);
    while (aceitos < min_aceitos){
       iter = 0;
       printf("temperatura inicial = %f \n",temperatura);
       while (iter < SAmax){
            iter++;

            // escolha um vizinho qualquer
            do { // do while1
              pEscolhido = random(p);
              hEscolhido1 = random(hs);
              hEscolhido2 = random(hs);
            } while(hEscolhido1 == hEscolhido2 || sManha[pEscolhido][hEscolhido1] == sManha[pEscolhido][hEscolhido2] &&
                    sTarde[pEscolhido][hEscolhido1] == sTarde[pEscolhido][hEscolhido2]);
            // calcula sobreposica e excessoDia das colunas e linhas escolhidas para o turno da manha e da tarde
            sobreposicaoAnteriorColuna1 = calculaSobreposicao(sManha, sTarde, hEscolhido1);
            sobreposicaoAnteriorColuna2 = calculaSobreposicao(sManha, sTarde, hEscolhido2);
            excessoDia_s_lManha = calculaExcessoDia(sManha, pEscolhido);
            excessoDia_s_lTarde = calculaExcessoDia(sTarde, pEscolhido);
            nroVezesProfAnteriorLinha = calculaPenalidadeNroVezesProfessor(sManha, sTarde, pEscolhido);

            // gera um vizinho
            trocaHorarios(sManha, pEscolhido, hEscolhido1, hEscolhido2);
            trocaHorarios(sTarde, pEscolhido, hEscolhido1, hEscolhido2);


            // calcula fo'
              fo1 = (sobreposicao - sobreposicaoAnteriorColuna1 - sobreposicaoAnteriorColuna2 +
                     calculaSobreposicao(sManha, sTarde, hEscolhido1) +
                     calculaSobreposicao(sManha, sTarde, hEscolhido2))*40 +
                    (excessoDia - excessoDia_s_lManha + calculaExcessoDia(sManha, pEscolhido)-
                     excessoDia_s_lTarde + calculaExcessoDia(sTarde, pEscolhido))*25 +
                    (nroVezesProf - nroVezesProfAnteriorLinha +
                     calculaPenalidadeNroVezesProfessor(sManha, sTarde, pEscolhido))*7;


            // calcule a variacao de energia
            delta = fo1 - fo;
//    	    printf("variacao de energia = %3d \n",delta);
	    // se houver melhora, aceite o vizinho
            if (delta < 0){
              aceitos++;
            }
            else {
              // se houver piora, aceite o vizinho com uma determinada probabilidade
              x = randomico(0,1);
              if (x < exp(-delta/temperatura)){
                aceitos++;
              }
            }
            // desfaz o vizinho
            trocaHorarios(sManha, pEscolhido, hEscolhido1, hEscolhido2);
            trocaHorarios(sTarde, pEscolhido, hEscolhido1, hEscolhido2);

       }
       printf("aceitos = %d   min_aceitos = %d\n",aceitos, min_aceitos);
       if (aceitos < min_aceitos){
            aceitos = 0;
            temperatura = temperatura * 1.1;
       }
    }
    printf("temperatura inicial = %f \n",temperatura);
    return temperatura;
}

//---------------------------------------------------------------------------

// Simulated Annealing
void SA(int p, int hs, int **sManha, int **sTarde, int fo, int sobreposicao, int excessoDia, int nroVezesProf,
             double alfa, double temperatura_inicial, double temperatura_final, int SAmax) {

  double x;                  // numero aleatorio entre ZERO e UM
  double temperatura;        // temperatura corrente (turno manha)
  int iter;                  // numero de iteracoes na temperatura corrente
  int num_mudancas_temp;     // numero de mudancas de temperatura (turno manha)
  int fo1;                   // funcao objetiva do vizinho (fo')
  int delta;                 // variacao de energia
  int fo_star;               // funcao objetiva da melhor solucao
  int **s_starManha;         // matriz da melhor solucao para quadro da manha
  int **s_starTarde;         // matriz da melhor solucao para quadro da tarde
  int pEscolhido;            // professor escolhido aleatoriamente
  int hEscolhido1;           // 1 horario escolhido aleatoriamente
  int hEscolhido2;           // 2 horario escolhido aleatoriamente
  int sobreposicaoAnteriorColuna1; // sobreposicao do 1 horario escolhido anteriormente
  int sobreposicaoAnteriorColuna2; // sobreposicao do 2 horario escolhio aleatoriamente
  int excessoDia_s_lManha;    // excessoDia da linha escolhida da matriz anterior
  int excessoDia_s_lTarde;    // excessoDia da linha escolhida da matriz anterior
  int nroVezesProfAnteriorLinha; // nroVezesProf do professor escolhido anteriormente
  int sobreposicaoAnterior;   // sobreposicao da Matriz anterior
  int excessoDiaAnterior;     // excessoDia da Matriz anterior
  int nroVezesProfAnterior;   // nroVezesProf da Matriz anterior

  printf("\n\n    ************************ Simulated Annealing ************************\n\n");
  s_starManha = criaMatriz(p,hs);
  inicializaMatriz(s_starManha, p, hs);
  atualiza_melhor_solucao(sManha, s_starManha, p, hs);
  s_starTarde = criaMatriz(p,hs);
  inicializaMatriz(s_starTarde, p, hs);
  atualiza_melhor_solucao(sTarde, s_starTarde, p, hs);
  fo_star = fo;
  temperatura = temperatura_inicial;
  num_mudancas_temp = 0;
  printf("Solucao inicial: fo corrente = %d \n",fo);
  getchar();

  // enquanto o sistema nao congelar faca
  while (temperatura > temperatura_final) { // while1
     iter = 0;
     // enquanto o equilibrio termico nao for atingido faca
     while (iter < SAmax){ // while2
        iter++;
        sobreposicaoAnterior = sobreposicao;
        excessoDiaAnterior = excessoDia;
        nroVezesProfAnterior = nroVezesProf;

        // escolha um vizinho qualquer
        do { // do while1
          pEscolhido = random(p);
          hEscolhido1 = random(hs);
          hEscolhido2 = random(hs);
        } while(hEscolhido1 == hEscolhido2 || sManha[pEscolhido][hEscolhido1] == sManha[pEscolhido][hEscolhido2] && sTarde[pEscolhido][hEscolhido1] == sTarde[pEscolhido][hEscolhido2]);
        // calcula sobreposica e excessoDia das colunas e linhas escolhidas para o turno da manha e da tarde
        sobreposicaoAnteriorColuna1 = calculaSobreposicao(sManha, sTarde, hEscolhido1);
        sobreposicaoAnteriorColuna2 = calculaSobreposicao(sManha, sTarde, hEscolhido2);
        excessoDia_s_lManha = calculaExcessoDia(sManha, pEscolhido);
        excessoDia_s_lTarde = calculaExcessoDia(sTarde, pEscolhido);
        nroVezesProfAnteriorLinha = calculaPenalidadeNroVezesProfessor(sManha, sTarde, pEscolhido);

        // gera um vizinho
        trocaHorarios(sManha, pEscolhido, hEscolhido1, hEscolhido2);
        trocaHorarios(sTarde, pEscolhido, hEscolhido1, hEscolhido2);


        // calcula fo'
        fo1 = (sobreposicao - sobreposicaoAnteriorColuna1 - sobreposicaoAnteriorColuna2 + calculaSobreposicao(sManha, sTarde, hEscolhido1) + calculaSobreposicao(sManha, sTarde, hEscolhido2))*40 + (excessoDia - excessoDia_s_lManha + calculaExcessoDia(sManha, pEscolhido)- excessoDia_s_lTarde + calculaExcessoDia(sTarde, pEscolhido))*25 + (nroVezesProf - nroVezesProfAnteriorLinha + calculaPenalidadeNroVezesProfessor(sManha, sTarde, pEscolhido))*7;
        // calcule a variacao de energia
        delta = fo1 - fo;
//        printf("variacao de energia = %3d \n",delta);
        // se houver melhora, aceite o vizinho
        if (delta < 0){ // if1
           fo += delta;

           sobreposicao = sobreposicaoAnterior - sobreposicaoAnteriorColuna1 - sobreposicaoAnteriorColuna2 + calculaSobreposicao(sManha, sTarde, hEscolhido1) + calculaSobreposicao(sManha, sTarde, hEscolhido2);
           excessoDia = excessoDiaAnterior - excessoDia_s_lManha + calculaExcessoDia(sManha, pEscolhido) - excessoDia_s_lTarde + calculaExcessoDia(sTarde, pEscolhido);
           nroVezesProf = nroVezesProfAnterior - nroVezesProfAnteriorLinha + calculaPenalidadeNroVezesProfessor(sManha, sTarde, pEscolhido);

           printf("Solucao de melhora (turnos manha e tarde): fo corrente = %d \n",fo1);
          // getchar();

           if ((fo1 <= fo_star)){ // if2
              atualiza_melhor_solucao(sManha, s_starManha, p, hs);
              atualiza_melhor_solucao(sTarde, s_starTarde, p, hs);
              fo_star = fo1;
//              imprime_solucao(s_star, p, hs);
              printf("********** fo_star = %3d \n",fo_star);
//              getchar();
           } // if2
        } // if1
        else { // else1
            // se houver piora, aceite o vizinho com uma determinada probabilidade
            x = randomico(0,1);
            if (x < exp(-delta/temperatura)){ // if3
               fo += delta;

               sobreposicao = sobreposicaoAnterior - sobreposicaoAnteriorColuna1 - sobreposicaoAnteriorColuna2 + calculaSobreposicao(sManha, sTarde, hEscolhido1) + calculaSobreposicao(sManha, sTarde, hEscolhido2);
               excessoDia = excessoDiaAnterior - excessoDia_s_lManha + calculaExcessoDia(sManha, pEscolhido) - excessoDia_s_lTarde + calculaExcessoDia(sTarde, pEscolhido);
               nroVezesProf = nroVezesProfAnterior - nroVezesProfAnteriorLinha + calculaPenalidadeNroVezesProfessor(sManha, sTarde, pEscolhido);
               printf("Solucao de piora (turnos manha e tarde): fo corrente = %d \n",fo);
               //getchar();
            } // if3
            else { // else2
              // Se o vizinho nao foi aceito, desfaca o movimento
              trocaHorarios(sManha, pEscolhido, hEscolhido1, hEscolhido2);
              trocaHorarios(sTarde, pEscolhido, hEscolhido1, hEscolhido2);
            } // else2
        } // else1
     } // while2
     // decresca a temperatura
     temperatura *= alfa;
     printf("Temperatura atual = %10.3f\n", temperatura);
     num_mudancas_temp += 1;
  } // while1

  printf("\n      ************** Melhor Solucao obtida pelo SA ******************* \n");
  atualiza_melhor_solucao(s_starManha, sManha, p, hs);
  atualiza_melhor_solucao(s_starTarde, sTarde, p, hs);
  printf("\n       ********* Melhor solucao para o turno da manha *********\n");
  imprime_solucao(s_starManha, p, hs);
  getchar();
  printf("\n\n       ********* Melhor solucao para o turno da tarde *********\n\n");
  imprime_solucao(s_starTarde, p, hs);
  getchar();
  printf("               Numero maximo de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);
  printf("\n                        funcao objetivo = %3d \n",fo_star);
  printf(" ************************************************************************* \n");
  printf("  Sobreposicao total = %d     Excesso dias = %d",calculaSobreposicaoMatriz(s_starManha, s_starTarde, hs), calculaExcessoDiaMatriz(s_starManha, p) + calculaExcessoDiaMatriz(s_starTarde, p));
  printf("      Nro Vezes Prof = %d", calculaPenalidadeNroVezesProfessorMatriz(s_starManha, s_starTarde, p));
  printf("\n ************************************************************************* \n");
  getchar();
  fo1 = fo_star;
  liberaVetor(vetorTurno);
  liberaVetor(vetorVezes);
  liberaMatriz(sManha, p);
  liberaMatriz(sTarde, p);
  liberaMatriz(s_starManha, p);
  liberaMatriz(s_starTarde, p);
}

//---------------------------------------------------------------------------


