#include "Util.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include "Descida.h"
#include "Util.h"
#include "SA.h"
#include "UArquivos.h"


float SA(int n,
         int *s,
         float **d,
         float alpha,
         float temp_inicial,
         float temp_final,
         int SAmax)
{
  int i, j, aux, iterT;
  float temperatura, delta, fo, fo_star;
  int *s_star;
  clock_t inicio_CPU, fim_CPU;

  s_star = cria_vetor(n);
  atualiza_vetor(s_star,s,n);
  temperatura = temp_inicial;
  fo_star = fo = calcula_fo(n, s, d);
  limpa_arquivo("SAsaida.txt");
  inicio_CPU = fim_CPU = clock();
  imprime_fo("SAsaida.txt", (fim_CPU - inicio_CPU)/CLK_TCK,fo_star,0);
  printf("Fo_star = %8.2f \t Temperatura = %8.2f \n", fo_star, temperatura);
  while (temperatura > temp_final){
    iterT = 0;
    while (iterT < SAmax){
      iterT++;
      // Gere um vizinho qualquer
      i = random(n);
      do{
        j = random(n);
      } while (j == i);
      float delta1 = calcula_delta(n, s, d, i, j);
      // Faz o movimento
      aux = s[j];
      s[j] = s[i];
      s[i] = aux;
      float delta2 = calcula_delta(n, s, d, i, j);
      delta = - delta1 + delta2;
      if (delta < 0){
         fo = fo + delta;
         if (fo < fo_star){
           fo_star = fo;
           atualiza_vetor(s_star,s,n);
           fim_CPU = clock();
           imprime_fo("SAsaida.txt", (fim_CPU - inicio_CPU)/CLK_TCK,fo_star,0);
           printf("Fo_star = %8.2f \t Temperatura = %8.2f \n", fo_star, temperatura);
         }
      }
      else{
        float x = randomico(0,1);
        if (x < exp(-delta/temperatura)){
           fo = fo + delta;
        }
        else{
          // Desfaz o movimento
          aux = s[j];
          s[j] = s[i];
          s[i] = aux;
        }
      }

    }
    temperatura = alpha * temperatura;
  }
  atualiza_vetor(s,s_star,n);
  libera_vetor(s_star);
  fim_CPU = clock();
  imprime_fo("SAsaida.txt", (fim_CPU - inicio_CPU)/CLK_TCK,fo_star,0);
  return fo_star;
}


float temperatura_inicial(int n,
                          int *s,
                          float **d,
                          float beta,
                          float gamma,
                          int SAmax)
{
  int i, j, aux, iterT, aceitos;
  float temperatura, delta, fo;
  bool continua;

  temperatura = 10;
  continua = true;
  while (continua){
    aceitos = 0;
    iterT = 0;
    while (iterT < SAmax){
      iterT++;
      // Gere um vizinho qualquer
      i = random(n);
      do{
        j = random(n);
      } while (j == i);
      float delta1 = calcula_delta(n, s, d, i, j);
      // Faz o movimento
      aux = s[j];
      s[j] = s[i];
      s[i] = aux;
      float delta2 = calcula_delta(n, s, d, i, j);
      delta = - delta1 + delta2;
      if (delta < 0){
         aceitos++;
      }
      else{
        float x = randomico(0,1);
        if (x < exp(-delta/temperatura)){
           aceitos++;
        }
      }
      // Desfaz o movimento
      aux = s[j];
      s[j] = s[i];
      s[i] = aux;
    }
    if (aceitos < gamma * SAmax){
      temperatura = beta * temperatura;
    }
    else
      continua = false;
  }
  return temperatura;
}

