#include <stdio.h>
#include <stdlib.h>
#include <Limits.h>
#include "Listas.h"
#include "Estruturas.h"
#include "Util.h"

void constroi_solucao(int n, int *s, float **distancia)
{
    for (int j=0; j < n; j++) s[j] = j;
}


/* Constroi uma solucao de forma gulosa, no caso,
   implementa o Metodo construtivo do vizinho mais proximo */
void constroi_solucao_gulosa(int n, int *s, float **d)
{
    struct lista *inicio_LC, *final_LC, *nao_visitada;
    int tamanho_LC;

    /* Inicio da Fase de Construcao de uma solucao */
    printf("\n Construindo nova solucao ...\n");
    inicio_LC = final_LC = NULL;
    for (int j=1; j<n; j++){
      nao_visitada = (struct lista *)malloc(sizeof(struct lista));
      if (!nao_visitada) {
         printf("Faltando memoria ...\n");
         exit(1);
      }
      /* vou inserir um registro no final de uma lista  */
      nao_visitada->campo1 = j;
      nao_visitada->campo2 = 0;
      insere_final_lista(nao_visitada, &inicio_LC, &final_LC);
      tamanho_LC = tamanho_lista(&inicio_LC, &final_LC);
      //printf("Tamanho da LC = %2d \n", tamanho_LC);
      //mostra_lista(&inicio_LC, &final_LC);
    }
    s[0]=0;  /* A cidade origem  a cidade 0 */

    int j = 1;
    int mais_proxima;
    float dist;
    while (j < n){
      dist = INT_MAX;
      struct lista *registro = inicio_LC;
      int pos = 1;
      while (registro) {
//        printf("L[%2d]   campo1 = %2d  campo2 = %2d  \n",
//               pos, registro->campo1, registro->campo2);
        if (d[s[j-1]][registro->campo1] < dist){
          dist = d[s[j-1]][registro->campo1];
          mais_proxima = registro->campo1;
        }
        registro = registro->proximo;   // obtem prximo endereo
        pos++;
      }
      /* Insere a cidade mais proxima apos a ultima cidade inserida*/
      s[j] = mais_proxima;
      /* Apaga a cidade mais_proxima da lista de nao visitadas */
      registro = encontra_registro(mais_proxima, 0,&inicio_LC);
      apaga_registro(registro,&inicio_LC,&final_LC);
//      mostra_lista(&inicio_LC, &final_LC);
      j++;
    }
}




/* Constroi uma solucao de forma aleatoria */
void constroi_solucao_aleatoria(int n, int *s, float **d)
{
    struct lista *inicio_LC, *final_LC, *nao_visitada;
    int tamanho_LC;

    /* Inicio da Fase de Construcao de uma solucao */
    inicio_LC = final_LC = NULL;
    for (int j=1; j<n; j++){
      nao_visitada = (struct lista *)malloc(sizeof(struct lista));
      if (!nao_visitada) {
         printf("Faltando memoria ...\n");
         exit(1);
      }
      /* vou inserir um registro no final de uma lista  */
      nao_visitada->campo1 = j;
      nao_visitada->campo2 = 0;
      insere_final_lista(nao_visitada, &inicio_LC, &final_LC);
    }
    s[0]=0;  /* A cidade origem  a cidade 0 */

    int j = 1;
    int cidade_escolhida;
    while (j < n){
      struct lista *registro = inicio_LC;
      tamanho_LC = tamanho_lista(&inicio_LC,&final_LC);
      //printf("Tamanho da lista = %d \n",tamanho_LC);
      int posicao_escolhida = random(tamanho_LC);
      registro = encontra_registro_lista(posicao_escolhida,&inicio_LC);
      cidade_escolhida = registro->campo1;
      /* Insere a cidade escolhida apos a ultima cidade inserida*/
      s[j] = cidade_escolhida;
      /* Apaga a cidade escolhida da lista de nao visitadas */
//      registro = encontra_registro(cidade_escolhida, 0,&inicio_LC);
      apaga_registro(registro,&inicio_LC,&final_LC);
//      mostra_lista(&inicio_LC, &final_LC);
      j++;
    }
}




/* Constroi uma solucao parcialmente gulosa */
void constroi_solucao_parcialmente_gulosa(int n, int *s, float **d, float alpha)
{
    struct lista *inicio_LC, *final_LC, *nao_visitada;
    int tamanho_LC;

    /* Inicio da Fase de Construcao de uma solucao */
    inicio_LC = final_LC = NULL;
    for (int j=1; j<n; j++){
      nao_visitada = (struct lista *)malloc(sizeof(struct lista));
      if (!nao_visitada) {
         printf("Faltando memoria ...\n");
         exit(1);
      }
      /* vou inserir um registro no final de uma lista  */
      nao_visitada->campo1 = j;
      nao_visitada->campo2 = 0;
      insere_final_lista(nao_visitada, &inicio_LC, &final_LC);
    }
    s[0]=0;  /* A cidade origem  a cidade 0 */

    int j = 1;
    int cidade_escolhida;
    while (j < n){
      struct lista *registro = inicio_LC;
      tamanho_LC = tamanho_lista(&inicio_LC,&final_LC);
      //printf("Tamanho da lista de candidatos = %d \n",tamanho_LC);
      /* Ordenando a lista encadeada   */

      struct lista *inicio_LC_ordenada, *final_LC_ordenada;
      inicio_LC_ordenada = final_LC_ordenada = NULL;

      while (registro){
        nao_visitada = (struct lista *)malloc(sizeof(struct lista));
        if (!nao_visitada) {
           printf("Faltando memoria ...\n");
           exit(1);
        }
        nao_visitada->campo1 = registro->campo1;
        nao_visitada->campo2 = registro->campo2;
        nao_visitada->campo3 = d[s[j-1]][nao_visitada->campo1];
        /* vou inserir um registro de forma ordenada em uma lista  */
        insere_ordenado_lista(nao_visitada, &inicio_LC_ordenada, &final_LC_ordenada);
        registro = registro->proximo;   /* obtem prximo endereo */
      }
      //mostra_lista(&inicio_LC_ordenada, &final_LC_ordenada);


      int tamanho_LRC = MAX(1, alpha * tamanho_LC);
      //printf("Tamanho da lista restrita de candidatos = %d \n",tamanho_LRC);
      int posicao_escolhida = random(tamanho_LRC);
      registro = encontra_registro_lista(posicao_escolhida,&inicio_LC_ordenada);
      cidade_escolhida = registro->campo1;
      //printf("Cidade escolhida = %d \n\n",cidade_escolhida);

      /* Apaga a lista de candidatos ordenada */
      apaga_lista(&inicio_LC_ordenada, &final_LC_ordenada);

      /* Insere a cidade escolhida apos a ultima cidade inserida*/
      s[j] = cidade_escolhida;
      /* Apaga a cidade escolhida da lista de nao visitadas */
      registro = encontra_registro(cidade_escolhida, 0, &inicio_LC);
      apaga_registro(registro,&inicio_LC,&final_LC);
//      mostra_lista(&inicio_LC, &final_LC);
      j++;
    }
}

