//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include "Util.h"
#include "UArquivos.h"
#include "UEstruturas.h"
#include "Descida.h"
//---------------------------------------------------------------------------


int main(int argc, char* argv[])
{
  int n;              // numero de cidades
  int x_dep, y_dep;   // localizacao do deposito (x,y)
  int cap;           // capacidade dos veiculos
  int *s;          // vetor solucao corrente
  int *demanda;    // vetor de demanda de cada cidade
  float **d;      // matriz de distancias entre as cidades
  float fo;          // funcao objetivo corrente
  clock_t inicio_CPU, fim_CPU;



  srand(1000); // pega o numero 1000 como semente de numeros aleatorios
//  srand((unsigned) time(NULL)); // pega a hora do relogio como semente

  obter_parametros_prob("c50info.txt", &n, &cap, &x_dep, &y_dep);
  n = n + 1;
  s = cria_vetor(n); // vetor solucao
  demanda = cria_vetor(n); // vetor de demanda de cada cidade
  d = cria_matriz_float(n, n); // matriz de distancias

  le_arq_matriz("c50.txt", n, x_dep, y_dep, d, demanda);

  constroi_solucao(n, s, d);

  inicio_CPU = clock();
  fo = descida(n, s, d);
  fim_CPU = clock();

//  fo = descida(n, s, d);

  printf("\n ******* Melhor fo = %f ************ \n",fo);
  imprime_rota(s, n);
  printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
  getchar();

  libera_vetor(s);
  libera_vetor(demanda);
  libera_matriz_float(d, n);
  return 0;
}
//---------------------------------------------------------------------------
 
