#include <stdio.h>
#include <limits.h>
#include <stdlib.h>
#include "Construcao.h"
#include "Util.h"
#include "Descida.h"
#include "VNS.h"

float VNS(int n, int *s, float **d, int VNS_max, int r){
   int *s_linha,
       iter = 0,
       k;
   float fo,
       fo_linha,
       fo_star = INT_MAX;

   s_linha = cria_vetor(n);
   fo_star = fo = calcula_fo(n,s,d);
   printf("Iteracao VNS = %3d \t  fo_star = %10.4f \n",iter,fo_star);
   while (iter < VNS_max){
     iter++;
     k = 1;
     while (k <= r){
       // Escolher vizinho s' qualquer na k-esima vizinhanca de s
       atualiza_vetor(s_linha,s,n);
       fo_linha = gera_vizinho(n,s_linha,d,fo,k);
       fo = descida(n,s_linha,d);
       if (fo < fo_star){
         fo_star = fo;
         atualiza_vetor(s, s_linha, n);
         printf("Iteracao VNS = %3d \t  fo_star = %10.4f \n",iter,fo_star);
         k = 1;
       }
       else
         k++;
     }
   }
   libera_vetor(s_linha);
   return fo_star;
}



float gera_vizinho_1(int n,
                     int *s,
                     float **d,
                     float fo)
{
  int i,j,aux;
  float fo_viz;

  i = random(n);
  do{
    j = random(n);
  } while(i == j);
  float delta1 = calcula_delta(n,s,d,i,j);
  aux = s[i];
  s[i] = s[j];
  s[j] = aux;
  float delta2 = calcula_delta(n,s,d,i,j);
  fo_viz = fo - delta1 + delta2;
  return fo_viz;
}


float gera_vizinho(int n,
                   int *s,
                   float **d,
                   float fo,
                   int k)
{
  for (int i=0; i<k; i++)
    fo = gera_vizinho_1(n,s,d,fo);

  return fo;

}//gera_vizinho
