/*
Tecnicas Heuristicas para resolucao do Problema do Caixeiro Viajante
Autor: Marcone Jamilson Freitas Souza
Local: Departamento de Computacao - Universidade Federal de Ouro Preto
Homepage: www.decom.ufop.br/prof/marcone
Data: 03-12-2004
*/

//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include "Util.h"
#include "Arquivos.h"
#include "Estruturas.h"
#include "Descida.h"
#include "SA.h"
#include "Menus.h"
#include "BT.h"
#include "Construcao.h"
#include "GRASP.h"
#include "VNS.h"
#include "Menus.cpp"

//---------------------------------------------------------------------------


int main(int argc, char* argv[])
{
  int n,                    // numero de cidades
      x_dep, y_dep,         // localizacao do deposito (x,y)
      cap,                  // capacidade dos veiculos
      *s,                   // vetor solucao corrente
      *demanda;             // vetor de demanda de cada cidade
  float **d,                // matriz de distancias entre as cidades
        fo,                 // funcao objetivo corrente
        temperatura_inicial;// temperatura inicial Simulated Annealing
  clock_t inicio_CPU,       // clock no inicio da aplicacao do metodo
        fim_CPU;            // clock no final da aplicacao do metodo



  obter_parametros_prob("c50info.txt", &n, &cap, &x_dep, &y_dep);
  n = n + 1;
  s = cria_vetor(n); // vetor solucao
  demanda = cria_vetor(n); // vetor de demanda de cada cidade
  d = cria_matriz_float(n, n); // matriz de distancias

  le_arq_matriz("c50.txt", n, x_dep, y_dep, d, demanda);

  int escolha = 0;
  do {
    escolha = menu_principal();
    switch (escolha) {
    case 1: /* Geracao de uma solucao inicial */
           switch(menu_solucao_inicial()) {
           case 1: /* Geracao gulosa de uma solucao inicial via metodo do vizinho mais proximo */
                 constroi_solucao_gulosa_vizinho_mais_proximo(n,s,d);
                 fo = calcula_fo(n, s, d);
                 printf("\nSolucao construida de forma gulosa:\n");
                 imprime_rota(s, n);
                 printf("Funcao objetivo = %f\n",fo);
	         break;
           case 2: /* Geracao parcialmente gulosa de uma solucao inicial via metodo do vizinho mais proximo */
                 constroi_solucao_parcialmente_gulosa_vizinho_mais_proximo(n,s,d,0.05);
                 fo = calcula_fo(n, s, d);
                 printf("\nSolucao construida de forma parcialmente gulosa pelo Metodo do Vizinho Mais Proximo :\n");
                 imprime_rota(s, n);
                 printf("Funcao objetivo = %f\n",fo);
	         break;
           case 3: /* Geracao gulosa de uma solucao inicial via metodo da insercao mais barata */
                 //constroi_solucao_insercao_mais_barata(n,s,d);
                 constroi_solucao_gulosa_insercao_mais_barata(n, s, d);
                 fo = calcula_fo(n, s, d);
                 printf("\nSolucao construida de forma gulosa pelo Metodo da Insercao Mais Barata:\n");
                 imprime_rota(s, n);
                 printf("Funcao objetivo = %f\n",fo);
	         break;
           case 4: /* Geracao parcialmente gulosa de uma solucao inicial via insercao mais barata */
                 printf("\nAinda nao implementada ...\n");
	         break;
           case 5: /* Geracao aleatria de uma solucao inicial */
                 srand(1000); // pega o numero 1000 como semente de numeros aleatorios
                 //srand((unsigned) time(NULL)); // pega a hora do relogio como semente
                 //constroi_solucao(n, s, d);
                 //embaralha_vetor(s,n);
                 constroi_solucao_aleatoria(n,s,d);
                 fo = calcula_fo(n, s, d);
                 printf("\nSolucao construida de forma aleatoria:\n");
                 imprime_rota(s, n);
                 printf("Funcao objetivo = %f\n",fo);
	         break;
           }
           break;
    case 2: /* Descida */
           inicio_CPU = clock();
           fo = descida(n, s, d);
           fim_CPU = clock();
           printf("\nSolucao construida usando o Metodo da Descida:\n");
           imprime_rota(s, n);
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
           break;
    case 3: /* Descida Randmica */
           fo = descida_randomica(n, s, d, 2500);
           printf("\nSolucao construida usando o Metodo da Descida Randomica:\n");
           imprime_rota(s, n);
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
           break;
    case 4: /* Descida Parcial */
           inicio_CPU = clock();
           fo = descida_parcial(n, s, d, 20);
           fim_CPU = clock();
           printf("\nSolucao construida usando o Metodo da Descida:\n");
           imprime_rota(s, n);
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
           break;
    case 5: /* Simulated Annealing */
           temperatura_inicial = calcula_temperatura_inicial(n,s,d,1.1,0.95,500);
           inicio_CPU = clock();
           fo = SA(n,s,d,0.995,temperatura_inicial,0.01,500);
           fim_CPU = clock();
           printf("\nSolucao construida usando o Metodo Simulated Annealing:\n");
           imprime_rota(s, n);
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
           break;
    case 6: /* Busca Tabu */
           inicio_CPU = clock();
           fo = BT(n,s,d,10,300);
           fim_CPU = clock();
           printf("\nSolucao construida usando o Metodo Busca Tabu:\n");
           imprime_rota(s, n);
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
           break;
    case 7: /* GRASP */
           inicio_CPU = clock();
           fo = GRASP(n,s,d,0.10,100);
           fim_CPU = clock();
           printf("\nSolucao construida usando o Metodo GRASP:\n");
           imprime_rota(s, n);
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
           break;
    case 8: /* VND */
           printf("\n VND ainda nao implementado ... \n");
           break;
    case 9: /* VNS */
           inicio_CPU = clock();
           fo = VNS(n,s,d,3,5);
           fim_CPU = clock();
           printf("\nSolucao construida usando o Metodo VNS:\n");
           imprime_rota(s, n);
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Tempo de CPU = %f segundos\n",(fim_CPU - inicio_CPU)/CLK_TCK);
//           printf("\n VNS ainda nao implementado ... \n");
           break;
    case 10: /* Algoritmos Geneticos */
           printf("\n AGs ainda nao implementado ... \n");
           break;
    default:
          break;
    }
  } while (escolha != 0);


  libera_vetor(s);
  libera_vetor(demanda);
  libera_matriz_float(d, n);
  return 0;
}
//--------------------------------------------------------------------------- 
