#include <stdio.h>
#include <limits.h>
#include "Construcao.h"
#include "Util.h"
#include "Descida.h"
#include "GRASP.h"

float GRASP(int n, int *s, float **d, float alpha, int GRASP_max){
   int *s_star,
       iter = 0;
   float fo_star = INT_MAX;
   float fo;

   s_star = cria_vetor(n);
   while (iter < GRASP_max){
     iter++;
     constroi_solucao_parcialmente_gulosa_vizinho_mais_proximo(n,s,d,alpha);
     fo = descida(n,s,d);
     if (fo < fo_star){
       fo_star = fo;
       atualiza_vetor(s_star, s, n);
       printf("Iteracao GRASP = %3d \t  fo_star = %8.2f \n",iter,fo_star);
     }
   }
   atualiza_vetor(s,s_star,n);
   libera_vetor(s_star);
   return fo_star;
}
 