#include<iostream>
#include<vector>
#include<ctime>
#include<fstream>
#include<cassert>
#include "Crew.h"
#include "Grasp.h"

using namespace std;

extern Pesos pesos;

int np_duplas(vector<Crew>&);
void ordena_vetor_trip(vector<Crew>&);
int np_duplas(vector<Crew>&);
unsigned long int f_objetivo_global(vector<Crew>& v);
int nsem_tarefas(vector<Crew>&);
unsigned long int movimento(Crew,Crew,int,unsigned long int);
void dump_file(const vector<Crew>& v, char* filename);

/********************************************************************
 * Metodo: f_objetivo_global()
 * Objetivo: Calcular a funcao objetivo global da solucao.
 * Autor: Leonardo X. T. Cardoso
 * Data: 30/08/02
 *******************************************************************/
unsigned long int f_objetivo_global(vector<Crew>& v)
{
    unsigned long int s_global = 0;


    for(int i = 0; i < (int)v.size(); ++i){
       s_global = s_global + v[i].f_objetivo();
    }

    s_global = s_global + pesos.p_duplas*np_duplas(v);

    return s_global;
}


/********************************************************************
 * Metodo: np_duplas()
 * Objetivo: Calcular o excesso de pegadas duplas.
 * Autor: Margarida, ....
 *******************************************************************/
int np_duplas(vector<Crew>& v)
{
   int cont = 0;
   cl_iterator iter,
         	next; //Apontador para o proximo elemento do conteiner


   for(int i = 0; i < (int)v.size(); ++i)
        if(v[i].jornada.size() > 1){
                v[i].jornada.sort();
                iter = v[i].jornada.begin();
                next = v[i].jornada.begin();
                ++next;
   	        do{
               if((next->h_inicial - iter->h_final) > 120)
   	   	        cont+=1;
                ++next;
	            ++iter;
	        }while(next != v[i].jornada.end());
         }
   cont=cont-NP_DUPLASMAX;
   return cont;
}

/********************************************************************
 * Metodo: ordena_vetor_trip()
 * Objetivo: Ordena a jornada de todos os tripulantes.
 * Autor: Leonardo X. T. Cardoso
 * Data: 30/08/02
 *******************************************************************/
void ordena_vetor_trip(vector<Crew>& v)
{

    for(int i = 0; i < (int)v.size(); ++i){
        v[i].jornada.sort();
    }
}


/********************************************************************
 * Metodo: nsem_tarefas()
 * Objetivo: Funo para retornar nmero de tripulantes sem tarefas.
 * Autor: Margarida, ..
 *******************************************************************/
int nsem_tarefas(vector<Crew>& v)
{
    int n = 0;

    for(int i = 0; i < (int)v.size(); ++i){
        if (v[i].jornada.size()==0)
            n++;
    }
    return n;
}

/***********************************************************************************
 * Metodo: movimento()
 * Objetivo: Funo para fazer um movimento e retornar a funcao objetivo resultante.
 * Autor: Leonardo X. T. cardoso
 * data: 03/09/02
 ************************************************************************************/
unsigned long int movimento(Crew src_trip, Crew dst_trip, int i, unsigned long int objetivo)
{

    unsigned long int old_src_trip, //Valor antigo da funcao objetivo do tripulante onde a tarefa sera retirada.
                      new_src_trip, //Novo valor da funcao objetivo de onde a tarefa sera retirada.
                      old_dst_trip, //valor antigo da funcao objetivo de onde a tarefa sera inserida.
                      new_dst_trip, //Novo valor da funcao objetivo de onde a tarefa sera inserida.
                      old_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera retirada.
                      old_dst_pdupla, // Novo valor da pegada dupla do tripulante onde a tarefa sera retirada.
                      new_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.
                      new_dst_pdupla;   //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.
    Task t;

    old_src_pdupla = pesos.p_duplas*src_trip.p_duplas();
    old_dst_pdupla = pesos.p_duplas*dst_trip.p_duplas();
    old_src_trip = src_trip.f_objetivo();
    old_dst_trip = dst_trip.f_objetivo();

    t = src_trip.remover_tarefa(i);
    dst_trip.adicionar_tarefa(t);

    new_src_pdupla = pesos.p_duplas*src_trip.p_duplas();
    new_dst_pdupla = pesos.p_duplas*dst_trip.p_duplas();
    new_src_trip = src_trip.f_objetivo();
    new_dst_trip = dst_trip.f_objetivo();


    objetivo = objetivo - old_src_trip - old_dst_trip - old_src_pdupla
               - old_dst_pdupla + new_src_pdupla + new_dst_pdupla +
               new_src_trip + new_dst_trip;

    return objetivo;
}

void dump_file(const vector<Crew>& v, char* filename)
{
    cl_iterator iter;
    ofstream out_file( filename, ios::out | ios::trunc);

    assert(out_file);

    out_file << "\t\tProgramacao dos Tripulantes.\n";
    out_file << "A solucao abaixo possui funo objetivo global = " << f_objetivo_global(v) << "\n";
    out_file << "_________________________________________________________________________\n";

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "\n_________________________________________________________\n";
        out_file << "\n\t\tTarefas do Tripulante " << i << "\n";
        //out_file << "Funcao objetivo do tripulante: " << v[i].f_objetivo() << "\n";
        out_file << "_________________________________________________________\n";
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter)
            out_file << *iter;
        }

    out_file.close();
}


