/***************************************************************************
                          			Task.cpp
-----------------------------------------------------------------------------------------------------------------
    begin                : Fri Jul 26 2002
    copyright          : (C) 2002 by Leonardo X. T. Cardoso
    email                : leoxt@arbornet.org
 ***************************************************************************/
#include<iostream>
#include "Task.h"
using namespace std;

Task::Task()
{
	n_veiculo = 0;
	h_inicial = 0;
	h_final = 0;
	p_inicial = 0;
	p_final = 0;
	f_acumulada = 0;
	l_inicial = 0;
	l_final = 0;
        artificial = false;
}

Task::Task(int n_veiculo, int h_inicial, int h_final,int p_inicial,
           int p_final, int f_acumulada, int l_inicial, int l_final, bool artificial)
{
	this->n_veiculo = n_veiculo;
	this->h_inicial = h_inicial;
	this->h_final = h_final;
	this->p_inicial = p_inicial;
	this->p_final = p_final;
	this->f_acumulada = f_acumulada;
	this->l_inicial = l_inicial;
	this->l_final = l_final;
        this->artificial = artificial;
}

int Task::duracao()
{
	return (h_final - h_inicial);
}

ostream& operator<<(ostream& output, const Task& task)
{
	output << "\nVeiculo: " << task.n_veiculo
		<< "\nHora Inicial: "<< task.h_inicial
		<< "\nHora Final: " <<	task.h_final
		<< "\nPonto Inicial:" << task.p_inicial
		<< "\nPonto Final: " << task.p_final
		<< "\nFolga Acumulada: "<< task.f_acumulada
		<< "\nLinha Inicial: " << task.l_inicial
		<< "\nLinha Final: " << task.l_final;

        if(task.artificial)
        {
                output << "\n*TAREFA VIRTUAL*\n";
        }

        output << endl;

	return output;
}

Task& Task::operator=(const Task& src)
{
	n_veiculo    = src.n_veiculo;
	h_inicial    = src.h_inicial;
	h_final      = src.h_final;
	p_inicial    = src.p_inicial;
	p_final      = src.p_final;
	f_acumulada  = src.f_acumulada;
	l_inicial    = src.l_inicial;
	l_final      = src.l_final;
   artificial   = src.artificial;

	return *this;
}

bool Task::operator<(const Task& task)
{
	return (h_inicial < task.h_inicial) ? true : false;
}

bool Task::operator>(const Task& task)
{
	return (h_inicial > task.h_inicial) ? true : false;
}

bool Task::operator==(const Task& task)
{
  return   n_veiculo == task.n_veiculo &&
           h_inicial == task.h_inicial &&
           h_final   == task.h_final   &&
       	   p_inicial == task.p_inicial &&
           p_final   == task.p_final   &&
           f_acumulada == task.f_acumulada &&
       	   l_inicial   == task.l_inicial &&
           l_final == task.l_final &&
           artificial == task.artificial;
}

bool Task::operator!=(const Task& task)
{
  return   n_veiculo != task.n_veiculo ||
           h_inicial != task.h_inicial ||
           h_final   != task.h_final   ||
       	   p_inicial != task.p_inicial ||
           p_final   != task.p_final   ||
           f_acumulada != task.f_acumulada ||
       	   l_inicial   != task.l_inicial ||
           l_final != task.l_final ||
           artificial != task.artificial;
}
/*
bool Task::operator<(const Task& x, const Task& &y)
 {
return return (x.h_inicial < y.h_inicial) ? true : false;
 }
 */

