//---------------------------------------------------------------------------

#ifndef TabuSearchH
#define TabuSearchH
#include<iostream>
#include<vector>
#include<ctime>
#include<fstream>
#include<cassert>
#include<ctime>
#include "config.hpp"
#include "Crew.h"
#include "Pesos.h"
#include "CrewUtil.h"
using namespace std;

/* Soluo 1-optimal */
class solucao
{
   public:

      int src_trip;
      int dst_trip;   // Variveis utilizadas para movimento 1-optimal
      int n_tarefa;
      int vi;
      int vj;
      unsigned long int objetivo;
      Task task;

};

/* Soluo 2-optimal */
class solucao_2optimal
{
   public:

      int trip1;
      int trip2;
      int n_tarefa1;
      int n_tarefa2;      
      int vi;
      int vj;
      unsigned long int objetivo;
      Task task1;
      Task task2;      

};

/* Soluo Link */
class solucao_link
{
   public:

      int trip1;
      int trip2;
      int n_tarefa1;
      int n_tarefa2;      
      int vi;
      int vj;
      unsigned long int objetivo;
      Task task1;
      Task task2;      

};

/* Busca Tabu */
class TabuSearch{

   public:

      //Parametros:
      void do_tabu(vector<Crew>&, double, int, int, int);

      //Dados
      int tipo_movimento;

   private:
   
      //Dados
      vector<Crew> melhor_solucao;               // Vetor onde sera armazenado a melhor solucao
      unsigned long int melhor_fobjetivo;
      list<solucao> tabu_list;                   // Lista Tabu
      list<solucao_2optimal> tabu_list_2optimal; // Lista Tabu 2-optimal
      list<solucao_link> tabu_list_link;         // Lista Tabu Link
      solucao sol;
      solucao_2optimal sol_2;
      solucao_link sol_link;
      unsigned int list_size;
      ofstream file_obj;

      //Metodos
      inline bool is_tabu(const solucao&);
      inline bool is_tabu(const solucao_2optimal&);
      inline bool is_tabu(const solucao_link&);
      void insere_tabu(const solucao);
      unsigned long int melhor_vizinho(vector<Crew>&,unsigned long int,int&,int);
      void randomize_vector(const vector<Crew>&, vector<Crew>& );
      inline unsigned long int movimento(Crew,Crew,int,unsigned long int,Task&,int&);
      inline unsigned long int movimento_2optimal(Crew,Crew,int,int,unsigned long int,Task&,Task&,int&);
      inline unsigned long int movimento_link(Crew,Crew,int,int,unsigned long int,Task&,Task&,int&);
      CrewUtil util;

};

//---------------------------------------------------------------------------
#endif
