//---------------------------------------------------------------------------
#include "TabuSearch.h"

/***********************
 * Movimento 2-optimal *
 ***********************/
unsigned long int TabuSearch::movimento_2optimal(Crew trip1, Crew trip2, int i, int j,
                               unsigned long int objetivo, Task& task1, Task& task2, int& npduplas)
{
   long int old_trip1,     // Valor antigo da funcao objetivo do 'tripulante 1'
            new_trip1,     // Novo valor da funcao objetivo do 'tripulante 1'
            old_trip2,     // Valor antigo da funcao objetivo do 'tripulante 2'
            new_trip2;     // Novo valor da funcao objetivo do 'tripulante 2'
   int old_trip1_pdupla,   // Valor antigo da pegada dupla do 'tripulante 1'
       new_trip1_pdupla,   // Novo valor da pegada dupla do 'tripulante 1'
       old_trip2_pdupla,   // Valor antigo da pegada dupla do 'tripulante 2'
       new_trip2_pdupla;   // Novo valor da pegada dupla do 'tripulante 2'

   long int new_value_pdupla,
            old_value_pdupla;
            
   Task t1, t2;

   old_trip1 = trip1.f_objetivoN();
   old_trip2 = trip2.f_objetivoN();
   old_trip1_pdupla = trip1.p_duplas();
   old_trip2_pdupla = trip2.p_duplas();

   old_value_pdupla = pesos.get_pdupla(npduplas);

   t1 = trip1.remover_tarefa(i);
   t2 = trip2.remover_tarefa(j);
   task1 = t1;
   task2 = t2;
   trip1.adicionar_tarefa(t2);
   trip2.adicionar_tarefa(t1);

   new_trip1 = trip1.f_objetivoN();
   new_trip2 = trip2.f_objetivoN();
   new_trip1_pdupla = trip1.p_duplas();
   new_trip2_pdupla = trip2.p_duplas();

   npduplas = npduplas - (old_trip1_pdupla + old_trip2_pdupla)
                       + (new_trip1_pdupla + new_trip2_pdupla);

   new_value_pdupla = pesos.get_pdupla(npduplas);

   return objetivo - (old_trip1 + old_trip2 + old_value_pdupla)
                   + (new_trip1 + new_trip2 + new_value_pdupla);
}


/******************
 * Movimento Link *
 ******************/
unsigned long int TabuSearch::movimento_link(Crew trip1, Crew trip2, int i, int j,
                               unsigned long int objetivo, Task& task1, Task& task2, int& npduplas)
{
   long int old_trip1,     // Valor antigo da funcao objetivo do 'tripulante 1'
            new_trip1,     // Novo valor da funcao objetivo do 'tripulante 1'
            old_trip2,     // Valor antigo da funcao objetivo do 'tripulante 2'
            new_trip2;     // Novo valor da funcao objetivo do 'tripulante 2'
   int old_trip1_pdupla,   // Valor antigo da pegada dupla do 'tripulante 1'
       new_trip1_pdupla,   // Novo valor da pegada dupla do 'tripulante 1'
       old_trip2_pdupla,   // Valor antigo da pegada dupla do 'tripulante 2'
       new_trip2_pdupla;   // Novo valor da pegada dupla do 'tripulante 2'

   long int new_value_pdupla,
            old_value_pdupla;
            
   vector<Task> t1, t2;

   old_trip1 = trip1.f_objetivoN();
   old_trip2 = trip2.f_objetivoN();
   old_trip1_pdupla = trip1.p_duplas();
   old_trip2_pdupla = trip2.p_duplas();

   old_value_pdupla = pesos.get_pdupla(npduplas);

   for (int k = i; k < trip1.jornada.size(); ++k)
      t1[k - j] = trip1.remover_tarefa(k);
   for (int k = j; k < trip2.jornada.size(); ++k)
      t2[k - j] = trip2.remover_tarefa(k);

   task1 = t1[0];
   task2 = t2[0];

   for (int k = 0; k < t1.size(); ++k)
      trip2.adicionar_tarefa(t1[k]);
   for (int k = 0; k < t2.size(); ++k)
      trip1.adicionar_tarefa(t2[k]);
   
   new_trip1 = trip1.f_objetivoN();
   new_trip2 = trip2.f_objetivoN();
   new_trip1_pdupla = trip1.p_duplas();
   new_trip2_pdupla = trip2.p_duplas();

   npduplas = npduplas - (old_trip1_pdupla + old_trip2_pdupla)
                       + (new_trip1_pdupla + new_trip2_pdupla);

   new_value_pdupla = pesos.get_pdupla(npduplas);

   return objetivo - (old_trip1 + old_trip2 + old_value_pdupla)
                   + (new_trip1 + new_trip2 + new_value_pdupla);
}


/***********************
 * Movimento 1-optimal *
 ***********************/
unsigned long int TabuSearch::movimento(Crew src_trip, Crew dst_trip, int i,
                                unsigned long int objetivo, Task& task, int& npduplas)
{

    long int old_src_trip, //Valor antigo da funcao objetivo do tripulante onde a tarefa sera retirada.
           new_src_trip, //Novo valor da funcao objetivo de onde a tarefa sera retirada.
           old_dst_trip, //valor antigo da funcao objetivo de onde a tarefa sera inserida.
           new_dst_trip; //Novo valor da funcao objetivo de onde a tarefa sera inserida.
    int    old_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera retirada.
           old_dst_pdupla, // Novo valor da pegada dupla do tripulante onde a tarefa sera retirada.
           new_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.
           new_dst_pdupla;   //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.

    long int new_value_pdupla,old_value_pdupla,
             old_tarefa,old_tarefa_src,
             new_tarefa,new_tarefa_src;
    Task t;

    old_src_pdupla = src_trip.p_duplas();
    old_dst_pdupla = dst_trip.p_duplas();
    old_src_trip = src_trip.f_objetivoN();
    old_dst_trip = dst_trip.f_objetivoN();

    if (dst_trip.jornada.size() != 0)
    {
       old_tarefa = pesos.num_trip;
    }
    else
    {
       old_tarefa = 0;
    }

   old_tarefa_src = pesos.num_trip;


   old_value_pdupla = pesos.get_pdupla(npduplas);

   t = src_trip.remover_tarefa(i);
   task = t;
   dst_trip.adicionar_tarefa(t);

   if(src_trip.jornada.size() == 0)
   {
      new_tarefa_src = 0;
   }
   else
   {
      new_tarefa_src = pesos.num_trip;
   }

   new_tarefa = pesos.num_trip;

   new_src_pdupla = src_trip.p_duplas();
   new_dst_pdupla = dst_trip.p_duplas();
   new_src_trip = src_trip.f_objetivoN();
   new_dst_trip = dst_trip.f_objetivoN();

   npduplas = npduplas - old_src_pdupla - old_dst_pdupla + new_src_pdupla + new_dst_pdupla;
   new_value_pdupla = pesos.get_pdupla(npduplas);

   return (objetivo - old_src_trip - old_dst_trip + new_src_trip + new_dst_trip
          - old_value_pdupla - old_tarefa - old_tarefa_src  + new_value_pdupla
          + new_tarefa + new_tarefa_src);
}

//Parametros: vc, vetor onde esta armazenada a solucao.
//t_vizinhanca, tamanho da vizinhanca.
//btmax, maximo de iteracoes sem melhora.
//list_size, tamanho da lista tabu.
//n_iter, numero de iteracoes onde o tamanho da lista tabu ira ser alterada.
void TabuSearch::do_tabu(vector<Crew>& vc, double t_vizinhanca, int btmax, int list_size, int n_iter)
{

/***********************/
   tipo_movimento = 1;
/***********************/

   int sem_melhora,vi,vj,tamanho,n_tarefa,total_pduplas;
   int iteracoes = 0;
   unsigned long int f_objetivo,movimento_atual,melhor_movimento;
   Task t, task1, task2;
   vector<Task> v_t1, v_t2;

   time_t t1,t2;
   int tempo = 0;

   int ppdupla;
   //bool completa = false;

   t_vizinhanca = t_vizinhanca/100;
   tamanho = max(1,(int)(t_vizinhanca*vc.size()));

   vector<Crew> vetor(tamanho);

   f_objetivo =  util.f_objetivo_global(vc);
   this->melhor_fobjetivo = f_objetivo;

   cout << "\nFuncao Objetivo atual: " << f_objetivo;
   sem_melhora=0;

   //file_obj.open("file_obj.txt", ios::out | ios::app);

   assert(file_obj);

   this->list_size = list_size;
   //iter = 0;
   //melhor_iter = 0;
   this->melhor_solucao = vc;
   util.init_vector_crew(vc);
   time(&t1);
   total_pduplas = util.pduplas_total(vc);
   int tempolimite = 1000;
   while(tempo < tempolimite)
   {
      //(iter - melhor_iter) < btmax){
      //++iter;
      ++iteracoes;
      // ++total_iter;

      /*Inicializacao do vetor onde estarao os tripulantes a serem percorridos*/
      /*
      if(sem_melhora > btmax){

         if(completa == false)
         {
            cout << "\nPreparando para analisar vizinhanca completa.\n";
            vetor.resize(vc.size());
            completa = true;
         }
         randomize_vector(vc,vetor);
      }
      else {
         if((sem_melhora == 0) && (vetor.size() == vc.size()))
         {
            cout << "\nRedimensionando vetor para analisar " << t_vizinhanca*100
                 << "% da vizinhanca.\n";
            vetor.resize(tamanho);
            completa = false;
         }
         randomize_vector(vc,vetor);
      }
      */

      randomize_vector(vc,vetor);

      //time(&t1);

      // time(&t2);
      // tempo = t2-t1;

      if (tipo_movimento == 1)
      {
         f_objetivo = melhor_vizinho(vetor,f_objetivo,total_pduplas,1);
         t = vc[sol.src_trip].remover_tarefa(sol.n_tarefa);
         vc[sol.dst_trip].adicionar_tarefa(t);

         tabu_list.push_back(sol);

         if(iteracoes >= n_iter)
         {
            this->list_size = list_size + (rand()%10);
            cout << "\n\n###Alterando o tamanho da lista tabu para: " << this->list_size << "\n###";
            time(&t2);
            tempo = t2 - t1;
            iteracoes = 0;
         }
         if(tabu_list.size() > this->list_size)
         {
            tabu_list.pop_front();
         }

         cout << "\n\nMovimento 1-optimal       **********";
         cout << "\n[" << sem_melhora << "]" << " Funcao Objetivo atual: " << f_objetivo;
         cout << "  Fonte: " << sol.src_trip << " Destino: " << sol.dst_trip;

         if(f_objetivo < this->melhor_fobjetivo)
         {
            this->melhor_solucao = vc;
            this->melhor_fobjetivo = f_objetivo;
            //melhor_iter=iter;
            sem_melhora=0;
            cout << "  Melhora Global.";
            /*  ppdupla = util.pduplas_total(vc);
            if(ppdupla <= 20)
            {
               pesos.p_duplas = 9000;
            }
            else {
               pesos.p_duplas = 13000;
            }
            */
            cout << "\nPDUPLAS: " << total_pduplas;
            // melhor_iter = iter;
         }
         else
         {
            ++sem_melhora;
         }
      } // if
      else if (tipo_movimento == 2)
      {
         f_objetivo = melhor_vizinho(vetor,f_objetivo,total_pduplas,2);
         task1 = vc[sol_2.trip1].remover_tarefa(sol_2.n_tarefa1);
         task2 = vc[sol_2.trip2].remover_tarefa(sol_2.n_tarefa2);
         vc[sol_2.trip1].adicionar_tarefa(task2);
         vc[sol_2.trip2].adicionar_tarefa(task1);

         tabu_list_2optimal.push_back(sol_2);

         if(iteracoes >= n_iter)
         {
            this->list_size = list_size + (rand()%10);
            cout << "\nAlterando o tamanho da lista tabu para: " << this->list_size;
            time(&t2);
            tempo = t2 - t1;
            iteracoes = 0;
         }
         if(tabu_list_2optimal.size() > this->list_size)
         {
            tabu_list_2optimal.pop_front();
         }

         cout << "\n\nMovimento 2-optimal       **********";
         cout << "\n[" << sem_melhora << "]" << " Funcao Objetivo atual: " << f_objetivo;
         cout << "  Tripulantes: " << sol_2.trip1 << " <-> " << sol_2.trip2;

         if(f_objetivo < this->melhor_fobjetivo)
         {
            this->melhor_solucao = vc;
            this->melhor_fobjetivo = f_objetivo;
            //melhor_iter=iter;
            sem_melhora=0;
            cout << "  Melhora Global.";
            /*  ppdupla = util.pduplas_total(vc);
            if(ppdupla <= 20)
            {
               pesos.p_duplas = 9000;
            }
            else {
               pesos.p_duplas = 13000;
            }
            */
            cout << "\nDUPLA: " << total_pduplas;
            // melhor_iter = iter;
         }
         else
         {
            ++sem_melhora;
         }
      } // if
      else if (tipo_movimento == 3)
      {
         f_objetivo = melhor_vizinho(vetor,f_objetivo,total_pduplas,3);

         // removendo as tarefas
         for (int cont = sol_link.n_tarefa1; cont < vc[sol_link.trip1].jornada.size(); ++cont)
            v_t1[cont - sol_link.n_tarefa1] = vc[sol_link.trip1].remover_tarefa(cont);
         for (int cont = sol_link.n_tarefa2; cont < vc[sol_link.trip2].jornada.size(); ++cont)
            v_t2[cont - sol_link.n_tarefa2] = vc[sol_link.trip2].remover_tarefa(cont);

         // adicionando as tarefas
         for (int cont = 0; cont < v_t1.size(); ++cont)
            vc[sol_link.trip1].adicionar_tarefa(v_t1[cont]);
         for (int cont = 0; cont < v_t2.size(); ++cont)
            vc[sol_link.trip1].adicionar_tarefa(v_t2[cont]);

         tabu_list_link.push_back(sol_link);

         if(iteracoes >= n_iter)
         {
            this->list_size = list_size + (rand()%10);
            cout << "\nAlterando o tamanho da lista tabu para: " << this->list_size;
            time(&t2);
            tempo = t2 - t1;
            iteracoes = 0;
         }
         if(tabu_list_link.size() > this->list_size)
         {
            tabu_list_link.pop_front();
         }

         cout << "\n\nMovimento Link            **********";
         cout << "\n[" << sem_melhora << "]" << " Funcao Objetivo atual: " << f_objetivo;
         cout << "  Tripulantes: " << sol_link.trip1 << " <-> " << sol_link.trip2;

         if(f_objetivo < this->melhor_fobjetivo)
         {
            this->melhor_solucao = vc;
            this->melhor_fobjetivo = f_objetivo;
            sem_melhora=0;
            cout << "  Melhora Global.";
            cout << "\nDUPLA: " << total_pduplas;
         }
         else
            ++sem_melhora;
      } // if
      if (tempo >= tempolimite && tipo_movimento < 3)
      {
         tipo_movimento++;
         tempo = 0;
      }
   }//while

     vc = this->melhor_solucao;
     cin.get();
}

//Retorna true caso a movimento passado  tabu.
bool TabuSearch::is_tabu(const solucao& sol)
{
    list<solucao>::iterator iter;

    for(iter = tabu_list.begin(); iter != tabu_list.end(); ++iter)
    {
        if(iter->src_trip == sol.dst_trip /*&& iter->dst_trip == sol.src_trip*/
             && iter->task == sol.task)

            return true;
    }

    return false;
}

bool TabuSearch::is_tabu(const solucao_2optimal& sol)
{
    list<solucao_2optimal>::iterator iter;

    for(iter = tabu_list_2optimal.begin(); iter != tabu_list_2optimal.end(); ++iter)
    {
        if((iter->trip1 == sol.trip1 || iter->trip1 == sol.trip2)&&
           (iter->trip2 == sol.trip1 || iter->trip2 == sol.trip2)&&
           (iter->task1 == sol.task1 || iter->task1 == sol.task2)&&
           (iter->task2 == sol.task1 || iter->task2 == sol.task2))

            return true;
    }

    return false;
}

bool TabuSearch::is_tabu(const solucao_link& sol)
{
    list<solucao_link>::iterator iter;

    for(iter = tabu_list_link.begin(); iter != tabu_list_link.end(); ++iter)
    {
        if((iter->trip1 == sol.trip1 || iter->trip1 == sol.trip2)&&
           (iter->trip2 == sol.trip1 || iter->trip2 == sol.trip2)&&
           (iter->task1 == sol.task1 || iter->task1 == sol.task2)&&
           (iter->task2 == sol.task1 || iter->task2 == sol.task2))

            return true;
    }

    return false;
}
//Calcula o melhor vizinho de um subonjunto dos tripulantes(vetor) e retorna o valor da funcao objetivo
//que esse movimento ira gerar.
//E passsado o vetor de tripulantes a qual a vizinhanca sera analisada, uma variavel do tipo solucao a qual sera
//passada o movimento do melhor vizinho e o valor da funcao objetivo da solucao corrente.
unsigned long int TabuSearch::melhor_vizinho(vector<Crew>& vetor, unsigned long int f_objetivo, int& pduplas, int tipo)
{
   int tamanho, tamanho2;
   unsigned long int movimento_atual,melhor_movimento,melhor_vizinho;
   solucao sol_aux;
   solucao_2optimal sol_aux_2optimal;
   solucao_link sol_aux_link;
   int pduplas_aux,pduplas_melhor;

   melhor_vizinho = 1000000000;
   //tamanho = 0;

   for(int i = 0; i < (int)vetor.size(); ++i)
   {
      for(int j = 0; j < (int)vetor.size(); ++j)
      {
         if(i != j)
         {
            tamanho = vetor[i].jornada.size();
            if(vetor[i].possui_artificial())
               --tamanho;
            if(tipo == 1)
            {
               for(int k = 0; k < tamanho/2; ++k)
               {
                  pduplas_aux = pduplas;
                  movimento_atual = this->movimento(vetor[i], vetor[j],k,f_objetivo,sol_aux.task,pduplas_aux);
                  sol_aux.src_trip = vetor[i].numero;
                  sol_aux.dst_trip = vetor[j].numero;

                  if(((movimento_atual < melhor_vizinho) && !this->is_tabu(sol_aux)) || (movimento_atual < this->melhor_fobjetivo))
                  {
                     melhor_vizinho = movimento_atual;
                     sol.n_tarefa = k;
                     sol.vi=i;
                     sol.vj=j;
                     sol.src_trip = vetor[sol.vi].numero;
                     sol.dst_trip = vetor[sol.vj].numero;
                     sol.task = sol_aux.task;
                     pduplas_melhor = pduplas_aux;
                  }
               }//for
            }
            else if(tipo == 2)
            {
               for(int k = 0; k < tamanho; ++k)
               {
                  tamanho2 =  vetor[j].jornada.size();
                  if(vetor[j].possui_artificial())
                     --tamanho2;
                  for(int cont = 0; cont < tamanho2/4; ++cont)
                  {
                     int l = (rand()%tamanho2);
                     if(l == tamanho2)
                        break;
                     pduplas_aux = pduplas;
                     movimento_atual = this->movimento_2optimal(vetor[i],vetor[j],k,l,f_objetivo,sol_aux_2optimal.task1,sol_aux_2optimal.task2,pduplas_aux);
                     sol_aux_2optimal.trip1 = vetor[i].numero;
                     sol_aux_2optimal.trip2 = vetor[j].numero;

                     if(((movimento_atual < melhor_vizinho) && !this->is_tabu(sol_aux_2optimal)) || (movimento_atual < this->melhor_fobjetivo))
                     {
                        melhor_vizinho = movimento_atual;
                        sol_2.n_tarefa1 = k;
                        sol_2.n_tarefa2 = l;
                        sol_2.vi=i;
                        sol_2.vj=j;
                        sol_2.trip1 = vetor[sol_2.vi].numero;
                        sol_2.trip2 = vetor[sol_2.vj].numero;
                        sol_2.task1 = sol_aux_2optimal.task1;
                        sol_2.task2 = sol_aux_2optimal.task2;
                        pduplas_melhor = pduplas_aux;
                     }//if
                  }//for
               }//for
            }//if
            else if(tipo == 3)
            {
               cout << "erro aki";
               for(int cont = 0; cont < tamanho; ++cont)
               {
                  int k = (rand()%tamanho);
                  int tamanho2 = vetor[j].jornada.size();
                  if(vetor[j].possui_artificial())
                     --tamanho2;
                  int l;
                  for(l = 0; l < tamanho2; ++l)
                  {
                     if(vetor[i].jornada.at(k).h_inicial >= vetor[i].jornada.at(l).h_inicial)
                        break;
                  }

                  pduplas_aux = pduplas;

                  movimento_atual = this->movimento_link(vetor[i],vetor[j],k,l,f_objetivo,sol_aux_link.task1,sol_aux_link.task2,pduplas_aux);

                  sol_aux_link.trip1 = vetor[i].numero;
                  sol_aux_link.trip2 = vetor[j].numero;

                  if(((movimento_atual < melhor_vizinho) && !this->is_tabu(sol_aux_link)) || (movimento_atual < this->melhor_fobjetivo))
                  {
                     melhor_vizinho = movimento_atual;
                     sol_link.n_tarefa1 = k;
                     sol_link.n_tarefa2 = l;
                     sol_link.vi = i;
                     sol_link.vj = j;
                     sol_link.trip1 = vetor[sol_2.vi].numero;
                     sol_link.trip2 = vetor[sol_2.vj].numero;
                     sol_link.task1 = sol_aux_link.task1;
                     sol_link.task2 = sol_aux_link.task2;
                     pduplas_melhor = pduplas_aux;
                  }
               }//for
            }//if            
         }//for
      }
   }
   pduplas = pduplas_melhor;
   return melhor_vizinho;
}

//Embaralha o vetor da vizinhanca a ser pesquisada.
void TabuSearch::randomize_vector(const vector<Crew>& vetor_principal, vector<Crew>& vetor_aux)
{
        int aux;

        srand((int)time(NULL));

        for(int i = 0; i < (int)vetor_aux.size(); ++i){
            aux = rand()%(vetor_principal.size()-1);
            vetor_aux[i] = vetor_principal[aux];
            vetor_aux[i].numero = aux;
        }

}
