/***************************************************************************
                          SA.h
--------------------------------------------------------------------------------------------------------------------
    begin                 : Sex  Abril 04 2003
    copyright             : (C) 2003 by Leonardo X. T. Cardoso
    email                 : leoxt@arbornet.org
 ***************************************************************************/

//---------------------------------------------------------------------------

#ifndef SAH
#define SAH
#include<iostream>
#include<vector>
#include<ctime>
#include<fstream>
#include<cassert>
#include<ctime>
#include "Crew.h"
#include "Pesos.h"
#include "CrewUtil.h"
using namespace std;
//---------------------------------------------------------------------------

class SA {

        public:
                SA();
                //void do_SA();
                /***************************************************************
                * Metodo: do_SA()
                * Objetivo: Inicia o metodo Simulated Annealing
                * Autor: Leonardo X. T. Cardoso
                * Data:04/04/03
                * Parametros:
                *       vc: Vetor de Trippulantes.
                *       alfa: razao de resfriamento.
                *       SAmax: Numero de iteracoes em uma mesma temperatura.
                *       T: Temperatura inicial.
                *       tmaxproc: tempo maximo de processamento em minutos.
                ***************************************************************/
                void do_SA(vector<Crew>& vc, double alfa, unsigned int SAmax,
                                 double T, int tmax_proc );

                
                /***************************************************************
                * Metodo: movimento()
                * Objetivo: Avalia um movimento de realocacao
                * Autor: Leonardo X. T. Cardoso
                * Data: 04/04/2003
                * Parametros:
                *       src_trip: tripulante fonte.
                *       dst_trip: tripulante destino.
                *       i: numero da tarefa
                *       objetivo: valor da funcao objetivo atual;
                *       npduplas: numero total de pegadas duplas atual;
                ***************************************************************/
                inline long int movimento(Crew src_trip,Crew dst_trip,
                                                   int i, const double objetivo,
                                                   const vector<Crew>& vc, int& npduplas);

        private:
                double alfa;
                unsigned int SAmax;
                double T;
                unsigned int IterT;
                long int melhor_fobjetivo;
                vector<Crew> melhor_solucao;
                CrewUtil util;

        private:
                /***************************************************************
                * Metodo: choose_random_trip()
                * Objetivo: Escolhe dois tripulantes aleatorios
                * Autor: Leonardo X. T. Cardoso
                * Data:04/04/03
                * Parametros:
                *       src_trip: tripulante fonte.
                *       dst_trip: tripulante destino.
                *       n_trip: numero de tripulantes.
                ****************************************************************/
                inline void choose_random_trip(unsigned int& src_trip,
                                                unsigned int& dst_trip, unsigned int n_trip);

                /***************************************************************
                * Metodo: choose_random_task()
                * Objetivo: Escolhe uma tarefa aleatoria de um tripulante
                * Autor: Leonardo X. T. Cardoso
                * Data: 04/04/2003
                * Parametros:
                *       vc: Tripulante de onde se deseja escolher uma tarefa.
                * Retorno da funcao:
                *       Uma tarefa escolhida aleatoriamente a partir de vc
                ****************************************************************/
                inline int choose_random_task(const Crew& vc);


                /***************************************************************
                * Metodo: randomico()
                * Objetivo: Gera numero aleatorio entre min e max.
                * Autor: Metodo retirado do trabalho de iniciacao cientifica de
                * Alexandre Martins.
                ***************************************************************/
                double randomico(double min, double max);






};


#endif
