//---------------------------------------------------------------------------

#pragma hdrstop

#include "SA.h"
SA::SA()
{
        alfa = 0.0;
        SAmax = 0;
        T = 0;
        IterT = 0;
        melhor_fobjetivo = 0.0;
}

void SA::do_SA(vector<Crew>& vc, double alfa,
                unsigned int SAmax, double T, int tmax_proc )
{
        CrewUtil util;
        Task t;
        int n_tarefa,total_pduplas,pduplas_aux;
        unsigned int  src_trip, dst_trip, n_tripulantes;
        long int f_objetivo, movimento_atual;
        long int delta;
        long double x,z;
        time_t tinicial,tcorrente,t1,t2; //hora de inicio do SA, hora corrente.

        this->melhor_solucao = vc; //melhor solucao obtida ate entao.
        this->melhor_fobjetivo = f_objetivo = util.f_objetivo_global(vc);
        this->IterT = 0; //numero de iteracoes na temperatura T.
        this->T = T; //temperatura corrente.
        this->SAmax = SAmax;
        total_pduplas = pduplas_aux = util.pduplas_total(vc);


        src_trip = dst_trip = n_tarefa = delta = 0;
        //movimento_atual = 0;
        n_tripulantes = vc.size();

        srand((int)time(NULL));
        time(&tinicial);
        while( (tcorrente-tinicial) < tmax_proc )
        {
        while( (this->T > 0.1 ) && ( (tcorrente-tinicial) < tmax_proc ) ) {

                cout << "\n***************************\n";
                cout << "Temperatura Atual: " << this->T;
                cout << "\n**************************";
                time(&t1);
                while( this->IterT < this->SAmax ) {
                        this->IterT++;
                        //gerar vizinho.
                        this->choose_random_trip( src_trip, dst_trip, n_tripulantes  );
                        n_tarefa = this->choose_random_task( vc[src_trip] );

                        if( n_tarefa == -1 ) //Se o tripulante fonte nao possui tarefa
                        {
                               // cout << "\nTRIPULACAO " << src_trip << " SEM TAREFA.\n";
                               continue;
                        }
                        pduplas_aux = total_pduplas;
                      /*
                        if(util.pduplas_total(vc) != total_pduplas)
                        {
                           cout << "OPPSSSS\n";
                           cin.get();
                        }
                       */

                        /*if(f_objetivo != util.f_objetivo_global(vc))
                        {
                           cout << "\nERRO FOBJETIVO!!\n";
                           //cout.setf(ios::fixed,ios::floatfield);
                           cout << this->IterT << " " << f_objetivo << " " << util.f_objetivo_global(vc) <<
                                  " "  << (f_objetivo-util.f_objetivo_global(vc)) ;
                           cin.get();
                        }*/


                        movimento_atual = movimento(vc[src_trip],vc[dst_trip],
                                                        n_tarefa, f_objetivo, vc,pduplas_aux);

                        delta = (movimento_atual - f_objetivo);

                        if( delta < 0 )
                        {

                                t = vc[src_trip].remover_tarefa(n_tarefa);
                                vc[dst_trip].adicionar_tarefa(t);
                                f_objetivo = movimento_atual;
                                total_pduplas = pduplas_aux;

                                if( movimento_atual < this->melhor_fobjetivo )
                                {
                                        this->melhor_solucao = vc;
                                        this->melhor_fobjetivo = movimento_atual;
                                }
                                //cin.get();
                        }
                        else
                        {
                                x = this->randomico( 0, 1 );
                               //x = random(INT_MAX);
                               //x = x/INT_MAX;
                               z = exp(-delta/this->T);
                                if (x < z){
                                     //   cout << "\nPiora " << this->IterT;
                                       t = vc[src_trip].remover_tarefa(n_tarefa);
                                       vc[dst_trip].adicionar_tarefa(t);
                                       f_objetivo = movimento_atual;
                                       total_pduplas = pduplas_aux;
                                }
                        }

                }//fim while
                time(&t2);
                this->T = alfa * this->T;
                this->IterT = 0;
                cout << "\nMELHOR_FOBJETIVO: " << this->melhor_fobjetivo << "\n";
                cout << "\nTempo para executar " << SAmax << " iteracoes: "
                        << t2-t1 << "segundos.\n";
                time(&tcorrente);
        } //fim while.
        this->T = T/2;
        T = T/2;
        vc = this->melhor_solucao;
        cout << "Reaquecendo: " << this->T;
        //cin.get();
        }

        vc = this->melhor_solucao;
        cout << "\nFim SA.";
        cout << "\nSolucao encontrada: " << this->melhor_fobjetivo << "\n";
       // cout << "\nValor de vc: " << util.f_objetivo_global(vc) << "\n"
           //     << "Valor da variavel local: " << util.f_objetivo_global(this->melhor_solucao)
          //      << endl;
       // util.dump_file3(this->melhor_solucao, "melhor_solucao_SA.txt");
       // cin.get();
}
//---------------------------------------------------------------------------

int SA::choose_random_task(const Crew& vc)
{
        int t_jornada = 0;
        t_jornada = vc.jornada.size();

        if(t_jornada == 0) // TRIPULACAO SEM TAREFA;
        {
               return -1;
        }
        else if( t_jornada == 1 )
        {
                return 0;
        }
        else
        {       if(vc.possui_artificial())
                {
                        return (rand()%(t_jornada-1));
                }
                else
                {
                        return (rand()%(t_jornada));
                }
        }
}

//---------------------------------------------------------------------------
void SA::choose_random_trip(unsigned int &src_trip,
                                unsigned int &dst_trip, unsigned int n_trip)
{
        src_trip = (rand()%n_trip);

        do{
           dst_trip = (rand()%n_trip);
        }while (src_trip == dst_trip);

}

//------------------------------------------------------------------------------------------

long int SA::movimento(Crew src_trip, Crew dst_trip, int i,
                                const double objetivo, const vector<Crew>& vc,int& npduplas)
{

    long int old_src_trip, //Valor antigo da funcao objetivo do tripulante onde a tarefa sera retirada.
           new_src_trip, //Novo valor da funcao objetivo de onde a tarefa sera retirada.
           old_dst_trip, //valor antigo da funcao objetivo de onde a tarefa sera inserida.
           new_dst_trip; //Novo valor da funcao objetivo de onde a tarefa sera inserida.
    int    old_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera retirada.
           old_dst_pdupla, // Novo valor da pegada dupla do tripulante onde a tarefa sera retirada.
           new_src_pdupla,  //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.
           new_dst_pdupla;   //Valor antigo da pegada dupla do tripulante onde a tarefa sera inserida.

    long int new_value_pdupla,old_value_pdupla,
             old_tarefa,old_tarefa_src,
             new_tarefa,new_tarefa_src;
    Task t;

    old_src_pdupla = src_trip.p_duplas();
    old_dst_pdupla = dst_trip.p_duplas();
    old_src_trip = src_trip.f_objetivoN();
    old_dst_trip = dst_trip.f_objetivoN();

    if (dst_trip.jornada.size() != 0)
     {
        old_tarefa = pesos.num_trip;
     }
     else
     {
        old_tarefa = 0;
     }

     old_tarefa_src = pesos.num_trip;


    old_value_pdupla = pesos.get_pdupla(npduplas);

     t = src_trip.remover_tarefa(i);
    //task = t;
    dst_trip.adicionar_tarefa(t);

    if(src_trip.jornada.size() == 0)
    {
        new_tarefa_src = 0;
    }
    else
    {
        new_tarefa_src = pesos.num_trip;
    }

    new_tarefa = pesos.num_trip;

    new_src_pdupla = src_trip.p_duplas();
    new_dst_pdupla = dst_trip.p_duplas();
    new_src_trip = src_trip.f_objetivoN();
    new_dst_trip = dst_trip.f_objetivoN();

    npduplas = npduplas - old_src_pdupla - old_dst_pdupla
                  + new_src_pdupla + new_dst_pdupla;

    new_value_pdupla = pesos.get_pdupla(npduplas);

    return  (objetivo - old_src_trip - old_dst_trip + new_src_trip + new_dst_trip
          - old_value_pdupla - old_tarefa - old_tarefa_src  + new_value_pdupla
          + new_tarefa + new_tarefa_src);
}

//---------------------------------------------------------------------------

double SA::randomico(double min, double max)
{
        if (min == max) return min;
        return ((double) (rand()%10000/10000.0)*(max-min) + min);
}

//---------------------------------------------------------------------------
#pragma package(smart_init)


