/***************************************************************************
                         					 Pesos.h
-------------------------------------------------------------------------------------------------------------------
    begin                : Fri Aug 2 2002
    copyright          : (C) 2002 by Leonardo X. T. Cardoso
    email                : leoxt@arbornet.org
 ***************************************************************************/

#ifndef PESOS_H
#define PESOS_H

//Limites para horas extras
const int HEXTRA_N1 = 30;
const int HEXTRA_N2 = 60;
const int HEXTRA_N3 = 90;
const int HEXTRA_N4 = 120;

//Limites para tempo ocioso
const int TOCIOSO_N1 = 30;
const int TOCIOSO_N2 = 60;
const int TOCIOSO_N3 = 90;
const int TOCIOSO_N4 = 120;

//Limite para pegada dupla
const int PDUPLAS_MAX = 20;

//Limites para trocas de ponto e linha
const int TROCAS_N1  = 1;
const int TROCAS_N2  = 2;
const int TROCAS_N3  = 3;

//Penalizaes
//Penalizao mxima
const double P_MAX = 1000.00;

//Penalizaoes para tempo ocioso
const double P_TOCIOSO_MAX = P_MAX/2.0;

//Penalizaoes para trocas de ponto e linha
const double P_TROCAS_MAX  = P_MAX/2.0;

//Penalizacao para duracao da jornada ( > 9:10).
const double P_DJORNADA = P_MAX;

//Penalizacao para tempo de sobreposicao
const double P_TSOBREPOSICAO = P_MAX;

//Penalizacao para falta de tempo entre jornada
const double P_FTEJORNADA = P_MAX;


class Pesos{
   public:
      Pesos();
      //Pesos( unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned );
       void r_padrao();
       void set_pesos( unsigned, unsigned, unsigned, unsigned, unsigned, unsigned,
                                 unsigned, unsigned, unsigned, unsigned, unsigned );
       unsigned p_duplas;
       unsigned np_duplas;
       unsigned h_extra;
       unsigned i_jornada;
       unsigned f_acumulada;
       unsigned d_jornada; //excesso de trabalho > 9:10
       unsigned t_ocioso;
       unsigned t_sobreposicao;
       unsigned tp_proibida;
       unsigned tp_permitida; //??
       unsigned tl_proibida;
       unsigned tl_permitida;
       unsigned t_veiculo;
       unsigned num_trip;

   public:
      long int get_pdupla(int);
      double get_hextra(int);
      double get_tocioso(int);
      double get_tpermitida(int);
};

extern Pesos pesos;

#endif
