/***************************************************************************
                          			Pesos.cpp
-------------------------------------------------------------------------------------------------------------------------
    begin                : Fri Aug 2 2002
    copyright          : (C) 2002 by Leonardo X. T. Cardoso
    email                : leoxt@arbornet.org
 ***************************************************************************/

#include "Pesos.h"

//Pesos pesos;

Pesos::Pesos()
{
  this->r_padrao();
}

void Pesos::r_padrao()
{
  this->p_duplas  = 13000;
  this->np_duplas = 13000; //excesso de tripulantes com pegada dupla.
  this->h_extra   = 60;
  this->i_jornada = 5000;
  this->f_acumulada = 0;
  this->d_jornada   = 5000; //excesso de trabalho > 9:10
  this->t_ocioso    = 40;
  this->t_sobreposicao  = 5000;
  this->tp_proibida = 13000;
  this->tp_permitida = 300; // ??
  this->t_veiculo = 5000;
  this->tl_proibida = 13000;
  this->tl_permitida = 300;
  this->num_trip = 1000;
}

void Pesos::set_pesos( unsigned p_duplas, unsigned h_extra, unsigned i_jornada,
                       unsigned f_acumulada,unsigned d_jornada, unsigned t_ocioso,
                       unsigned t_sobreposicao, unsigned tp_proibida, unsigned tp_permitida,
                       unsigned t_veiculo, unsigned num_trip)
{

  this->p_duplas  = p_duplas;
  this->np_duplas = np_duplas;
  this->h_extra   = h_extra;
  this->i_jornada = i_jornada;
  this->f_acumulada = f_acumulada;
  this->d_jornada   = d_jornada;
  this->t_ocioso    = t_ocioso;
  this->t_sobreposicao  = t_sobreposicao ;
  this->tp_proibida  = tp_proibida;
  this->tp_permitida = tp_permitida;
  this->t_veiculo = t_veiculo;
  this->num_trip = num_trip;
}

long int Pesos::get_pdupla(int n)
{
   if( n > PDUPLAS_MAX )
   {
      return 13000*(n - PDUPLAS_MAX);
   }
   else
   {
      return 0;
   }
}

double Pesos::get_hextra(int n)
{

   if( n < HEXTRA_N1 ) //Nivel 1
   {
      return (double)(8.3*n);
   }
   else if ( n < HEXTRA_N2 ) //Nivel 2
   {
      return (double)(180*n+6780)/30;
   }
   else if ( n < HEXTRA_N3 ) //Nivel 3
   {
      return (double)(240*n+3600)/30;
   }
   else if ( n < HEXTRA_N4 ) //Nivel 4
   {
      return (double)(160*n+10800)/30;
   }
   else
   {
      return P_MAX;
   }
}

double Pesos::get_tocioso(int n)
{

   if( n < TOCIOSO_N1 ) //Nivel 1
   {
      return (double)(120*n)/29;
   }
   else if ( n < TOCIOSO_N2 ) //Nivel 2
   {
      return (double)(3*n+120);
   }
   else if ( n < TOCIOSO_N3 ) //Nivel 3
   {
      return (double)(4*n+60);
   }
   else if ( n < TOCIOSO_N4 ) //Nivel 4
   {
      return (double)(4.6*n);
   }
   else
   {
      return P_TOCIOSO_MAX;
   }
}

double Pesos::get_tpermitida(int n)
{
   if( n < TROCAS_N1 )
   {
      return 0.0;
   }
   else if( n < TROCAS_N2 )
   {
      return 60.0;
   }
   else if( n < TROCAS_N3 )
   {
      return 240.0;
   }
   else
   {
      return P_TROCAS_MAX;
   }

}

