//---------------------------------------------------------------------------
#include "Linha.h"
/* As linhas e seus respectivos grupos */
Linha::Linha()
{
	n_linha = 0;
	n_grupo = 0;
}

Linha::Linha(int n_linha, int n_grupo)
{
	this->n_linha = n_linha;
	this->n_grupo = n_grupo;
}


ostream& operator<<(ostream& output, const Linha& linha)
{
	output << "\nLinha: " << linha.n_linha
		<< "\nGrupo: "<< linha.n_grupo;
	return output;
}

Linha& Linha::operator=(const Linha& src)
{
	n_linha   = src.n_linha;
	n_grupo   = src.n_grupo;

	return *this;
}

bool Linha::operator<(const Linha& linha)
{
	return (n_linha < linha.n_linha) ? true : false;
}

bool Linha::operator>(const Linha& linha)
{
	return (n_linha > linha.n_linha) ? true : false;
}

bool Linha::operator==(const Linha& linha)
{
  return   n_linha == linha.n_linha &&
           n_grupo == linha.n_grupo;
}

bool Linha::operator!=(const Linha& linha)
{
  return   n_linha == linha.n_linha ||
           n_grupo == linha.n_grupo;
}

//---------------------------------------------------------------------------

