
/***************************************************************************
                          Grasp.cpp  -  description
                             -------------------
    begin                : Fri Aug 9 2002
    copyright            : (C) 2002 by leoxt
    email                : leoxt@arbornet.org
 ***************************************************************************/
#include "Grasp.h"


bool high_task(Task& t1, Task& t2)
{
      return t1.duracao( ) > t2.duracao( );
}


bool less_sol(Solucao& sol1, Solucao& sol2)
{
      return sol1.objetivo < sol2.objetivo;
}

Task Grasp::get_task(l_tarefas &l, int pos)
{
	Task task;
	l_iterator iter;
	int i = 0;

	for(iter = l.begin(); i < pos; ++iter)
		++i;

	task = *iter;
	l.erase(iter);

	return task;
}

Solucao Grasp::get_sol(l_solucao &l, int pos)
{
	Solucao sol;
	s_iterator iter;
	int i = 0;

	for(iter = l.begin(); i < pos; ++iter)
		++i;

 	sol = *iter;
 	l.erase(iter);

 	return sol;
}

void Grasp::remove_task(l_tarefas& l, const Task& task)
{
        l_iterator iter;

        for(iter = l.begin(); iter != l.end(); ++iter ){
                if ( *iter == task ){
                        l.erase(iter);
                        return;
                }
        }
}


void Grasp::do_grasp(l_tarefas& l, vector<Crew>& v, double alfa, double beta)
{
	int n_task,n_sol,random;
	l_solucao sol;
	Solucao p_sol;
	double d_alfa,d_beta;
	Task task;

	d_alfa = alfa/100;
	d_beta = beta/100;

	//l.sort(high_task);
        sort(l.begin(),l.end(),high_task);

	srand((int)time(NULL));

    while(!l.empty())
    {

	   n_task = max(1, (int)(l.size() * d_beta)); // calcula d_beta% de l.size().
	   random = (rand()%n_task);  // obtem qual tarefa ele devera pegar.
           task = get_task(l, random );  //retorna a tarefa, retirando-a da lista.

	   for(int i  = 0; i < (int)v.size(); ++i) //testa para todos os tripulantes
	   {
	  	   v[i].adicionar_tarefa(task);
                   //v[i].ordena_jornada();
	  	   p_sol.numero = i;
	  	   p_sol.objetivo = v[i].f_objetivoN();
	  	   sol.push_back(p_sol);
                        // this->remove_task(v[i].jornada, task);
	  	   v[i].remover_tarefa(task);
           }

	   sol.sort(less_sol);
          n_sol = (int)sol.size() * d_alfa;
          random = (rand()%n_sol);

	   p_sol = get_sol(sol, random);
      v[p_sol.numero].adicionar_tarefa(task);
      sol.clear();
      if((l.size()%10) == 0)
          cout << ".";
    }
}

/*void Grasp::alocacao_empresa(l_tarefas& l, vector<Crew>& v)
{
    //No estamos considerando nibus com mais de uma pegada dupla
    int duracao,n_task,n_veiculo,n_veiculo_anterior,j,cont,cont1,tempo,hora_inicial_veiculo,hora_final_veiculo,aux,pegada,pegada1;
    l_solucao sol;
    Solucao p_sol;
    Task task,ultima_task, task_anterior,task_posterior,task2;
    double media,media1,media2;
    bool procura, primeiro,unica,soma,umapd;

    primeiro=true;//primeira tarefa a ser retirada  a zero
    cont=0;
    cont1=0;
    j=0; //contador para tripulante
    n_task = l.size(); // tamanho da lista de tarefas (733 tarefas)
    n_veiculo_anterior=1;

    for(int i = 0 ; i <  n_task; i++) //i nmero de veculos
    {
        //cout << "Iniciando para tripulante:" << j <<  "\n";
        cont=0;
        aux=0;
        procura = true;
        while(procura)
        {
                task = dados_task(l,aux);//tarefas lidas na lista
                n_veiculo = task.n_veiculo;
                if (n_veiculo_anterior==n_veiculo)
                {
                        cont++;
                         if (primeiro==true)
                         {
                                 cont=cont-1;
                                 primeiro=false;
                         }
                         i++; // primeira tarefa  a zero
                }
                else
                {
                        procura = false;
                        n_veiculo_anterior=n_veiculo;
                        i++;
                }
            //cout << "Numero do veiculo: " << n_veiculo << "\n";
            //cout << "Numero do veiculo anterior: " << n_veiculo_anterior << "\n";
            //cout << "Cont: " << cont << "\n";
            //cin.get();
            aux++;
        } //while

        i=i-2;
        //verificando se existe pegada dupla
        pegada=0;
        for(int cont1 = 0; cont1 < cont; ++cont1)
        {
            task_anterior = dados_task(l,cont1); //como as tarefas sao retiradas da lista a proxima a ser retirada sempre estar na posicao 0
            task_posterior= dados_task(l,(cont1+1));
            //cout << " task anterior final " << task_anterior.h_final  << "\n";
            //cout << " task posterior inicial " << task_posterior.h_inicial  << "\n";
            if(( task_posterior.h_inicial - task_anterior.h_final ) >=120)
                pegada++;
             //cout << "\nContagem Pegada dupla/ tripla: " << pegada ;
             //cin.get();
        }

        task = dados_task(l,0);//dados da primeira tarefa do veiculo
        hora_inicial_veiculo = task.h_inicial ;
        task = dados_task(l,cont);//dados da ultima tarefa do veiculo
        hora_final_veiculo = task.h_final ;
        tempo =  hora_final_veiculo - hora_inicial_veiculo;
        //cout << "\nDuracao da jornada = "<<tempo;
        //cin.get();

        // dividindo a jornada simples
        if(pegada==0)
        {
          if(tempo<=1100) //para 2 tripulantes (09:10 + 09:10)
          {
            media = ((tempo)/2) + hora_inicial_veiculo;
            //task = dados_task(l,cont);//dados da ultima tarefa do veiculo
            //cout << " hora inicio veiculo: " << hora_inicial_veiculo  << "\n";
            //cout << " hora final veiculo: " << hora_final_veiculo  << "\n";
            //cout << "Media: " << media << "\n";
            //cout << " ATRIBUIO DE TAREFAS PARA 2 TRIPULANTES (PS)"  << "\n";
            //cin.get();
            for(cont1 = 0; cont1 <= cont; ++cont1)
            {
                task = get_task(l,0); //como as tarefas sao retiradas da lista a proxima a ser retirada sempre estar na posicao 0
                if( media > task.h_inicial)
                {
                     v[j].adicionar_tarefa(task);
                     p_sol.numero = j;
                     p_sol.objetivo = v[j].f_objetivoN();
                     //cout << "\n\nTripulante " << j << "\n";
                     //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                     //cin.get();
                }
                else
                {
                     v[j+1].adicionar_tarefa(task);
                     p_sol.numero = j+1;
                     p_sol.objetivo = v[j+1].f_objetivoN();
                     //cout << "\n\nTripulante " << j+1 << "\n";
                     //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                     //cin.get();
                }
            }//for
           j++;
           j++;//para ir para o proximo
           primeiro=true;//primeira tarefa a ser retirada  a zero
          }//if(tempo<=1100))

          else if(tempo > 1100)//para 3 tripulantes
          {
             media1 = ((tempo)/3) + hora_inicial_veiculo;
             unica=true;

             //cout << " ATRIBUICAO DE TAREFAS PARA 3 TRIPULANTES (PS)"  << "\n";   //???
             //cout << " Hora inicio veiculo: " << hora_inicial_veiculo  << "\n";
             //cout << " Hora final veiculo: " << hora_final_veiculo  << "\n";
             //cout << " Media 1: " << media1 << "\n";
             //cin.get();
             for(cont1 = 0; cont1 <= cont; ++cont1)
             {
                task = get_task(l,0); //como as tarefas sao retiradas da lista a proxima a ser retirada sempre estar na posicao 0
                if( media1 > task.h_inicial)
                {
                     v[j].adicionar_tarefa(task);
                     p_sol.numero = j;
                     p_sol.objetivo = v[j].f_objetivoN();
                     //cout << "\n\nTripulante " << j << "\n";
                     //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                     //cin.get();
                }
                else if( media1 <= task.h_inicial)
                {
                     if (unica)
                     {
                        int hora_inicial_veiculo2 = task.h_inicial ;
                        tempo =  hora_final_veiculo - hora_inicial_veiculo2;
                        media2 = ((tempo)/2) + hora_inicial_veiculo2;
                        unica=false;
                        //cout << " Hora inicio veiculo 2: " << hora_inicial_veiculo2  << "\n";
                        //cout << " Hora final veiculo 2: " << hora_final_veiculo  << "\n";
                        //cout << " Media 2: " << media2 << "\n";
                        //cin.get();
                     }
                     if( media2 > task.h_inicial)
                     {
                          v[j+1].adicionar_tarefa(task);
                          p_sol.numero = j+1;
                          p_sol.objetivo = v[j+1].f_objetivoN();
                          //cout << "\n\nTripulante " << j+1 << "\n";
                          //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                          //cin.get();
                     }
                     else
                     {
                          v[j+2].adicionar_tarefa(task);
                          p_sol.numero = j+2;
                          p_sol.objetivo = v[j+2].f_objetivoN();
                          //cout << "\n\nTripulante " << j+2 << "\n";
                          //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                          //cin.get();
                     }
                }//else
             }//for
             j+=3;
             primeiro=true;//primeira tarefa a ser retirada  a zero
             unica=true;
          }//else
        }//if(pegada==0)

        else if(pegada!=0)//se for pegada dupla
        {
            //cout << " ATRIBUICAO DE TAREFAS PARA TRIPULANTE (PD)"  << "\n";
            soma=false;
            duracao = 0;
            if (pegada==1)
            {
              //cout << " VEICULO COM UMA P.D.)"  << "\n";
              //cin.get();
              for(cont1 = 0; cont1 <= cont; ++cont1)
              {
                task = get_task(l,0);
                if (duracao<=520)//equivalente a 08:40
                {
                  v[j].adicionar_tarefa(task);
                  p_sol.numero = j;
                  p_sol.objetivo = v[j].f_objetivoN();
                  duracao = v[j].d_jornada();
                  //cout << "\n\nTripulante " << j << "\n";
                  //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                  //cin.get();
                }
                else
                {
                  soma=true;
                  v[j+1].adicionar_tarefa(task);
                  p_sol.numero = j+1;
                  p_sol.objetivo = v[j+1].f_objetivoN();
                  //cout << "\n\nTripulante " << j+1 << "\n";
                  //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                  //cin.get();
                }
              }//for
              primeiro=true;
              j++;
              if (soma)
                 j++;
            } //if (pegada ==1)

            else if (pegada==2)
            {
              //cout << " VEICULO COM UMA P.TRIPLA.)"  << "\n";
              umapd=true;
              pegada1=0;
              for(cont1 = 0; cont1 <= cont; ++cont1)
              {
                task_anterior = dados_task(l,cont1); //como as tarefas sao retiradas da lista a proxima a ser retirada sempre estar na posicao 0
                task_posterior= dados_task(l,(cont1+1));
                //cout << " task anterior final " << task_anterior.h_final  << "\n";
                //cout << " task posterior inicial " << task_posterior.h_inicial  << "\n";
                if(( task_posterior.h_inicial - task_anterior.h_final ) >= 120)
                        pegada1++;
                if (pegada1 > 1)
                        umapd=false;
                task = get_task(l,0);
                if ((duracao<=520) && (umapd))// 520 -> equivalente a 08:40
                {
                  v[j].adicionar_tarefa(task);
                  p_sol.numero = j;
                  p_sol.objetivo = v[j].f_objetivoN();
                  duracao = v[j].d_jornada();
                  //cout << "\n\nTripulante " << j << "\n";
                  //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                  //cin.get();
                }
                else
                {
                  v[j+1].adicionar_tarefa(task);
                  p_sol.numero = j+1;
                  p_sol.objetivo = v[j+1].f_objetivoN();
                  //cout << "\n\nTripulante " << j+1 << "\n";
                  //cout << "inicio da ultima tarefa que foi atribuida: " << task.h_inicial << "\n";
                  //cin.get();
                }
              }//for
              primeiro=true;
              j++;
              j++;
            }//else if (pegada==2)
        }//else if(pegada!=0)
    }//for final
}
*/

Task Grasp::dados_task(l_tarefas &l, int pos)
{
	Task task;
	l_iterator iter;
	int i = 0;

	for(iter = l.begin(); i < pos; ++iter)
		++i;

	task = *iter;
        return task;
}
