#include "CrewUtil.h"

int CrewUtil::pduplas_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        if(vc[i].p_duplas())
        {
            ++total;
        }
    }

    return total;
}

int CrewUtil::et_jornada_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].et_jornada();
    }

    return total;
}

int CrewUtil::np_duplas(vector<Crew>& vc)
{
  int total = 0;

  for(int i = 0; i < (int)vc.size(); ++i){
    if(vc[i].p_duplas())
        ++total;
  }

  if(total <= NP_DUPLASMAX)
  {
    return 0;
  }
  else
  {
    return total - NP_DUPLASMAX;
  }
}


int CrewUtil::tveiculos_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].t_veiculo();
    }

    return total;
}

int CrewUtil::hextra_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].h_extra();
    }

    return total;
}

int CrewUtil::t_sobreposicao_total(const vector<Crew>& vc)
{
    int total = 0;

    for(int i = 0; i < (int)vc.size() ; ++i){
        total = total + vc[i].t_sobreposicao();
    }

    return total;
}

void CrewUtil::ordena_vetor_trip(vector<Crew>& vc)
{

    for(int i = 0; i < (int)vc.size(); ++i){
            sort(vc[i].jornada.begin(),vc[i].jornada.end(),less_task);
    }
}

long int CrewUtil::f_objetivo_global(vector<Crew>& vc)
{
    long int s_global = 0;


    for(int i = 0; i < (int)vc.size(); ++i){
        s_global = s_global + vc[i].f_objetivoN();
    }

    s_global = s_global + pesos.np_duplas*np_duplas(vc) +
                        pesos.num_trip*ncom_tarefas(vc);

    return s_global;
}
/*double CrewUtil::f_objetivo_global(vector<Crew>& vc)
{
    double s_global = 0.0;


    for(int i = 0; i < (int)vc.size(); ++i){
        s_global = s_global + vc[i].f_objetivoN();
    }

    s_global = s_global + pesos.get_pdupla(pduplas_total(vc));

    return s_global;
}*/



int CrewUtil::nsem_tarefas(vector<Crew>& vc)
{
    int n = 0;

    for(int i = 0; i < (int)vc.size(); ++i){
        if (vc[i].jornada.size()==0)
            n++;
    }
    return n;
}

int CrewUtil::ncom_tarefas(vector<Crew>& vc)
{
    int n = 0;

    for(int i = 0; i < (int)vc.size(); ++i){
        if (vc[i].jornada.size()!=0)
            n++;
    }
    return n;
}

int CrewUtil::tp_permitida_total(vector<Crew>& vc)
{
    int n = 0;

    for(int i = 0; i < (int)vc.size(); ++i){
        n = n + vc[i].tp_permitida();
    }

    return n;
}

int CrewUtil::tp_proibida_total(vector<Crew>& vc)
{
    int n = 0;

    for(int i = 0; i < (int)vc.size(); ++i){
        n = n + vc[i].tp_proibida();
    }

    return n;
}


void CrewUtil::dump_file2( vector<Crew>& v, char* filename)
{
    cl_iterator iter;
    ofstream out_file( filename, ios::out | ios::trunc);
    int n_tarefa;

    assert(out_file);

     out_file << "\t\tPesos usados nessa solucao:\n"
             << "p_duplas: " << pesos.p_duplas
             << "\np_duplas: " << pesos.np_duplas
             << "\nh_extra: " << pesos.h_extra
             << "\ni_jornada: " << pesos.i_jornada
             << "\nf_acumulada: " << pesos.f_acumulada
             << "\nd_jornada: " << pesos.d_jornada
             << "\nt_ocioso: " << pesos.t_ocioso
             << "\nt_sobreposicao: " << pesos.t_sobreposicao
             << "\ntp_proibida: " << pesos.tp_proibida
             << "\ntp_permitida: " << pesos.tp_permitida
             << "\nt_veiculo " << pesos.t_veiculo;

    out_file << "\n\n\t\tProgramacao dos Tripulantes.\n";
    out_file << "A solucao abaixo possui funo objetivo global = " << f_objetivo_global(v) << "\n"
             << "\nSobreposicao Total: " << this->t_sobreposicao_total(v)
             << "\nHoras Extras: " << this->hextra_total(v)
             << "\nHoras Excedentes: " << this->et_jornada_total(v)
             << "\nTripulantes sem Tarefas: " << this->nsem_tarefas(v)
             << "\nPegadas duplas: " << this->pduplas_total(v)
             << "\nTrocas de Veiculos: " << this->tveiculos_total(v)
             << "\nTripulantes com pegada dupla: " << this->pduplas_total(v)
             << "\nTrocas de ponto permitida: " << this->tp_permitida_total(v)
             << "\nTrocas de ponto proibida: " << this->tp_proibida_total(v) << "\n";

    out_file << "____________________________________________________________________________________________________________________________\n";

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "\n\n========================================================================================================\n";
        out_file << "\n\t\t\tTripulao " << i << "\n";
        //out_file << "Funcao objetivo do tripulante: " << v[i].f_objetivo() << "\n";
        out_file << "============================================================================================================\n";
        out_file << "\t\t\tN_Vei\t\tH_Inic\tH_Fin\t\tP_Ini\t\tP_Fina\tF_Acum\tL_Ini\t\tL_Fina\n";
        out_file << "_____________________________________________________________________________________________________________\n";
        n_tarefa=0;
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter){
            out_file << "Tarefa " << n_tarefa << "\t\t" << iter->n_veiculo << "\t\t"
                      << iter->h_inicial << "\t\t" << iter->h_final << "\t\t"
                      << iter->p_inicial << "\t\t" << iter->p_final << "\t\t"
                      << iter->f_acumulada << "\t\t" << iter->l_inicial << "\t\t" << iter->l_final;

            if(iter->artificial){
                out_file << "**\n";
            }
            else
                out_file << "\n";

             out_file << "_____________________________________________________________________________________________________________\n";
             ++n_tarefa;
        }
        out_file << "Tempo total de trabalho (minutos): " << v[i].d_jornada() << endl;
        out_file << "Tempo ocioso (minutos): " << v[i].t_ocioso() << endl;
        out_file << "Hora Extra (minutos): " << v[i].h_extra() << endl;

        if(v[i].p_duplas())
        {
                out_file << "Tripulante com pegada dupla. " << endl;
        }

    }

    out_file.close();
}

void CrewUtil::dump_file(vector<Crew>& v, char* filename)
{
    cl_iterator iter;
    ofstream out_file( filename, ios::out | ios::trunc);

    assert(out_file);

    out_file << "\t\tPesos usados nessa solucao:\n"
             << "p_duplas: " << pesos.p_duplas
             << "\np_duplas: " << pesos.np_duplas
             << "\nh_extra: " << pesos.h_extra
             << "\ni_jornada: " << pesos.i_jornada
             << "\nf_acumulada: " << pesos.f_acumulada
             << "\nd_jornada: " << pesos.d_jornada
             << "\nt_ocioso: " << pesos.t_ocioso
             << "\nt_sobreposicao: " << pesos.t_sobreposicao
             << "\ntp_proibida: " << pesos.tp_proibida
             << "\ntp_permitida: " << pesos.tp_permitida
             << "\nt_veiculo " << pesos.t_veiculo;




    out_file << "\t\tProgramacao dos Tripulantes.\n";
    out_file << "A solucao abaixo possui funo objetivo global = " << f_objetivo_global(v) << "\n"
             << "\nSobreposicao Total: " << this->t_sobreposicao_total(v)
             << "\nHoras Extras: " << this->hextra_total(v)
             << "\nTripulantes sem Tarefas: " << this->nsem_tarefas(v)
             << "\nPegadas duplas: " << this->pduplas_total(v)
             << "\nTrocas de Veiculos: " << this->tveiculos_total(v) << "\n";
    out_file << "_________________________________________________________________________\n";

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "\n_________________________________________________________\n";
        out_file << "\n\t\tTarefas do Tripulante " << i << "\n";
        //out_file << "Funcao objetivo do tripulante: " << v[i].f_objetivo() << "\n";
        out_file << "_________________________________________________________\n";
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter)
            out_file << *iter;
        }

    out_file.close();
}

void CrewUtil::init_vector_crew(vector<Crew>& vc)
{
        for(int i = 0; i < (int)vc.size(); i++)
                vc[i].numero = i;
}

/*void CrewUtil::write_vector_crew(const vector<Crew>& vc, char* filename)
{
        vector<CrewFile> vector_crew;
        vector<Task>::const_iterator iter;
        int n_tarefas = 0;
        int tamanho = 0;

        ofstream arquivo(filename, ios::binary);

        assert(arquivo);

        vector_crew.resize(vc.size());

         for(int i = 0; i < (int)vc.size(); ++i){
                vector_crew[i].numero = i;
                for(iter = vc[i].jornada.begin();
                                iter != vc[i].jornada.end(); ++iter)
                {
                        n_tarefas++;
                        vector_crew[i].vector_tasks.push_back(*iter);
                 }
        }

         for(int i = 0; i < (int)vector_crew.size(); ++i){
                cout << "Tamanho: " << vector_crew[i].vector_tasks.size();
                 //cout <<  vector_crew[i].vector_tasks[0];
        }

        //cout << "Tamanho: " << sizeof(vector_crew) + n_tarefas*sizeof(Task);

        tamanho = sizeof(vector_crew) + n_tarefas*sizeof(Task) + sizeof(vector<Task>);
        cout << "Tamanho: " << tamanho;

        cin.get();
        for(int i = 0; i < (int)vector_crew.size(); ++i){
                 arquivo.write((char*)(&vector_crew[i].vector_tasks), 25*36+sizeof(vector<Crew>));//(vector_crew[i].vector_tasks.size()*sizeof(Task)));

        }

       // arquivo.write((char*)(&vector_crew), 20000);
         arquivo.flush();

        arquivo.close();
}
*/
/*
 void CrewUtil::read_vector_crew(vector<Crew>& vc, char* filename)
 {
        vector<CrewFile> vector_crew;
        vector<Task>::iterator iter;
        Task teste;

        ifstream arquivo(filename, ios::binary);

        assert(arquivo);
        vector_crew.resize(vc.size());

       for(int i = 0; i < (int)vector_crew.size(); ++i){
          //       vector_crew[i].vector_tasks.resize(10,teste);
                //cout << "Tamanho: " << vector_crew[i].vector_tasks.size();
              //vector_crew[i].vector_tasks.resize(9,teste);
              arquivo.read((char*)&vector_crew[i].vector_tasks,25*36+sizeof(vector<Crew>));//sizeof(vector_crew[i].vector_tasks)+32);
        }

        for(int i = 0; i < (int)vector_crew.size(); ++i){
                cout << "Tamanho: " << vector_crew[i].vector_tasks.size();
        }

       // cin.get();
        for(int i = 0; i < (int)vector_crew.size(); ++i){
                vc[i].jornada.clear();
                cin.get();
               /* for(int j = 0; j < (int)vector_crew[i].vector_tasks.size();++i)
                {
                        cout <<  vector_crew[i].vector_tasks[j];
                        //vc[i].jornada.push_back(vector_crew[i].vector_tasks[j]);
                } */
  /*              for(iter = vector_crew[i].vector_tasks.begin();
                        iter != vector_crew[i].vector_tasks.end(); ++iter)
                {
                        cout <<  vector_crew[i].vector_tasks[0];
                        //cout << "Tamanhox: " <<  vector_crew[i].vector_tasks.size();
                        //cout << vector_crew[i].vector_tasks.size();//vector_crew[i].vector_tasks;
                        //vc[i].jornada.push_back(*iter);
                }
        }

        arquivo.close();
 }
 */

void CrewUtil::gravar_solucao(const vector<Crew>& v, char* filename)
{
    cl_iterator iter;
    ofstream out_file( filename, ios::out | ios::trunc);
    int n_tarefa;

    assert(out_file);


    //out_file << v.size();

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "##" << i << "\n";
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter){
            out_file << iter->n_veiculo << "," << iter->h_inicial << "," << iter->h_final << ","
                      << iter->p_inicial << "," << iter->p_final << ","
                      << iter->f_acumulada << "," << iter->l_inicial << "," << iter->l_final;

            if(iter->artificial)
                out_file << ",*\n";
            else
                out_file << "\n";
        }
    }

    out_file.close();
}

void CrewUtil::ler_solucao(vector<Crew>& vc, char* filename)
{
        int indice = -1,trips;
        char aux,art,comentario;
        char buffer[100];
	Task task;

	ifstream task_file(filename, ios::in );

	assert(task_file);

        //le o numero de tripulantes presentes na solucao redimensionando o vetor.
       // task_file >> trips;
        //vc.resize(trips);

        memset(buffer, '\0', sizeof(buffer));

        while(task_file.getline(buffer,100))
        {
             //cout << "\nLinha " << buffer;
            if(buffer[0] == '#'){
                 // if(indice > 0) cout << "\nN " << vc[indice].jornada.size();
                  //cin.get();
                  ++indice;
                  continue;
            }
            art = 'b';
            sscanf(buffer,"%d,%d,%d,%d,%d,%d,%d,%d,%c", &task.n_veiculo,&task.h_inicial,&task.h_final,&task.p_inicial,&task.p_final
	     		,&task.f_acumulada,&task.l_inicial,&task.l_final,&art);

            if(art == '*') {
                task.artificial = true;
            }
            else{
                task.artificial = false;
            }

            vc[indice].jornada.push_back(task);
            memset(buffer, '\0', sizeof(buffer));

       }
       task_file.close();
}

/*******************************************************************************
 * Metodo: dump_file()
 * Objetivo: Arquivo de sada (LeoXT).
 *********************************************************************************/
void CrewUtil::dump_file3(vector<Crew>& v,char* filename)
{
    cl_iterator iter;
    int n_tarefa;
    ofstream out_file( filename, ios::out | ios::trunc);

    assert(out_file);

    //CrewUtil crew;
    Crew trip;
    int total_tarefas = 0;
    int total_tocioso = 0;
    int total_hextra = 0;
    int total_tveiculo = 0;
    int total_tppermitida = 0;
    int total_tpproibida = 0;
    int total_tlpermitida = 0;
    int total_tlproibida = 0;
    int total_tsobreposicao = 0;
    int total_djornada = 0;
    int total_fte_jornada = 0;

    for(int i = 0; i < (int)v.size(); ++i)
    {
            total_tarefas = total_tarefas + v[i].jornada.size();
            total_tocioso = v[i].t_ocioso() + total_tocioso;
            total_hextra = v[i].h_extra() + total_hextra;
            total_tveiculo = v[i].t_veiculo() + total_tveiculo;
            total_tppermitida = v[i].tp_permitida() + total_tppermitida;
            total_tpproibida = v[i].tp_proibida() + total_tpproibida;
            total_tlpermitida = v[i].tl_permitida() + total_tlpermitida;
            total_tlproibida = v[i].tl_proibida() + total_tlproibida;
            total_tsobreposicao = v[i].t_sobreposicao() + total_tsobreposicao;
            total_djornada = v[i].d_jornada() + total_djornada ;
            total_fte_jornada = v[i].fte_jornada() + total_fte_jornada;
    }


    out_file << "\t\tProgramacao da Tripulacao\n";
    out_file << "\nA solucao abaixo possui funo objetivo global = " << f_objetivo_global(v)
             << "\n\nTotal de tripulantes com tarefas: " << v.size() - this->nsem_tarefas(v)
             << "\nTotal de tarefas atribuidas : " << total_tarefas
             << "\nTotal de tarefas virtuais: " << this->n_virtuais(v)
             << "\nTempo total de trabalho: " << this->get_horas(total_djornada)
             << "\nNumero excessivo de pegadas duplas: " << this->np_duplas(v)
             << "\nNumero total de pegadas duplas: " << this->pduplas_total(v)
             << "\nTempo ocioso total: " << this->get_horas(total_tocioso)
             << "\nHora extra total: " << this->get_horas(total_hextra)
             << "\nTempo total de sobreposicao: " << this->get_horas(total_tsobreposicao)
             << "\nTempo que falta entre jornadas: " << this->get_horas(total_fte_jornada)
             << "\nNumero total de trocas de veiculos: " << total_tveiculo
             << "\nNumero total de trocas de ponto permitida: " << total_tppermitida
             << "\nNumero total de trocas de ponto proibida: " << total_tpproibida
             << "\nNumero total de trocas de linha permitida: " << total_tlpermitida
             << "\nNumero total de trocas de linha proibida: " << total_tlproibida;

    for(int i = 0; i < (int)v.size(); ++i){
        out_file << "\n\n========================================================================================================\n";
        out_file << "\n\t\t\tTripulao " << i << "\n";
        //out_file << "Funcao objetivo do tripulante: " << v[i].f_objetivo() << "\n";
        out_file << "============================================================================================================\n";
        out_file << "\t\t\tN_Vei\t\tH_Inic\tH_Fin\t\tP_Ini\t\tP_Fina\tF_Acum\tL_Ini\t\tL_Fina\n";
        out_file << "_____________________________________________________________________________________________________________\n";
        n_tarefa=0;
        for(iter = v[i].jornada.begin(); iter != v[i].jornada.end(); ++iter){
            out_file << "Tarefa " << n_tarefa << "\t\t" << iter->n_veiculo << "\t\t"
                      << iter->h_inicial << "\t\t" << iter->h_final << "\t\t"
                      << iter->p_inicial << "\t\t" << iter->p_final << "\t\t"
                      << iter->f_acumulada << "\t\t" << iter->l_inicial << "\t\t" << iter->l_final;

            if(iter->artificial)
                out_file << "**\n";
            else
                out_file << "\n";

             out_file << "_____________________________________________________________________________________________________________\n";
             ++n_tarefa;
        }
        out_file << "Tempo total de trabalho : " << this->get_horas(v[i].d_jornada()) << endl;
        out_file << "Tempo ocioso: " << this->get_horas(v[i].t_ocioso()) << endl;
        out_file << "Hora Extra: " << this->get_horas(v[i].h_extra()) << endl;

        if(v[i].p_duplas())
        {
                out_file << "Tripulante com pegada dupla. " << endl;
        }

    }

    out_file.close();
}

int CrewUtil::n_virtuais(vector<Crew>& v)
{
    int total = 0;
    l_iterator iter;

  for(int i = 0; i < (int)v.size(); ++i){
    if(v[i].possui_artificial())
    {
        ++total;
    }

  }

   return total;


  }

string CrewUtil::get_horas(int minutos)
{
        int horas, minuto;
        char hora[11];
        string total;

        memset(hora, '\0', 11);

        horas = minutos/60;
        minuto = minutos%60;

        if(horas < 10)
                sprintf(hora, "0%d:%d", horas, minuto);
        else
                 sprintf(hora, "%d:%d", horas, minuto);

        total = hora;
        return total;
}

/* =============================================================================
- Mtodo.....: CriarLstTarefas
- Objetivo...: Criar o arquivo .tsk a partir do .vei e retornar uma lista com as
               tarefas do arquivo .vei.
- Parmetros.:
     1) TmpTrocaTrip -> Parmetros que informa o tempo necessario para a troca de tripulao.
     2) Path -> Arquivo que contm a programao de veculos.
     3) PathSaida -> Arquivo que contera as tarefas criadas.
============================================================================= */
void CrewUtil::CriarLstTarefas(int TmpTrocaTrip, char* Path, char* PathSaida)
{
 int j;
 int aux1 = 0;
 int aux2 = 0;
 char aux_char[6] = "Linha";
 char aux_char1[76] =
 "----------------------------------------------------------------------------";
 char aux_char2[4] = "FIM";
 char line[150];
 char line1[150];
 char line2[150];
 int numvia, ponini, ponfim, horini, minini, horfim;
 int minfim, viamor, temter, linha;
 int temini, temfim, folacu;
 int pontoinicial, pontofinal, tempoinicial, tempofinal, folgaacumulada;
 int linhainicial, linhafinal;
 FILE *pv,*arqSaida;

// char *FilePath = new char[ Path.Length() + 1 ];
// strcpy(FilePath, Path.c_str());

// char *FilePathSaida = new char[ PathSaida.Length() + 1 ];
 //strcpy(FilePathSaida, PathSaida.c_str());


 pv = fopen(Path, "r");
 arqSaida = fopen(PathSaida, "w");

 //delete(FilePathSaida);
 //delete(FilePathSaida);

 if(!arqSaida)
  {
   printf("O arquivo de saida .tsk no pode ser criado\n");
   exit(1);
  }

 if(!pv)
  {
   printf("O arquivo da programao de veculos (.vei) no pode ser aberto!\n");
   exit(1);
  }
 else
  {
   j = 0;
   do
    {
     do
      {
       fscanf(pv,"%s",&line);
       //printf("%s\n",line);
      }while(strncmp(line, aux_char,6));
     fscanf(pv,"%s",&line);
     j++;
     do
      {
       folacu = 0;
       fgets(line1, 150 , pv);
       fscanf(pv, "%d\t%d\t%d:%d\t%d\t%d:%d\t%d\t%d\t%d", &numvia, &ponini,
              &horini, &minini, &ponfim, &horfim, &minfim, &viamor, &temter,
              &linha);
      // printf("\n%d\t%d\t%d:%d\t%d\t%d:%d\t%d\t%d\t%d", numvia, ponini,
       //       horini, minini, ponfim, horfim, minfim, viamor, temter,
     //         linha);
      // getchar();
       pontoinicial = ponini;

       if(pontoinicial == 0)
        aux1 = ponfim;
       else
        aux1 = ponini;

       temini = horini*60 + minini;
       tempoinicial = temini;
       linhainicial = linha;

       temfim = horfim*60 + minfim;


       if(temter < TmpTrocaTrip)//|| pontoinicial != ponfim)
        {
         do
          {
           //if(temter == -1)
            //temter = aux2;

           folacu = folacu + temter;
           fgets(line1, 150 , pv);
           //if(strncmp(line, aux_char1,7))
             //   break;
           fscanf(pv, "%d\t%d\t%d:%d\t%d\t%d:%d\t%d\t%d\t%d", &numvia, &ponini,
                  &horini, &minini, &ponfim, &horfim, &minfim, &viamor, &temter,
                  &linha);

           temfim = horfim*60 + minfim;

           /*if(temter >= TmpTrocaTrip && ponfim != aux1)
            {
             aux2 = temter;
             temter = -1;
            }*/
           if(numvia == 0)
            {
             temter = TmpTrocaTrip;
             fgets(line1, 20 , pv);
             fscanf(pv,"%s",&line1);
             //fscanf(pv,"%s",&line1);
            }
          }while(temter < TmpTrocaTrip);
        }// if
       pontofinal = ponfim;
       tempofinal = temfim;
       linhafinal = linha;
       folgaacumulada = folacu;

       fprintf(arqSaida, "%d,%d-%d,%d-%d,%d,%d-%d\n",j,tempoinicial,tempofinal,
                                                pontoinicial, pontofinal,folgaacumulada,
                                                linhainicial,linhafinal);
       printf("%d,%d-%d,%d-%d,%d,%d-%d\n",j,tempoinicial,tempofinal,
                                                pontoinicial, pontofinal,folgaacumulada,
                                                linhainicial,linhafinal);
       //fgets(line, 150 , pv);
       //printf("%s T%d\n",line1,strncmp(line1, "-------",7));
       //getchar();
      }while(strncmp(line1, "-------",7));
     fscanf(pv,"%s",&line2);
     printf("%s\n",line2);
    }while(strncmp(line2, "FIM",3));
  }
 fclose(arqSaida);
 fclose(pv);
}








