#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>

#define MAX(x,y) ((x)<(y) ? (y) : (x))

//prottipos de funes:

int *cria_vetor(int tam);
float *cria_vetor_float(int tam);
int **cria_matriz(int nlinhas, int ncolunas);
float **cria_matriz_float(int nlinhas, int ncolunas);
void libera_vetor(int *vetor);
void libera_matriz(int **matriz, int nlinhas);
void libera_matriz_float(float **matriz, int nlinhas);
void imprime_vetor(int *s, int n);
float calcula_fo(int *s,int n,int m,float **teor,int cacamba,int quant_req,
                 float *meta,float *limit_inf, float *limite_sup);
float faz_mov(int *s, int n, int pilha, int mov);
float randomico(float min, float max);
void atualiza_vetor(int *s_star, int *s, int n);
void inicializa_vetor(int *vetor, int tam);
void constroi_solucao_aleatoria(int *u, int m, int *s);
int menu_solucao_inicial(void);
int menu_principal(void);
float SA(int m, int *s, int *u, int SAmax,
         float temp_final, float temp_inicial,

         float alfa, float **teor, float *meta,

         int n, int quant_req, int cacamba,int mov,float *limite_inf,float *limite_sup);
         
float temperatura_inicial(int m,int *s,float beta,float gama,int SAmax,
                          float **teor, float *meta, int cacamba, int quant_req,
                          int mov,int n,int *u, float *limite_inf, float *limite_sup);


int main(int argc, char **argv){
  clock_t inicio_CPU,
          fim_CPU;
  int mov, n_cacamba = 0;
  int n = 7;           // numero de elementos qumicos
  int m = 6;           // numero de pilhas de minerio
  float *meta;         // vetor de especificaes
  float *meta_obtida;
  float **teor;        // matriz dos elementos qumicos
  float *limite_inf;    // limite mnimo dos componentes na mistura
  float *limite_sup;    // limite mximo dos componentes na mistura
  int *s;              // vetor solucao corrente
  int *u;              // vetor maximo de caambadas
  int cacamba = 50;
  int quant_req = 6100;
  float fo,            // funcao objetivo corrente
  temp_inicial;        // temperatura inicial Simulated Annealing
  meta = cria_vetor_float(n);
  limite_inf = cria_vetor_float(n);
  limite_sup = cria_vetor_float(n);
  meta_obtida = cria_vetor_float(n);
  teor = cria_matriz_float(m,n);
  s = cria_vetor(m);
  u = cria_vetor(m);
  limite_inf[0] = 68.50;
  limite_inf[1] = 0.00;
  limite_inf[2] = 0.00;
  limite_inf[3] = 0.00;
  limite_inf[4] = 0.00;
  limite_inf[5] = 0.00;
  limite_inf[6] = 0.00;

  limite_sup[0] = 70.00;
  limite_sup[1] = 0.80;
  limite_sup[2] = 0.017;
  limite_sup[3] = 0.40;
  limite_sup[4] = 0.090;
  limite_sup[5] = 0.00;
  limite_sup[6] = 8.50;
  
  meta_obtida[0] = 0;
  meta_obtida[1] = 0;
  meta_obtida[2] = 0;
  meta_obtida[3] = 0;
  meta_obtida[4] = 0;
  meta_obtida[5] = 0;
  meta[0] = 68.50;
  meta[1] = 0.650;
  meta[2] = 0.010;
  meta[3] = 0.250;
  meta[4] = 0.050;
  meta[5] = 0.000;
  meta[6] = 7.000;
  teor[0][0] = 68.80;
  teor[0][1] = 0.800;
  teor[0][2] = 0.010;
  teor[0][3] = 0.220;
  teor[0][4] = 0.037;
  teor[0][5] = 0.000;
  teor[0][6] = 8.800;
  teor[1][0] = 69.02;
  teor[1][1] = 0.530;
  teor[1][2] = 0.011;
  teor[1][3] = 0.240;
  teor[1][4] = 0.040;
  teor[1][5] = 0.000;
  teor[1][6] = 9.200;
  teor[2][0] = 69.04;
  teor[2][1] = 0.600;
  teor[2][2] = 0.012;
  teor[2][3] = 0.230;
  teor[2][4] = 0.052;
  teor[2][5] = 0.000;
  teor[2][6] = 9.400;
  teor[3][0] = 68.63;
  teor[3][1] = 0.830;
  teor[3][2] = 0.011;
  teor[3][3] = 0.250;
  teor[3][4] = 0.040;
  teor[3][5] = 0.000;
  teor[3][6] = 8.500;
  teor[4][0] = 68.86;
  teor[4][1] = 0.760;
  teor[4][2] = 0.010;
  teor[4][3] = 0.240;
  teor[4][4] = 0.039;
  teor[4][5] = 0.000;
  teor[4][6] = 8.900;
  teor[5][0] = 69.04;
  teor[5][1] = 0.530;
  teor[5][2] = 0.010;
  teor[5][3] = 0.230;
  teor[5][4] = 0.029;
  teor[5][5] = 0.000;
  teor[5][6] = 8.400;
  u[0] = 40;
  u[1] = 40;
  u[2] = 30;
  u[3] = 20;
  u[4] = 40;
  u[5] = 30;
  int escolha = 0;
  
  do {
    escolha = menu_principal();
    switch (escolha) {
    case 1: /* Geracao de uma solucao inicial */
           switch(menu_solucao_inicial()) {
           case 1: /* Geracao aleatria de uma solucao inicial */
                 // srand(1000); pega o numero 1000 como semente de numeros aleatorios
                 srand((unsigned) time(NULL)); // pega a hora do relogio como semente
                 constroi_solucao_aleatoria(u,m,s);
                 n_cacamba = 0;
                 for (int i = 1; i < 7; i++){
                        n_cacamba = n_cacamba + s[i-1];
                        printf("Pilha %i\t = %i\n",i,s[i-1]);
                 }
                 for (int i = 1; i < 8; i++){
                        meta_obtida[i-1] = 0;
                        for (int j = 1; j < 7; j++){
                               meta_obtida[i-1] = meta_obtida[i-1]+(teor[j-1][i-1]*s[j-1])/n_cacamba;
                        }
                 }
                 for (int i = 1; i < 8; i++)
                     printf("Meta Requerida %i\t = %f\t Meta Obtida %i\t = %f\n",i,meta[i-1],i,meta_obtida[i-1]);
                 fo = calcula_fo(s,n,m,teor,cacamba,quant_req,meta,limite_inf,limite_sup);
                 printf("\nSolucao construida de forma aleatoria:\n");
                 printf("Funcao objetivo = %f\n",fo);
                 printf("Quantidade Requisitada = %i\t Quantidade produzida = %i\t",quant_req,n_cacamba*50);
	         break;
           case 2: /*gerao gulosa de uma soluo inicial */
                 break;
           case 3: /*gerao parcialmente gulosa de um soluo inicial */
                 break;
           }
           break;
   // case 2: /* Busca Tabu */
          //break;
    case 2: /* Simulated Annealing */
           //inicio_CPU = clock();
           //do {
           temp_inicial = temperatura_inicial(m,s,5,0.95,500,teor,meta,cacamba,quant_req,mov,n,u,limite_inf,limite_sup);
           printf("\nTemperatura Inicial = %f \n",temp_inicial);
           fo = SA(m,s,u,500,0.001,temp_inicial,0.99,teor,meta,n,quant_req,cacamba,mov,limite_inf,limite_sup);
           n_cacamba = 0;
           for (int i = 1; i < 7; i++){
               n_cacamba = n_cacamba + s[i-1];
               printf("Pilha %i\t = %i\n",i,s[i-1]);
           }
           for (int i = 1; i < 8; i++){
               meta_obtida[i-1] = 0;
               for (int j = 1; j < 7; j++){
                 meta_obtida[i-1] = meta_obtida[i-1]+(teor[j-1][i-1]*s[j-1])/n_cacamba;
               }
           }
           for (int i = 1; i < 8; i++)
               printf("Meta Requerida %i\t = %f\t Meta Obtida %i\t = %f\n",i,meta[i-1],i,meta_obtida[i-1]);
           printf("\nSolucao construida usando o Metodo Simulated Annealing:\n");
           printf("\nMelhor fo encontrada = %f \n",fo);
           printf("Quantidade Requisitada = %i\t Quantidade produzida = %i\t",quant_req,n_cacamba*50);
           //fim_CPU = clock();
           //} while((fim_CPU-inicio_CPU) < 2);
           break;
   default:
          break;
    }
 } while(escolha != 0);


libera_vetor(s);
libera_matriz_float(teor, m);
return 0;
}

/* cria memoria para um vetor de tam posicoes */
int *cria_vetor(int tam)
{
  int *vetor;

  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}

/* cria memoria para um vetor de tam posicoes */
float *cria_vetor_float(int tam)
{
  float *vetor;

  vetor = (float *) malloc(tam*sizeof(float));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}

/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
int **cria_matriz(int nlinhas, int ncolunas)
{
  register int i;
  int **matriz;

  matriz = (int **) malloc(nlinhas*sizeof(int *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (int *) malloc(ncolunas*sizeof(int));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}


/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
float **cria_matriz_float(int nlinhas, int ncolunas)
{
  register int i;
  float **matriz;

  matriz = (float **) malloc(nlinhas*sizeof(float *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (float *) malloc(ncolunas*sizeof(float));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}


/* libera memoria de um vetor */
void libera_vetor(int *vetor)
{
  free(vetor);
}

void libera_matriz(int **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((int *) matriz[i]);
  free((int *) matriz);
}


void libera_matriz_float(float **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((float *) matriz[i]);
  free((float *) matriz);
}


/* imprime a solucao */
void imprime_vetor(int *s, int n)
{
    for (int j=0; j < n; j++) printf("s[%2d]=%d \n",j,s[j]);
}

/* calcula a funcao objetivo */
float calcula_fo(int *s,int n,int m,float **teor,int cacamba,int quant_req,
                 float *meta,float *limite_inf, float *limite_sup){
int i, total_cacamba = 0;
float producao = 0;
float *resultado;
resultado = cria_vetor_float(n);
float desvio_meta = 0;
float fo = 0;
        for (i = 0; i < m; i++){
            total_cacamba = total_cacamba + s[i];
            producao = producao + s[i]*cacamba;
        }
        for (int i=0; i<n; i++){
            resultado[i] = 0;
            for (int j=0; j<m; j++){
                resultado[i] = resultado[i]+(s[j]*teor[j][i])/total_cacamba;
             }
             if (resultado[i] > limite_inf[i]){
                if (resultado[i] > limite_sup[i])
                  desvio_meta = desvio_meta + 1000*(resultado[i] - limite_sup[i])*producao/100;
                else
                  desvio_meta = desvio_meta + 100*(limite_sup[i] - resultado[i])*producao/100;
             }
             else
               desvio_meta = desvio_meta + (limite_inf[i]- resultado[i])*producao/100;
//           desvio_meta = desvio_meta + fabs((meta[i] - resultado[i])*producao);
        }
        if (quant_req > producao)
          fo = desvio_meta + 10*(quant_req - producao);
        else
          fo = desvio_meta + 10*(producao - quant_req);

//        fo = desvio_meta + 10000*fabs(quant_req - producao);

     return fo;
}

void faz_mov(int *s, int pilha, int mov){

        if (mov == 1)
           s[pilha]++;
        else
           s[pilha]--;
}

/* Gera numero aleatorio entre min e max */
float randomico(float min, float max)
{
  if (min == max) return min;
  return ((float) (rand()%10000/10000.0)*(max-min) + min);
}

/* atualiza a melhor solucao */
void atualiza_vetor(int *s_star, int *s, int n)
{
   for (int j=0; j < n; j++) s_star[j] = s[j];
}

void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++) vetor[j] = 0;
}

void constroi_solucao_aleatoria(int *u, int m, int *s){
int i;
for (i = 0; i < m; i++)
    s[i] = random(u[i]+1);
}

/* Menu de geracao de uma solucao inicial */
int menu_solucao_inicial(void)
{
  int escolha;

  do {
    printf("\n************Geracao da Solucao Inicial**************** \n");
    printf("                  1. Aleatoria \n");
    //printf("                  2. Gulosa    \n");
    //printf("                  3. Parcialmente gulosa \n");
    printf("                  escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 0 || escolha > 3);
  return escolha;
}


/* Menu principal */
int menu_principal(void)
{
  int escolha;

  do {
    printf("\n***************Menu Principal************************* \n");
    printf("         1. Gere solucao inicial \n");
    //printf("         2. Busca Tabu \n");
    printf("         2. Simulated Annealing \n");
    printf("         0. Sair \n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 0 || escolha > 3);
  return escolha;
}


float SA(int m, int *s, int *u, int SAmax,

         float temp_final, float temp_inicial,

         float alfa, float **teor, float *meta,

         int n, int quant_req, int cacamba,int mov,float *limite_inf,float *limite_sup){


  float delta, fo_novo,fo_corrente, fo,
        fo_star;
  float temperatura = temp_inicial;
  int  pilha, iterT, aux;
  int *s_star;
  bool ok = false;
  s_star = cria_vetor(m);
  atualiza_vetor(s_star,s,m);
  fo_star = fo = calcula_fo(s,n,m,teor,cacamba,quant_req,meta,limite_inf,limite_sup);

   while (temperatura > temp_final){
    iterT = 0;
    while (iterT < SAmax){
      iterT++;
      // Gere um vizinho qualquer
     do {
      mov = random(2);
      pilha = random(m);   // Escolhe um pilha
      aux = s[pilha];  // Guarda o movimento
      fo_corrente = calcula_fo(s,n,m,teor,cacamba,quant_req,meta,limite_inf,limite_sup);
      if (mov == 1) {
      if (s[pilha] >= 0 && s[pilha] < u[pilha]){
         faz_mov(s,pilha,mov);
         ok = true;}
      }
      else {
          if (s[pilha] >= 1 && s[pilha] <= u[pilha]){
         faz_mov(s,pilha,mov);
         ok = true;}
      }
     } while (ok == false);
      fo_novo = calcula_fo(s,n,m,teor,cacamba,quant_req,meta,limite_inf,limite_sup);
      float delta = fo_novo - fo_corrente;
      if(delta < 0){
         fo = fo + delta;
         if (fo < fo_star){
           fo_star = fo;
           atualiza_vetor(s_star,s,m);
           //printf("fo_star = %f \n",fo_star);
         }
      }
      else{
        float x = randomico(0,1);
        if (x < exp(-delta/temperatura))
           fo = fo + delta;
        else
          s[pilha] = aux;  // desfaz o movimento
      }
    }
    temperatura = alfa * temperatura;
  }
  atualiza_vetor(s,s_star,m);
  libera_vetor(s_star);


  //int n_cacamba = 0;
  //float *meta_obtida;
  //meta_obtida = cria_vetor_float(n);
  //for (int i = 1; i < 7; i++){
  //n_cacamba = n_cacamba + s[i-1];
  //printf("Pilha %i\t = %i\n",i,s[i-1]);
  //  }
  //for (int i = 1; i < 8; i++){
  //for (int j = 1; j < 7; j++){
                              // meta_obtida[i-1] = meta_obtida[i-1]+(teor[j-1][i-1]*s[j-1])/n_cacamba;
  // }
  // }
  // for (int i = 1; i < 8; i++)
  //   printf("Meta Requerida %i\t = %f\t Meta Obtida %i\t = %f\n",i,meta[i-1],i,meta_obtida[i-1]);
  //fo = calcula_fo(s,n,m,teor,cacamba,quant_req,meta);




  return fo_star;
}

float temperatura_inicial(int m,int *s,float beta,float gama,int SAmax,
                          float **teor, float *meta, int cacamba, int quant_req,
                          int mov,int n,int *u,float *limite_inf, float *limite_sup){
 int pilha, aux, iterT, aceitos;
 float temperatura;
 float delta = 0;
 float fo_novo = 0;
 float fo_corrente = 0;
 bool continua, ok;
 temperatura = 10;
 continua = true;
 ok = false;
 while (continua){
    aceitos = 0;
    iterT = 0;
    while (iterT < SAmax){
      iterT++;
      do {
      mov = random(2);
      pilha = random(m);   // Escolhe um pilha
      aux = s[pilha];  // Guarda o movimento
      fo_corrente = calcula_fo(s,n,m,teor,cacamba,quant_req,meta,limite_inf,limite_sup);
      if (s[pilha] >= 1 && s[pilha] < u[pilha]){
         faz_mov(s,pilha,mov);
         ok = true;}
        } while (ok == false);
      fo_novo = calcula_fo(s,n,m,teor,cacamba,quant_req,meta,limite_inf,limite_sup);
      delta = fo_novo - fo_corrente;
      if (delta < 0)
         aceitos++;
      else {
        float x = randomico(0,1);
        if (x < exp(-delta/temperatura))
           aceitos++;
      }
      s[pilha] = aux;         // Desfaz o movimento
    } // fim do while interno
    if (aceitos < gama * SAmax)
      temperatura = beta * temperatura;
    else
      continua = false;
  }
  return temperatura;
}









































