#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include "Util.h"
#include "UEstruturas.h"
#include "UListas.h"

#define MAX(x,y) ((x)<(y) ? (y) : (x))


/* cria memoria para um vetor de tam posicoes */
int *cria_vetor(int tam)
{
  int *vetor;

  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}


/* cria memoria para um vetor de tam posicoes */
float *cria_vetor_float(int tam)
{
  float *vetor;

  vetor = (float *) malloc(tam*sizeof(float));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}


/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
int **cria_matriz(int nlinhas, int ncolunas)
{
  register int i;
  int **matriz;

  matriz = (int **) malloc(nlinhas*sizeof(int *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (int *) malloc(ncolunas*sizeof(int));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}


/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
float **cria_matriz_float(int nlinhas, int ncolunas)
{
  register int i;
  float **matriz;

  matriz = (float **) malloc(nlinhas*sizeof(float *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (float *) malloc(ncolunas*sizeof(float));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}



/* libera memoria de um vetor */
void libera_vetor(int *vetor)
{
  free(vetor);
}


void libera_matriz(int **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((int *) matriz[i]);
  free((int *) matriz);
}



void libera_matriz_float(float **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((float *) matriz[i]);
  free((float *) matriz);
}




/* imprime a solucao */
void imprime_vetor(int *s, int n)
{
    for (int j=0; j < n; j++) printf("s[%2d]=%d \n",j,s[j]);
}


/* imprime a solucao */
void imprime_rota(int *s, int n)
{
    for (int j=0; j < n; j++) printf("%d -> ",s[j]);
    printf("%d \n",s[0]);
}


/* calcula a funcao objetivo */
float calcula_fo(int n, int *s, float **distancia)
{
    float dist_percorrida = 0;

    for ( int j=0; j < n-1; j++ ) {
//      printf("+d[%2d,%2d] = %f \n",s[j],s[j+1],distancia[s[j]][s[j+1]]);
      dist_percorrida += distancia[s[j]][s[j+1]];
    }
    dist_percorrida += distancia[s[n-1]][s[0]];
//    printf("Distancia=%f \n",dist_percorrida);
    return dist_percorrida;
}


/* Gera numero aleatorio entre min e max */
float randomico(float min, float max)
{
  if (min == max) return min;
  return ((float) (rand()%10000/10000.0)*(max-min) + min);
}


/* atualiza a melhor solucao */
void atualiza_vetor(int *s_star, int *s, int n)
{
   for (int j=0; j < n; j++) s_star[j] = s[j];
}


void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++) vetor[j] = 0;
}


void embaralha_vetor(int *vetor, int n)
{
  int aux, j1, j2;

  for (int i=0; i < n; i++)
  {
    j1 = random(n);
    j2 = random(n);
    while (j1 == j2) j2 = random(n);
    aux = vetor[j1];
    vetor[j1] = vetor[j2];
    vetor[j2] = aux;
  }
}




