import java.util.Vector;

class Processo {
	
	private String nome;
	private int nivel = 0; //height
	private int tempo = 0; //tempo de execucao
	
	private Vector preds = null;
	private Vector succs = null;
	
	public Processo (String nome, int tempo) {
		Processo[] pais = new Processo[0];
		inicia(nome, tempo, pais);
	}
	
	public Processo (String nome, int tempo, Processo predecessor) {
		Processo[] pais = new Processo[1];
		pais[0] = predecessor;
		inicia(nome, tempo, pais);
	}
	
	public Processo (String nome, int tempo, Processo[] predecessores) {
		inicia(nome, tempo, predecessores);
	}
		
	private void inicia(String nome, int tempo, Processo[] predecessores) {
		this.nome = nome;
		this.tempo = tempo;
		
		if (predecessores==null || predecessores.length==0)
			nivel=0;
		else {
			preds = new Vector();
			int maxnivel = 0;
			for (int i=0; i<predecessores.length; i++) {
				preds.add(predecessores[i]);
				maxnivel = Math.max(maxnivel, predecessores[i].getNivel());
				predecessores[i].addSucessor(this);
			}
			this.nivel = maxnivel+1;
		}
	}
	
	public String getNome() {
		return nome;
	}
	
	public int getTempo() {
		return tempo;
	}
	
	public int getNivel() {
		return nivel;
	}
	
	public void addSucessor(Processo suc) {
		if (succs==null)
			succs = new Vector();
			
		succs.add(suc);
	}
	
	public Processo[] getPredecessores() {
		if (preds==null || preds.size()==0)
			return null;
			
		Processo[] pr = new Processo[preds.size()];
		for (int i=0; i<preds.size(); i++)
			pr[i]=(Processo)preds.get(i);
			
		return pr;
	}
	
	public Processo[] getSucessores() {
		if (succs==null || succs.size()==0)
			return null;
			
		Processo[] sc = new Processo[succs.size()];
		for (int i=0; i<succs.size(); i++)
			sc[i]=(Processo)succs.get(i);
			
		return sc;
	}
	
	public String toString() {
		return nome + " ("+tempo+", "+nivel+")";
	}
}