import java.util.Vector;

class Processador {
	
	protected class Item {
		public Processo proc = null;
		private int inicio = 0;
		
		public Item(Processo proc, int inicio) {
			this.proc=proc;
			this.inicio=inicio;
		}
		
		public int getInicio() {
			return inicio;
		}
		
		public int getFim() {
			return inicio+proc.getTempo();
		}
	}
	
	private Vector itens = null;
	
	
	public void addProcesso(Processo p, int inicio) {
		int ini = Math.max(inicio, getTempoTotal());
		if (itens==null)
			itens=new Vector();

		itens.add(new Item(p, ini));
	}

	public void addProcesso(Processo p) {
		addProcesso(p, 0);
	}

	public Processo getProcesso(int num) {
		if (itens==null || num < 0 || num >= itens.size() )
			return null;
		
		return ((Item)itens.get(num)).proc;
	}

	public int getNumProcessos() {
		if (itens==null)
			return 0;
			
		return itens.size();
	}
	
	public int getFimProcesso(Processo p) {
		if (itens==null)
			return -1;
		for (int i=0; i<itens.size(); i++) {
			Item it = (Item)itens.get(i);
			if ( it.proc.getNome().equals(p.getNome()) )
				return it.getFim();
		}
				
		return -1;
	}
	
	public int getTempoTotal() {
		if (itens==null)
			return 0;
		else
			return ((Item)itens.get(itens.size()-1)).getFim();
	}
	
	public String toString() {
		if (itens==null)
			return "vazio";
			
		String str = "";
		for (int i=0; i<itens.size(); i++) {
			Item it = (Item)itens.get(i);
			str = str + " " + it.getInicio() + "-" +  it.proc.toString();
		}
			
		return str;
	}
	
}