import java.util.Vector;
import java.io.*;
import java.util.StringTokenizer;

public class MSPGenetico {
	
	private static java.util.Random rnd = new java.util.Random();
	
	//Guarda o ultimo tempo de execucao (em milisegundos)
	private long lastExecutionTime = 0;
	private int numGenerations = 0;
	
	//Generate-Schedule
	public static Individuo geraIndividuo(int numProcessadores, Processo[] procs) {
		//pega numero de nveis
		int numNiveis = 0;
		for (int i=0; i<procs.length; i++)
			numNiveis = Math.max(numNiveis, procs[i].getNivel()+1);
		
//		System.out.println("NumNiveis: "+numNiveis + " nivel do 8:"+procs[7].getNivel());
		// um vetor de vetores. niveis.get(0)  um vetor de processos
		//que estao no nivel 0
		Vector[] nivel = new Vector[numNiveis+1];
		
		
		for (int i=0; i<numNiveis; i++) {
			nivel[i] = new Vector();
			for (int j=0; j<procs.length; j++)
				if (procs[j].getNivel()==i)
					nivel[i].add(procs[j]);
		}
		
		Individuo ind = new Individuo(numProcessadores);
		
		//Coloca um num. aleatorio de processos de cada nivel em cada processador
		for (int n=0; n<numNiveis; n++) {
			
			for (int p=0; p<numProcessadores-1; p++) {  //p  o num do processador
				int numProcNivel = nivel[n].size(); //numero de processo nesse nivel
			
				int r = rnd.nextInt(numProcNivel+1);	// numero de processos pegos nesse nivel
				
//				System.out.println("p: "+p +" n: "+n+" numProcNivel: "+numProcNivel+" r: "+r);
				for(int j=0; j<r; j++) { //j  o numero do processo
					int escolha = rnd.nextInt(nivel[n].size());  //qual o objeto sera pego - pode ser de 0 a nivel[n].size()-1
					Processo processo = (Processo)nivel[n].remove(escolha);
//					int inicio = ind.getInicioProcesso(processo);	
					ind.addProcesso(p, processo);
				}
				
			}
			
			int p = numProcessadores-1;
			int numProcNivel = nivel[n].size(); //numero de processo nesse nivel
//			System.out.println(numProcNivel);
	
			for(int j=0; j<numProcNivel; j++) { //j  o numero do processo
				int escolha = rnd.nextInt(nivel[n].size());  //qual o objeto sera pego - pode ser de 0 a nivel[n].size()-1
				Processo processo = (Processo)nivel[n].remove(escolha);
//				int inicio = ind.getInicioProcesso(processo);	
				ind.addProcesso(p, processo);
			}
			
		}
		
		return ind;
	}


	//FT - Fitness Function
	//Quanto maior a aptidao, melhor o individuo, pois menor ser seu tempo de trmino
	public static int calcAptidao(Individuo ind) {
		
		//Calcula Cmax = soma dos tempos de todos os processos do indivuduo
		int Cmax = 0;
		int nprocess = ind.getNumProcessos();
		for (int i=0; i<nprocess; i++)
			Cmax += ind.getProcesso(i).getTempo();
		
		int ft = ind.getTempoTotal();
		
		return Cmax - ft;
	}
	
	//retorna Individuo[2]: dois individuos gerados pelo crossover
	public static Individuo[] crossover(Individuo indA, Individuo indB) {
		//A e B tem q ter numero igual de niveis e processadores
		if (!indA.isEquivalent(indB))
			return null;
		
		//pega numero de nveis
		int maxNivel = indA.getMaxNivel();
		int numProcessador = indA.getNumProcessadores();
		
		int c = rnd.nextInt(maxNivel+1);
		
		//procura os pontos de corte em A
		int ultTA[] = new int[numProcessador]; //posicao do ult. processo de nivel c em cada processador do individuo A
		
		//inicializa ultTA
		for (int i=0; i < numProcessador; i++)
			ultTA[i] = -1;
		
		for (int i=0; i < numProcessador; i++)
			for (int j=0; j < indA.getProcessador(i).getNumProcessos(); j++)
				if ( indA.getProcesso(i, j).getNivel() <= c)
					ultTA[i] = j;
		

		//procura os pontos de corte em B
		int ultTB[] = new int[numProcessador]; //posicao do ult. processo de nivel c em cada processador do individuo B
		
		//inicializa ultTB
		for (int i=0; i < numProcessador; i++)
			ultTB[i] = -1;

		for (int i=0; i < numProcessador; i++)
			for (int j=0; j < indB.getProcessador(i).getNumProcessos(); j++)
				if ( indB.getProcesso(i, j).getNivel() <= c)
					ultTB[i] = j;

		Individuo newInd[] = new Individuo[2];
		newInd[0] = new Individuo(numProcessador);
		newInd[1] = new Individuo(numProcessador);
		
		//faz o crossover
		//para cada processador:
		//pega os processos de um nivel da primeira metade de A e/ou
		// da segunda de B e adiciona em newInd[0]
		// e vice versa
		
		//faz a insercao por niveis
		Processo tempP = null;
		for (int n=0; n <= maxNivel; n++) {
			for (int i=0; i < numProcessador; i++) {
				
				for (int j=0; j <= ultTA[i]; j++) {
					tempP = indA.getProcesso(i, j);
					if (tempP.getNivel() == n)
						newInd[0].addProcesso(i, tempP);
				}
				
				for (int j=ultTB[i]+1; j < indB.getProcessador(i).getNumProcessos(); j++) {
					tempP = indB.getProcesso(i, j);
					if (tempP.getNivel() == n)
						newInd[0].addProcesso(i, tempP);
				}

				for (int j=0; j <= ultTB[i]; j++) {
					tempP = indB.getProcesso(i, j);
					if (tempP.getNivel() == n)
						newInd[1].addProcesso(i, tempP);
				}
				
				for (int j=ultTA[i]+1; j < indA.getProcessador(i).getNumProcessos(); j++) {
					tempP = indA.getProcesso(i, j);
					if (tempP.getNivel() == n)
						newInd[1].addProcesso(i, tempP);
				}

			}	
				
		}
		
/*
		for (int i=0; i < numProcessador; i++) {
			for (int j=0; j <= ultTA[i]; j++) {
				System.out.println(" i: "+i+"  j: "+j);
				newInd[0].addProcesso(i, indA.getProcesso(i, j));
			}
				
			for (int j=ultTB[i]+1; j < indB.getProcessador(i).getNumProcessos(); j++)
				newInd[0].addProcesso(i, indB.getProcesso(i, j));
		
			for (int j=0; j <= ultTB[i]; j++)
				newInd[1].addProcesso(i, indB.getProcesso(i, j));
				
			for (int j=ultTA[i]+1; j < indA.getProcessador(i).getNumProcessos(); j++)
				newInd[1].addProcesso(i, indA.getProcesso(i, j));
			
		}
*/

		return newInd;
	}
	
	////////////////Conferir!!
	//Reproduction
	//Mantm o melhor individuo da populacao
	public static Individuo[] reproducao(Individuo[] pop) {
		int npop = pop.length;
		

		Individuo melhor = null;
		int melhorFT = 0;
		
		Vector slots = new Vector();
		
		//Construindo a roleta russa
		int nsum = 0;
		for (int i=0; i<npop; i++) {
			int ft = calcAptidao(pop[i]);
			
			if (ft > melhorFT) {
				melhor = pop[i];
				melhorFT=ft;
			} else if ( (ft == melhorFT) && (rnd.nextBoolean()) ) {
				//Se ft for igual a melhorFT, damos uma chance de 50% para este ser escolhido como o melhor
				melhor = pop[i];
				melhorFT=ft;
			}
			
			nsum += ft;
			//coloca o individuo pop[i] "ft" vezes nos slots
			for (int j=0; j<=ft; j++)
				slots.add(pop[i]);
		}
		
		Individuo[] newpop = new Individuo[npop];
		
		for (int i=0; i<npop-1; i++) {
			int r = rnd.nextInt(nsum);	
			newpop[i]=(Individuo)slots.get(r);
		}
		
		newpop[npop-1] = melhor;
		
		return newpop;
	}
	
	
	/**
	 * Faz a mutacao de um individuo, trocando dois processos de mesmo nivel.
	 */
	public static Individuo mutacao(Individuo ind) {
		
		int num = ind.getNumProcessos();
		
		Processo p1 = null;
		
		int nivel;
		
		Vector ps = new Vector();
		
		while (ps.size()==0) { //Se nao encontrar outro processo de mesmo nivel, escolhe outro
			int r = rnd.nextInt(num);
		
			p1 = ind.getProcesso(r);
		
			nivel = p1.getNivel();
		
			Processo p2 = null;
		
			for (int i=0; i<num; i++) //Procura os processos com mesmo nivel
				if (i != r) {  //Evita que pegue o mesmo processo
					p2 = ind.getProcesso(i);
					if (p2.getNivel()==nivel)
						ps.add(p2);
				}
		}
		
		int r = rnd.nextInt(ps.size()); //Seleciona um dos processos
		
		Processo p2 = (Processo)ps.get(r);
		
//		System.out.println(" "+p1+"  "+p2);
		
		int numProc = ind.getNumProcessadores();
		int maxNivel =ind.getMaxNivel();
		Processo ptmp = null;
		
		Individuo novoInd = new Individuo ( numProc );
		
		for (int i=0; i<=maxNivel; i++) {
			for (int j=0; j<numProc; j++) {
				int numProcess = ind.getProcessador(j).getNumProcessos();
				
				int tnivel = 0;
				
				for (int pos = 0; pos < numProcess && tnivel <= i; pos++) {
					ptmp = ind.getProcesso(j, pos);
					tnivel = ptmp.getNivel();
					if (tnivel == i)
						if (ptmp == p1) //Se for p1, poe p2
							novoInd.addProcesso(j, p2);
						else if (ptmp == p2) //Se for p2, poe p1
							novoInd.addProcesso(j, p1);
						else //Senao, poe o mesmo processo
							novoInd.addProcesso(j, ptmp);
						
				}
			}
			
		}
		
		return novoInd;
		
	}
	
	
	/**
	 * Procura o melhor escalonamento dos processos utilizando algoritmo gentico
	 *
	 * @param   numProcessadores  nmero de processadores em cada individuo
	 * @param   procs  processos que devero ser escalonados
	 * @param   npop  tamanho da populacao usada
	 * @param   probCrossover  probabilidade de fazer crossover (de 0 a 100)
	 * @param   probMutacao  probabilidade de fazer mutacao (de 0 a 100)
	 * @param   maxDesvioPadrao  Critrio de Parada. Desvio Padro mximo das aptidoes dos individuos de uma populacao (maior que zero).
	 * @param   maxTempo  Critrio de Parada. Tempo mximo que o algoritmo deve esperar (em segundos, maior que zero).
	 * @param   verbose  Indica se deve ou nao imprimir todas as populacoes geradas
	 * @return  O melhor escalonamento (individuo) encontrado.
	 */
	public Individuo MSP(int numProcessadores, Processo[] procs, int npop, int probCrossover, int probMutacao, double maxDesvioPadrao, long maxTempo, boolean verbose) {

		if (maxDesvioPadrao < 0 && maxTempo < 0)
			return null;	//Pelo menos um dos criterios de parada deve ser positivo
		
		//Algumas inicializacoes
		
		//Converter maxTempo de segundo para milisegundos
		maxTempo *= 1000;
		long tempoInicio = System.currentTimeMillis();
		
		
		Individuo[] pop = new Individuo[npop];
		
		//Gera uma populacao inicial
		for (int i=0; i<npop; i++)
			pop[i] = geraIndividuo(numProcessadores, procs);
		
		if (verbose) {
			System.out.println("Populao Inicial:");
			imprimePopulacao(pop);
		}
			
		int ft[] = new int[npop]; //aptidao dos individuos

		double dp = 0; //desvio padrao da populacao
		
		int ger = 1; //geracao
		
		while ( //Criterios de parada
		       (maxDesvioPadrao<0 ||   //Se maxDesvioPadrao for menor que zero, nao considera o teste
		       	 (dp = calcDesvPadrao(pop)) > maxDesvioPadrao ) //Para quando o desvio padrao for menor ou igual a maxDesvioPadrao
		       &&
		       (maxTempo<0 ||    //Se maxTempo for menor que zero, nao faz o teste
		         System.currentTimeMillis() - tempoInicio <= maxTempo)  //Nao excede o tempo limite
		      ) {
		      	
//		    System.out.print (" "+dp);
			Individuo[] newpop = reproducao(pop);
			
			//melhor  BESTSTRING
			Individuo melhor = newpop[newpop.length-1]; //o melhor sempre esta na ultima posicao de newpop

			Individuo[] tmp = new Individuo[npop];
			
			//Faz crossover com probabilidade propCrossover
			//Os pares sao escolhidos pegando o primeiro de cada metade, e assim por diante
			for (int i=0, j=npop/2; i < npop/2; i++, j++) {
				//Calcula probabilidade de crossover
				int r=rnd.nextInt(101); //Vai de 0 a 100
				if (r <= probCrossover) { //pega os filhos do crossover
					Individuo[] filhos = crossover(newpop[i], newpop[j]);
					tmp[i]=filhos[0];
					tmp[j]=filhos[1];
				} else {	//pega os pais
					tmp[i]=newpop[i];
					tmp[j]=newpop[j];
				}
			}
			
			//mutacao
			for (int i=0; i<npop; i++)
				if (rnd.nextInt(101) < probMutacao)
					pop[i] = mutacao(tmp[i]);
				else
					pop[i] = tmp[i];

			//Calcula aptidao (fitness) de cada individuo
			for (int i=0; i<npop; i++)
				ft[i]=calcAptidao(pop[i]);
						
			//Substitui o pior da populacao pelo melhor
			int posPior = 0;
			int ftPior = Integer.MAX_VALUE;
			for (int i=0; i<npop; i++)
				if ( ftPior > ft[i] ) {
					ftPior = ft[i];
					posPior = i;
				}
				
			pop[posPior] = melhor;
			ft[posPior] = calcAptidao(melhor);
				
			ger++;
			if (verbose) {
				System.out.println("Geracao "+ger+":");
				imprimePopulacao(pop);
			}

		} //fim do while
		
		//Procura o melhor individuo da populacao resultante
		Individuo melhor = null;
		int melhorFT = 0;
		int tmpFT;
		for (int i=0; i<npop; i++) {
			if ( ( tmpFT = calcAptidao(pop[i]) ) > melhorFT) {
				melhor=pop[i];
				melhorFT=tmpFT;
			}
		}
		
		lastExecutionTime = System.currentTimeMillis() - tempoInicio;
		numGenerations = ger;
		
		//Retorna o melhor individuo
		return melhor;
	}

	
	public static void imprimePopulacao(Individuo[] pop) {
		for (int i=0; i<pop.length; i++) {
			System.out.println(pop[i]);
			System.out.println("Tempo gasto: "+pop[i].getTempoTotal()+"\n");
		}
	}

	/**
	 * Calcula o desvio padrao das aptidoes dos individuos de uma populacao.
	 *
	 * @param   pop  uma populacao
	 * @return  o desvio padrao das aptidoes dos individuos
	 */
	public static double calcDesvPadrao(Individuo[] pop) {
		int npop = pop.length;

		int aptidoes[] = new int[npop];
		double mediaAptidoes = 0; //media das aptidoes
		
		for (int i=0; i<npop; i++) {
			aptidoes[i] = calcAptidao(pop[i]);
			mediaAptidoes += ((double)aptidoes[i])/npop;
//			System.out.println(" "+aptidoes[i]+" | "+mediaAptidoes+" >");
		}
//		System.out.println("----------");
		
		//Somatrio de (Xi - Media)^2
		double sum = 0;
		for (int i=0; i<npop; i++) {
			sum +=  Math.pow( (aptidoes[i] - mediaAptidoes), 2 );
		}
		
		return Math.sqrt( sum / npop );
	}

	/**
	 * Retorna o tempo da ultima execucao (em milisegundos)
	 */
	public long getLastExecutionTime()	{
		return lastExecutionTime;
	}

	/**
	 * Retorna o numero de geracoes da ultima execucao
	 */
	public int getNumGenerations()	{
		return numGenerations;
	}

	
	public static void main(String[] arg) {
		File arq = new File("testemsp.txt");
		
		if (!arq.canRead())
			die("No foi possivel ler o arquivo "+arq.getPath()+".", -1);
			
		System.out.println("Carregando o arquivo: "+arq.getPath());
		
		LineNumberReader leitor=null;
		
		try {
			leitor = new LineNumberReader(new FileReader(arq));
		} catch (FileNotFoundException e) {
			die("Arquivo no encontrado.", -1);
		}
		
		String linha;
		StringTokenizer tok;
		boolean leuprilinha = false; //leu primeira linha?
		
		//Parametros
		int numProcessadores=0;
		int npop=0;
		int probCrossover=0;
		int probMutacao=0;
		double maxDesvioPadrao=0;
		long maxTempo=0;
		
		Vector procs = new Vector();

		try {
		
		while ( (linha = leitor.readLine()) != null) {
			linha = linha.trim();
			
			if ( !linha.startsWith("#") && linha.length()!=0 ) {
				
				if (!leuprilinha) { // a primeira linha
					if (linha.indexOf("=") >=0)
						die("No existe a linha de configuracao.", leitor.getLineNumber());
					
					tok = new StringTokenizer(linha, ",");
					if (tok.countTokens() < 5)
						die("Linha de configuracao incompleta.", leitor.getLineNumber());
					
					
					try {
						numProcessadores = Integer.parseInt(tok.nextToken().trim());
					} catch (NumberFormatException e) {
						die("O primeiro valor no  um inteiro", leitor.getLineNumber());
					}
					
					try {
						npop = Integer.parseInt(tok.nextToken().trim());
					} catch (NumberFormatException e) {
						die("O segundo valor no  um inteiro", leitor.getLineNumber());
					}
					
					try {
						probCrossover = Integer.parseInt(tok.nextToken().trim());
					} catch (NumberFormatException e) {
						die("O terceiro valor no  um inteiro", leitor.getLineNumber());
					}

					try {
						probMutacao = Integer.parseInt(tok.nextToken().trim());
					} catch (NumberFormatException e) {
						die("O quarto valor no  um inteiro", leitor.getLineNumber());
					}

					try {
						maxDesvioPadrao = Double.parseDouble(tok.nextToken().trim());
					} catch (NumberFormatException e) {
						die("O quinto valor no  um double", leitor.getLineNumber());
					}
					
					try {
						maxTempo = Long.parseLong(tok.nextToken().trim());
					} catch (NumberFormatException e) {
						die("O sexto valor no  um long", leitor.getLineNumber());
					}
					
					
					leuprilinha=true;
				} else {  //Le as definicoes dos processos
					
					tok = new StringTokenizer(linha, "=");
					
					if (tok.countTokens() !=2)
						die("Erro de definio de processo.", leitor.getLineNumber());
					
					String nome = tok.nextToken();
					int tam = 0;
					try {
						tam = Integer.parseInt(tok.nextToken(":").substring(1).trim());
					} catch (NumberFormatException e) {
						die("O segundo argumento do processo no  um numero.", leitor.getLineNumber());
					}

					Vector preds = null;
					
					if (tok.hasMoreTokens()) { //tem predecessores
						preds = new Vector();
						while (tok.hasMoreTokens()) {
							String tmp = tok.nextToken(",").trim();
							if (tmp.startsWith(":"))
								tmp = tmp.substring(1);
							preds.add(tmp);
						}
					}
					
					System.out.println(nome + " tam:"+tam+" preds:"+preds);
					
					Processo[] predec = null;
					
					if (preds!=null) {
						predec = new Processo[preds.size()];
						for (int i=0; i<preds.size(); i++) {
							predec[i]=null;
							p: for (int j=0; j<procs.size(); j++) //Procura os predecessores
								if ( ((String)preds.get(i)).equals( ((Processo)procs.get(j)).getNome() ) ) {
									predec[i] = (Processo)procs.get(j);
									break p;
								}
							if (predec[i]==null)
								die("Processo predecessor ainda nao definido.", leitor.getLineNumber());
						}
					}
					
					Processo p = new Processo (nome, tam, predec);
					procs.add(p);
				}
				
			}
			
		} //fim do WHILE
		} //fim do TRY
		catch (IOException e) {
			die ("Erro de E/S"+e.getMessage(), leitor.getLineNumber());
		}
		
		if (!leuprilinha) //Se nao leu nem a primeira linha...
			die("Arquivo vazio.",-1);
			
		if (procs.size() == 0)
			die("Nenhum processo foi definido.", -1);
		
		System.out.println(procs);

		Processo process[] = new Processo[procs.size()];
		for (int i=0; i<procs.size(); i++)
			process[i] = (Processo)procs.get(i);
			
		System.out.println();
			
		MSPGenetico msp = new MSPGenetico();
		
		System.out.println("Processando...");
		Individuo ind = msp.MSP(numProcessadores, process, npop, probCrossover, probMutacao, maxDesvioPadrao, maxTempo, true);
		System.out.println("\nMelhor individuo encontrado:");
		System.out.println(ind);
		System.out.println(" Tempo gasto: "+ind.getTempoTotal());
		System.out.println("\nPronto");
		System.out.println(" Tempo gasto na execuo do algoritmo (em milisegundos): "+msp.getLastExecutionTime());
		System.out.println(" Numero de geracoes: "+msp.getNumGenerations());

		
	}
	
	public static void die(String erro, int linha) {
		System.err.println("ERRO: "+erro+(linha>=0?" (linha "+linha+")":""));
		System.exit(1);
	}
}