class Individuo {
	Processador[] procs;
	
	public Individuo(int numProcessadores) {
		procs = new Processador[numProcessadores];
		for (int i=0; i<numProcessadores; i++)
			procs[i] = new Processador();
	}
	
	public int getNumProcessadores() {
		return procs.length;
	}
	
	public Processador getProcessador(int num) {
		if (num >= 0 && num < getNumProcessadores())
			return procs[num];
		else
			return null;
	}
	
/*	public Processador[] getAllProcessador() {
		return procs;
	}
*/
	public void addProcesso(int numProcessador, Processo p, int inicio) {
		if (numProcessador >= 0 && numProcessador < getNumProcessadores())
			procs[numProcessador].addProcesso(p, inicio);
	}

	public void addProcesso(int numProcessador, Processo p) {
		addProcesso(numProcessador, p, getInicioProcesso(p));
	}
	
	public Processo getProcesso(int numProcessador, int num) {
  		Processador proc = getProcessador(numProcessador);
  		if (proc==null)
  			return null;
  		else
  			return proc.getProcesso(num);
	}

  //pega o enessimo processo.
	public Processo getProcesso(int num) {
		int nproc = getNumProcessadores();
		if (nproc==0)
			return null;
		
		int nprocessos[] = new int[nproc];
		for (int i=0; i<nproc; i++)
			nprocessos[i] = procs[i].getNumProcessos();
		
			
		int proc = 0;
		
		while ( num >= nprocessos[proc]) {
			num = num - nprocessos[proc];
			proc++;
		}
		
/*		
		int proc = 0;
		
		int nprocessos = 0;
		
		for (int i=0; i < nproc && num > nprocessos; i++) {
			nprocessos = procs[i].getNumProcessos();
			System.out.println(" processador "+i +" nprocessos: "+nprocessos);
			if (num >= nprocessos) {	//se o numero for menor que o num de processos do processador atual,
				System.out.println(" num: "+num+" proc: "+proc);
				num -= nprocessos;
				proc++;								//passa para o proximo processador
				System.out.println(" num: "+num+" proc: "+proc);
			}
		}
*/		
		return getProcesso(proc, num);
	}
  
  public int getNumProcessos() {
  	int numProc = getNumProcessadores();
  	int num = 0;
  	
  	for (int i=0; i < numProc; i++)
  		num += procs[i].getNumProcessos();
  		
  	return num;
  }
  
	public int getFimProcesso(Processo p) {
		int fim = -1;
		for (int pr=0; pr<procs.length && fim==-1; pr++)
			fim = procs[pr].getFimProcesso(p);
	
		return fim;
	}
	
	public int getInicioProcesso(Processo p) {
		Processo[] predecessores = p.getPredecessores();
		
		if (predecessores==null)
			return 0;

		int fim = -1, tempfim = -1, inicio = 0;
		Processo tempPred = null;
		
		for (int npred=0; npred < predecessores.length; npred++) {
			tempPred = predecessores[npred];
			tempfim = getFimProcesso(tempPred);
			if (fim < tempfim) {
				fim = tempfim;
				inicio = fim;
			}
		}

		return inicio;
	}
	
	//retorna o maior tempo de todos os processadores
	public int getTempoTotal() {
		int tempo = 0;
		for (int i=0; i<procs.length; i++)
			tempo = Math.max(tempo, procs[i].getTempoTotal());
			
		return tempo;
	}
	
	//retorna o numero do maior nivel
	public int getMaxNivel() {
		int num = 0;
		for (int i=0; i<procs.length; i++)
			for (int j=0; j<procs[i].getNumProcessos(); j++)
				num = Math.max(num, getProcesso(i, j).getNivel());
		
		return num;
	}
	
	public String toString() {
		String str = "";
		int t = getNumProcessadores();
		for (int i=0; i < t; i++)
			str=str+ "Processador "+i +": "+procs[i].toString()+(i<t-1?"\n":"");
			
		return str;
	}
	
	public boolean isEquivalent(Individuo indB) {
		return isEquivalent(this, indB);
	}
	
	//compara se os dois tem mesmo numero de processadores,
	// processos e niveis.
	public static boolean isEquivalent(Individuo indA, Individuo indB) {
		if (indA.getNumProcessadores() != indB.getNumProcessadores())
			return false;
			
		int numProcessos = indA.getNumProcessos();
		if (numProcessos != indB.getNumProcessos())
			return false;

		if (indA.getMaxNivel() != indB.getMaxNivel())
			return false;
	
		return true;
		
	}
	
}