#include <vcl.h>
#include <stdio.h>
//#include <stdlib.h>
#include <string.h>
#include <math.h>
//#include <limits.h>
#include <time.h>
#include <iostream.h>
//#include <conio.h>

#define MAX(x,y) ((x)<(y) ? (y) : (x))
#define  _N             40
#define  _PROC          5
#define  _PENALIDADE    50

#pragma hdrstop

/***************** Estruturas de controle *************************************/


struct no{       // lista dos nodos do grafo unidirecinado
        int item;   // n do grafo
        no* prox;   // proximo elemento do grafo
};

struct proc{
     int nro;
     int nroTasks;
     no* tasks;
};

struct exec{
     int task;
     int proc;
};


//no tasks[_N];
//exec processadores[_N];


////////////////////////////////// PROTOTIPOS //////////////////////////////////
void SA(int linhas, int colunas, int **s, int penalidade, no *grafo, int *fo, int nroTasks, int nroProc,
     double alfa, double temperatura_inicial, double temperatura_final, int SAmax);

void lerArquivoDados(no *vetor);
void insereLista(no *nodos, int item, int no2);
void iniciaVetorLista(no *vetor, int tamanho);
void iniciaVetorProcessadores(proc *vetor);
void iniciaMatriz(int **matriz, int linhas, int colunas);
void iniciaVetorProcessadores(exec *vetor);
void imprimeMatriz(int **matriz, int linhas, int colunas);
void imprimeVetorLista(no *vetor, int tamanho);
void imprimeVetorProcessador(int *vetor, int tamanho);
int verificaTask(int **matriz, int linhas, int colunas, int task);
int verificaElemProcessador(proc *vetor, int proc, int elem);
int verificaElemProcessador(exec *vetor, int proc, int elem);
void constroiAleatorio(int *vetor, int numTasks, int numProc);
void constroiMatrizAleatorio(int **matriz, int linhas, int colunas, int nroTasks);
int calculaFO(int **matriz, int linhas, int colunas, int numProc, no *grafo);
int *cria_vetor(int tam);
no *cria_vetor_nos(int tam);
void inicializa_vetor(int *vetor, int tam);
void atualiza_melhor_solucao(int **s, int **s_star, int linhas, int colunas);
void troca(int **s, int i1, int j1, int i2, int j2);
int calcula_inviabilidade(int peso_objetos, int capacidade);
void imprime_solucao(int **s, int linhas, int colunas);
double randomico(double min, double max);
int calcula_peso_objetos(int *s, int num_objetos, int *w);
void libera_vetor(int *vetor);
void libera_vetor(no *vetor);
void libera_matriz(int **matriz, int nlinhas);
void insereTaskFim(proc *vetor, int proc, int task);
int calculaAltura(exec *vetor, int proc);
int calculaInviabilidade(int task, int altura, no *grafo, int **matriz, int linhas, int colunas);
void imprimeVetorProcessos(int *vetor, int tamanho);
int **cria_matriz(int nlinhas, int ncolunas);
int elemAnteriores(int task, no *grafo);

void melhorResultado(int **matriz);


//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char* argv[]){
     int n = 40, colunas, linhas = 5, fo, **matriz;
     no *tasks;
     clock_t inicio, fim;
     srand((int) time(NULL));

     inicio = fim = clock();
     colunas = ((n / linhas) * 1.5) * 1.3;
     printf("%d\n\n",colunas);
//     getchar();

     tasks = cria_vetor_nos(40);
     matriz = cria_matriz(linhas, colunas);
     iniciaMatriz(matriz,linhas,colunas);

//     melhorResultado(matriz);

     iniciaVetorLista(tasks, 40);
     printf("Vou comecar a ler arquivo...\n");
     lerArquivoDados(tasks);
     printf("Vou comecar a imprimir arquivo...\n");
     imprimeVetorLista(tasks, 40);
//     imprimeVetorLista(tasks, 40);
//     getchar();
//     imprimeVetorLista(tasks, 40);
//     imprimeVetorLista(tasks, 40);
//     getchar();
     constroiMatrizAleatorio(matriz, linhas, colunas, n);
     imprimeMatriz(matriz,linhas,colunas);
//     getchar();
//     imprimeVetorLista(tasks, 40);
//     getchar();
     fo =  calculaFO(matriz,linhas, colunas,5,tasks);

     SA(linhas,colunas,matriz,50,tasks,&fo,40,5,0.99,100,0.001,2500);

     fim = clock();
     printf("\n\nValor da FO = %d", fo);
     cout << "\nTempo de processamento: " << (fim - inicio)/CLOCKS_PER_SEC << " seg.";
     getchar();

     libera_vetor(tasks);
     libera_matriz(matriz, linhas);
//        return 0;
}

void lerArquivoDados(no *vetor){
     int d1, d2;
     FILE* arq;

     if ((arq = fopen("taskgraph40.txt","rt")) == NULL){
          fprintf(stderr , "Nao foi possvel abrir o arquivo de dados");
          exit(1);
     }

     while (!feof(arq)){		// faz a leitura de todas as linhas do arq.
	     fscanf(arq, "%d %d", &d1, &d2);
		insereLista(vetor,d1, d2); // chama a funcao que insere os nos na lista adj. com:
	}
     fclose(arq);

}

void melhorResultado(int **matriz){

///////////////// Matriz de processos do melhor resultado /////////////////////////////////
     matriz[0][0] = 0;
     matriz[1][0] = 1;
     matriz[2][0] = 2;
     matriz[3][0] = 3;
     matriz[0][1] = 4;
     matriz[1][1] = 5;
     matriz[2][1] = 6;
     matriz[3][1] = 7;
     matriz[0][2] = 10;
     matriz[1][2] = 11;
     matriz[2][2] = 13;
     matriz[3][2] = 14;
     matriz[0][3] = 8;
     matriz[1][3] = 9;
     matriz[2][3] = 12;
     matriz[3][3] = 17;
     matriz[0][4] = 15;
     matriz[1][4] = 16;
     matriz[2][4] = 18;
     matriz[3][4] = 21;
     matriz[0][5] = 19;
     matriz[1][5] = 20;
     matriz[2][5] = 22;
     matriz[3][5] = 23;
     matriz[4][5] = 24;
     matriz[0][6] = 25;
     matriz[1][6] = 26;
     matriz[2][6] = 27;
     matriz[3][6] = 28;
     matriz[4][6] = 29;
     matriz[0][7] = 30;
     matriz[1][7] = 31;
     matriz[2][7] = 32;
     matriz[3][7] = 34;
     matriz[4][7] = 35;
     matriz[0][8] = 33;
     matriz[1][8] = 36;
     matriz[2][8] = 37;
     matriz[3][8] = 38;
     matriz[4][8] = 39;
}

void iniciaVetorLista(no *vetor, int tamanho){
        for (int i = 0; i < tamanho; i++){
                vetor[i].item = i;
                vetor[i].prox = NULL;
        }
}

void iniciaMatriz(int **matriz, int linhas, int colunas){
     for (int i = 0; i < linhas; i++){
          for (int j = 0; j < colunas; j++){
               matriz[i][j] = -1;
          }
     }
}

void imprimeVetorLista(no *vetor, int tamanho){
     no *aux;

     for (int i = 0; i < tamanho; i++){
          printf("Task %d ",vetor[i].item);
          aux = vetor[i].prox;
          while(aux != NULL){
               printf(" noAnt %d  ",aux->item);
               aux = aux->prox;
          }
          printf("\n");
     }
}

void imprimeVetorProcessador(int *vetor, int tamanho){

     for (int i = 0; i < tamanho; i++){
          if (vetor[i] < 0)
               printf("\nProcessador %d: ", -1 * vetor[i]);
          else
               printf("%d ", vetor[i]);
     }
}

void imprimeMatriz(int **matriz, int linhas, int colunas){
     for (int i = 0; i < linhas; i++){
          cout << "\nProcessador " << i << ": ";
          for (int j = 0; j < colunas; j++){
               if (matriz[i][j] >= 0 && matriz[i][j] < 10)
                    cout << " " << matriz[i][j] << " ";
               else
                    cout << matriz[i][j] << " ";
          }
     }
     cout << "\n";
}

void iniciaVetor(int *vetor, int tamanho){
        for (int i = 0; i < tamanho; i++){
                vetor[i] = 0;
        }
}

void iniciaVetorProcessadores(proc *vetor){
        for (int i = 0; i < _PROC; i++){
                vetor[i].nro = i;
                vetor[i].nroTasks = 0;
                vetor[i].tasks = NULL;
        }
}

void insereLista(no *nodos, int item, int no2){
        no *aux, *ant;

        aux = nodos[item].prox;
        ant = NULL;

        while(aux != NULL){
                ant = aux;
                aux = aux->prox;
        }


        if (no2 != -1){
          if (ant == NULL){
               nodos[item].prox = (no *) malloc(sizeof(no));
               nodos[item].prox->item = no2;
               nodos[item].prox->prox = NULL;
          }
          else{
               ant->prox = (no *) malloc(sizeof(no));
               ant->prox->item = no2;
               ant->prox->prox = NULL;
          }
        }
}

int verificaTask(int **matriz, int linhas, int colunas, int task){

     for (int i = 0; i < linhas; i++){
          for (int j = 0; j < colunas; j++){
               if (matriz[i][j] == task)
                    return j;
          }
     }
     return -1;
}

int verificaElemProcessador(int *vetor, int tamanho, int proc, int elem){
     int cont = -1;
     proc *= -1;

     for (int i = 0; i < tamanho; i++){
          if (vetor[i] == proc){
               cont++;
               if (vetor[i] == elem)
                    return cont;
          }
     }

     return -1;
}

int verificaElemProcessador(proc *vetor,int proc, int elem){
     int cont = -1;
     no *aux;

     aux = vetor[proc].tasks;
     while(aux != NULL){
          cont++;
          if (aux->item == elem) return cont;
     }

     return -1;
}

int calculaFO(int **matriz, int linhas, int colunas, int numProc, no *grafo){
        int fo = 0;
        int maiorAltura = 0;
        int ok = 0;
        int *alturas = cria_vetor(numProc);

        // vou inicializar vetor de alturas
        for (int i = 0; i < numProc; i++) alturas[i] = 0;

        // vou calcular as alturas e criar vetor de processadores
        for (int i = 0; i < linhas; i++){
          ok = 0;
          for(int j = colunas - 1; j >= 0; j--){
               if (matriz[i][j] != -1) ok = 1;
               if (ok == 1) alturas[i]++;
          }
        }

        // vou achar a maior altura
        for (int i = 0; i < numProc; i++){
          if (alturas[i] > maiorAltura) maiorAltura = alturas[i];
        }

        // vou iniciar o valor da fo. caso nao haja inviabilidade, esse eh o valor dela
        fo = maiorAltura;

        // vou procurar se existe alguma inviabilidade
        // caso exista eh adicioana uma penalidade por cada inviabilidade a fo
        for (int i = 0; i < linhas; i++){
          for(int j = 0; j < colunas; j++){
               if (matriz[i][j] >= 0){
                    fo += _PENALIDADE * calculaInviabilidade(matriz[i][j], j, grafo, matriz, linhas, colunas);
                    int aux = elemAnteriores(matriz[i][j], grafo);
                    if ( j <= aux )
                        fo += aux * _PENALIDADE * 2;
               }
          }
        }
        libera_vetor(alturas);
        return fo;
}

int elemAnteriores(int task, no *grafo){
        int elem = 0;
        no *aux = grafo[task].prox;
        while(aux != NULL){
                elem++;
                aux = aux->prox;
        }
        return elem;
}

int calculaInviabilidade(int task, int altura, no *grafo, int **matriz, int linhas, int colunas){
     int inv = 0;
     no *aux = grafo[task].prox;
     if (aux == NULL) return inv;
     while(aux != NULL){
          if (altura <= (verificaTask(matriz, linhas, colunas, aux->item)))
               inv = 1 + calculaInviabilidade(aux->item, altura, grafo, matriz, linhas, colunas);
          else
               inv = calculaInviabilidade(aux->item, altura, grafo, matriz, linhas, colunas);
          aux = aux->prox;
     }
     return inv;
}

void constroiAleatorio(int *vetor, int numTasks, int numProc){

     //constroi uma solucao aleatoria, alocando todas as tarefas ao primeiro processador
     int i = -numProc;
     while (i < numTasks){
          vetor[i + numProc] = i;
          i++;
     }

//     for (int i = 0; i < numProc; i++) vetor[i] = -(i + 1);
//     int cont = numTasks - 1;
//     for (int i = 0; i < numTasks; i++){ vetor[i + 5] = cont; cont--;}
}

void constroiMatrizAleatorio(int **matriz, int linhas, int colunas, int nroTasks){
     int contL = 0, contC = 0;

     for (int i = 0; i < nroTasks; i++){
          if (contC >= colunas){
               contL++;
               contC = 0;
          }
          matriz[contL][contC] = i;
          contC++;
     }
}

void insereTaskFim(proc *vetor, int proc,int task){
     no *aux, elem;
     elem.item = task;
     elem.prox = NULL;
     aux = vetor[proc].tasks;
     while (aux != NULL) aux = aux->prox;
     aux->prox = &elem;
}

int calculaAltura(int *vetor, int proc, int tamanho){
     int cont = 0;
     proc *= -1;

     for (int i = 0; i < tamanho; i++)
          if (vetor[i] == proc){
               i++;
               while(vetor[i] >= 0 && i < tamanho){
                    cont++;
                    i++;
               }
               return cont;
          }

     return cont;
}


int *cria_vetor(int tam){
  int *vetor;

  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}

no *cria_vetor_nos(int tam){
     no *vetor;

     vetor = (no *) malloc(tam*sizeof(no));
     if (!vetor){
     printf("Falta memoria para alocar o vetor de ponteiros de nos");
     exit(1);
  }
  return vetor;
}

//inicializa vetor do SA
void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++) vetor[j] = 0;
}

/* atualiza a melhor solucao */
void atualiza_melhor_solucao(int **s, int **s_star, int linhas, int colunas){

   for (int i = 0; i < linhas; i++){
     for (int j = 0; j < colunas; j++)
        s_star[i][j] = s[i][j];
   }
}

/* insere ou retira o objeto j do processador */
void troca(int **s, int i1, int j1, int i2, int j2){
     int temp;

     temp = s[i1][j1];
     s[i1][j1] = s[i2][j2];
     s[i2][j2] = temp;
}

int calcula_inviabilidade(int peso_objetos, int capacidade)
{
    return MAX(0, peso_objetos - capacidade);
}

/* imprime a solucao */
void imprime_solucao(int **s, int linhas, int colunas)
{
    imprimeMatriz(s, linhas, colunas);
}

double randomico(double min, double max)
{
  if (min == max) return min;
  return ((double) (rand()%10000/10000.0)*(max-min) + min);
}

/* calcula o peso dos objetos na mochila */
int calcula_peso_objetos(int *s, int num_objetos, int *w)
{
    int j;
    int peso = 0;

    for (j=0; j<num_objetos; j++){
    	if (s[j]) {
	   peso += w[j];
        }
    }
    return peso;
}

int **cria_matriz(int nlinhas, int ncolunas)
{
  register int i;
  int **matriz;

  matriz = (int **) malloc(nlinhas*sizeof(int *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (int *) malloc(ncolunas*sizeof(int));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}


void libera_vetor(int *vetor){
  free(vetor);
}

void libera_vetor(no *vetor){
     free(vetor);
}

void libera_matriz(int **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((int *) matriz[i]);
  free((int *) matriz);
}



void SA(int linhas, int colunas, int **s, int penalidade, no *grafo, int *fo, int nroTasks, int nroProc,
     double alfa, double temperatura_inicial, double temperatura_final, int SAmax)
{
     double x;              // numero aleatorio entre ZERO e UM
     double temperatura;    // temperatura corrente
     int iter;              // numero de iteracoes na temperatura corrente
     int num_mudancas_temp; // numero de mudancas de temperatura
     int posicao_escolhida11; // objeto escolhido
     int posicao_escolhida12;
     int posicao_escolhida21;
     int posicao_escolhida22;
     int delta;             // variacao de energia
     int fo_star;
     int **s_star;

     s_star = cria_matriz(linhas, colunas);
     iniciaMatriz(s_star, linhas, colunas);
     atualiza_melhor_solucao(s, s_star, linhas, colunas);
     fo_star = *fo;
     temperatura = temperatura_inicial;
     num_mudancas_temp = 0;
     printf("Solucao inicial: fo corrente = %d\n",*fo);
     getchar();

     /*enquanto o sistema nao congelar faca */
     while (temperatura > temperatura_final) {
          iter = 0;
          /* enquanto o equilibrio termico nao for atingido faca */
          while (iter < SAmax){
               iter++;
               /* escolha um vizinho qualquer */
               posicao_escolhida11 = random(linhas);
               posicao_escolhida12 = random(colunas);
               posicao_escolhida21 = random(linhas);
               posicao_escolhida22 = random(colunas);
               //imprime_solucao(s,n);

//               printf("Vou tentar trocar a tarefa %d com a tarefa %d \n", s_star[posicao_escolhida11][posicao_escolhida12], s_star[posicao_escolhida21][posicao_escolhida22]);

               troca(s, posicao_escolhida11, posicao_escolhida12, posicao_escolhida21, posicao_escolhida22);

               /* calcule a variacao de energia */
               int fo_corrente = calculaFO(s, linhas, colunas, nroProc, grafo);

//             cout << "\nfo corrente: " << fo_corrente;

               delta = fo_corrente - *fo;

//             printf("variacao de energia = %3d \n",delta);
//               imprime_solucao(s,linhas,colunas);

               /* se houver melhora, aceite o vizinho */
               if (delta < 0){

                    printf("Solucao de melhora: fo corrente = %d\n",*fo);
                    (*fo) += delta;
//                    getchar();

                    if (*fo < fo_star){
                              atualiza_melhor_solucao(s, s_star, linhas, colunas);
                              fo_star = *fo;
//                              imprime_solucao(s_star,linhas, colunas);
                              printf("********** fo_star = %3d \n",fo_star);
                              cout << "temperatura = " << temperatura << "\n\n";
//                              getchar();
                    }
                    else {
                         /* se houver piora, aceite o vizinho com uma determinada probabilidade */
                         x = randomico(0,1);
                         if (x < exp(delta/temperatura)){
                              (*fo) += delta;
                              printf("Solucao de piora: fo corrente = %d\n",*fo);
//                              getchar();
                         }
                         else {
                              /* Se o vizinho nao foi aceito, desfaca o movimento */
                              troca(s, posicao_escolhida11, posicao_escolhida12, posicao_escolhida21, posicao_escolhida22);
                         }
                    }
               }
          }
          /* decresca a temperatura */
          temperatura *= alfa;
//        printf("Temperatura atual = %10.3f\n", temperatura);
          num_mudancas_temp += 1;
     }

     printf("********* Melhor Solucao obtida pelo SA ************** \n");
     imprime_solucao(s_star,linhas, colunas);
     printf("funcao objetivo = %3d \n",fo_star);
     printf("Num. max. de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);
     printf("Numero de solucoes existentes = %.0f \n", exp(nroTasks*log(2)));
     printf("****************************************************** \n");
     atualiza_melhor_solucao(s_star, s, linhas, colunas);
     (*fo) = fo_star;
     libera_matriz(s_star, linhas);
//     getchar();
}

//--------------------------------------------------------------------------- 
