#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>

#define MAX(x,y) ((x)<(y) ? (y) : (x))

#pragma hdrstop

int *cria_vetor(int tam);
void libera_vetor(int *vetor);
void le_arq_vetor_denso(char nomearq[], int *vetor);
void constroi_solucao_aleatoria(int *s, int num_objetos, int num_mochilas);
void imprime_solucao(int *s, int num_objetos);
int* calcula_fo(int *s, int num_objetos, int *p, int num_mochilas, int *inviabilidades, int penalidade);
int *calcula_peso_objetos(int *s, int num_objetos, int *w, int num_mochilas);
int *calcula_inviabilidade(int *peso_objetos, int *capacidade, int num_mochilas);
double randomico(double min, double max);
void atualiza_melhor_solucao(int *s, int *s_star, int num_objetos);
int calcula_penalidade(int *w, int num_objetos);
void inicializa_vetor(int *vetor, int tam);
int menu_principal(void);
void imprimePesosInviabilidadesFos(int *pesos, int *inviabilidades, int *fom,int num_mochilas);
void imprime_fo(char nomearq[], float tempo, int fo, int iteracao);
int tempo1=0, tempo2=0;

void SA(int num_objetos,
        int *s,
        int *p,
        int *w,
        int num_mochilas,
        int *b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax);

int ProcuraDelta(int num_objetos,
        int *s,
        int *p,
        int *w,
        int num_mochilas,
        int *b,
        int penalidade,
        int *peso_objetos,
        int *fom,
        int *inv);


//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char **argv)
{
  int n;           // numero de objetos
  int m;           // numero de mochilas
  int *b;           // capacidade das mochilas
  int *s;          // vetor solucao corrente
  int *s_star;     // vetor melhor solucao
  int *w;          // vetor de peso de cada objeto
  int *p;          // vetor de beneficio de cada objeto
  int fo;          // funcao objetivo corrente
  int fo_star;     // melhor funcao objetivo
  int *fom;        // funcao objetiva das mochilas corrente
  int *fom_star;   // melhor funcao objetiva das mochilas
  int *inv;         // quantidade de inviabilidade da solucao corrente
  int penalidade;  // penalidade por superar a capacidade da mochila
  int *peso_objetos;// peso dos objetos na solucao corrente para cada mochila

  int choice;

  int delta;                 // variacao de energia
  double temperatura_inicial;// temperatura inicial de partida do sistema
  double temperatura_final;  // temperatura de congelamento do sistema
  double alfa;               // taxa de resfriamento
  int SAmax;                 // numero maximo de iteracoes em uma dada temperatura




//  srand(1000); // pega o numero 1000 como semente de numeros aleatorios
  srand((unsigned) time(NULL)); // pega a hora do relogio como semente
  n = 50;
  m = 5;

  s = cria_vetor(n);
  s_star = cria_vetor(n);
  w = cria_vetor(n);
  p = cria_vetor(n);
  b = cria_vetor(m);
  fom = cria_vetor(m);
  fom_star = cria_vetor(m);
  inicializa_vetor(w,n);
  inicializa_vetor(p,n);
  inicializa_vetor(b,m);
  inicializa_vetor(fom,m);

  le_arq_vetor_denso("peso50.txt", w);
  le_arq_vetor_denso("beneficio50.txt", p);
  le_arq_vetor_denso("mochila5.txt", b);
  penalidade = calcula_penalidade(w, n);
  fo = 0;
  fo_star = - INT_MAX;
  for (int j=0; j<m; j++) fom_star[j] = - INT_MAX;


  do {
    choice = menu_principal();
    switch (choice) {
    case 1: /* Geracao de uma solucao inicial */
            /* Geracao aleatoria de uma solucao inicial */
                 constroi_solucao_aleatoria(s, n, m);
                 printf("Solucao aleatoria:\n");
                 imprime_solucao(s,n);
                 peso_objetos = calcula_peso_objetos(s, n, w, m);
                 inv = calcula_inviabilidade(peso_objetos, b, m);
                 fom = calcula_fo(s, n, p, m, inv, penalidade);
                 fo = 0;
    		 for (int j=0; j<m; j++) fo += fom[j];
                 imprimePesosInviabilidadesFos(peso_objetos,inv,fom,m);
                 printf("funcao objetivo = %3d \n",fo);
           break;
    case 2: /* Simulated Annealing */
          if (fo != 0) {
            alfa = 0.97;
            temperatura_inicial = 100;
            temperatura_final = 0.1;
            SAmax = n/2;
            tempo1 = time(NULL);
            SA(n,s,p,w,m,b,penalidade,peso_objetos,fom,inv,alfa,temperatura_inicial,temperatura_final,SAmax);
            tempo2 = time(NULL);
            printf("Tempo de espera: %d s", tempo2 - tempo1);
          }
          break;
    case 3: /* Procurando maior delta */
          if (fo != 0) {
            tempo1 = time(NULL);
            int num=0;
            num = ProcuraDelta(n,s,p,w,m,b,penalidade,peso_objetos,fom,inv);
            printf("%d/n",num);
            tempo2 = time(NULL);
            printf("Tempo de espera: %d s", tempo2 - tempo1);
          }
          else {
            printf("\n ----- Gere uma solucao inicial -------\n");
            getchar();
          }
          break;
    case 0: /* Saida */
          break;
    default:
          break;
    }
  } while (choice != 0);


  libera_vetor(s);
  libera_vetor(s_star);
  libera_vetor(w);
  libera_vetor(p);
  libera_vetor(b);
  libera_vetor(fom);
  libera_vetor(fom_star);

  return 0;
} /* fim do programa principal */

//---------------------------------------------------------------------------

/* Imprime os pesos, inviabilidades e Fo que estao em cada mochila*/
void imprimePesosInviabilidadesFos(int *pesos,int *inviabilidades, int *fom, int num_mochilas)
{
    for (int j=0; j<num_mochilas; j++) printf("Mochila %d : Peso-> %d   Inviabilidade-> %d   Fo-> %d\n", j+1, pesos[j],inviabilidades[j],fom[j]);
}


/* cria memoria para um vetor de tam posicoes */
int *cria_vetor(int tam)
{
  int *vetor;

  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}


/* libera memoria de um vetor */
void libera_vetor(int *vetor)
{
  free(vetor);
}


/* Nesta leitura, vetor[j] = valor para todo j=0...n */
void le_arq_vetor_denso(char nomearq[], int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  j = 0;
  while (!feof(arquivo)){
    fscanf(arquivo, "%d", &valor);
    vetor[j] = valor;
    j++;
  }
  fclose(arquivo);
}


/* constroi uma solucao inicial aleatoria */
void constroi_solucao_aleatoria(int *s, int num_objetos, int num_mochilas)
{
    for (int j=0; j<num_objetos; j++) s[j] = random(num_mochilas+1);
}


/* imprime a solucao */
void imprime_solucao(int *s, int num_objetos)
{
    for (int j=0; j<num_objetos; j++) printf("s[%2d]=%d \n",j,s[j]);
}


/* calcula a funcao objetivo */
int *calcula_fo(int *s, int num_objetos, int *p, int num_mochilas, int *inviabilidades, int penalidade)
{
    int j;
    int *beneficios;
    int *fo1;
    beneficios = cria_vetor(num_mochilas);
    inicializa_vetor(beneficios, num_mochilas);
    fo1 = cria_vetor(num_mochilas);
    inicializa_vetor(fo1, num_mochilas);

    for (j=0; j<num_objetos; j++){
    	if (s[j] != 0)
           { beneficios[s[j]-1] += p[j];}
    }
    for ( j=0; j<num_mochilas; j++){
       fo1[j] = beneficios[j] - penalidade * inviabilidades[j];
    }

    return fo1;
}


void imprime_fo(char nomearq[], float tempo, int fo, int iteracao)
{
    FILE *arquivo;
    arquivo = fopen(nomearq,"a+");

    if (!arquivo){
        printf("O arquivo %s nao pode ser aberto",nomearq);
        getchar();
        exit(1);
    }
    fprintf(arquivo,"%4.2f\t  %4d\t  %5d\n",tempo, iteracao, fo);
    fclose(arquivo);
}


/* calcula o peso dos objetos na mochila */
int *calcula_peso_objetos(int *s, int num_objetos, int *w, int num_mochilas)
{
    int j;
    int *peso;
    peso = cria_vetor(num_mochilas);
    inicializa_vetor(peso,num_mochilas);

    for (j=0; j<num_objetos; j++){
    	if (s[j] != 0) {
	   peso[s[j]-1] += w[j];
        }
    }
    return peso;
}


/* calcula o excesso de peso na mochila */
int *calcula_inviabilidade(int *peso_objetos, int *capacidade, int num_mochilas)
{
    int j;
    int *invib;
    invib = cria_vetor(num_mochilas);
    inicializa_vetor(invib,num_mochilas);

    for (j=0; j<num_mochilas; j++){
       invib[j] = MAX(0, peso_objetos[j] - capacidade[j]);
    }
    return invib;
}


/* Gera numero aleatorio entre min e max */
double randomico(double min, double max)
{
  if (min == max) return min;
  return ((double) (rand()%10000/10000.0)*(max-min) + min);
}


/* atualiza a melhor solucao */
void atualiza_melhor_solucao(int *s, int *s_star, int num_objetos)
{
   for (int j=0; j<num_objetos; j++) s_star[j] = s[j];
}


/* calcula a penalidade por exceder a capacidade da mochila */
int calcula_penalidade(int *w, int num_objetos)
{
    int penalidade = 0;
    for (int j=0; j<num_objetos; j++) penalidade += w[j];
    return penalidade;
}


void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++) vetor[j] = 0;
}


/* Menu principal */
int menu_principal(void)
{
  int escolha;

  do {
    printf("\n************************************************* \n");
    printf("         1. Gere solucao inicial \n");
    printf("         2. Simulated Annealing \n");
    printf("         0. Sair \n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 0 || escolha > 3);
  return escolha;
}

void SA(int num_objetos,
        int *s,
        int *p,
        int *w,
        int num_mochilas,
        int *b,
        int penalidade,
        int *peso_objetos,
        int *fom,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax)
{
    double temperatura;    // temperatura corrente
    int iter;              // numero de iteracoes na temperatura corrente
    int num_mudancas_temp; // numero de mudancas de temperatura
    int posicao_escolhida; // objeto escolhido
    int troca_mochila;     // nova mochila do objeto escolhido
    int delta;             // variacao de energia
    int *fom_star;         // funo objetiva da melhor soluo
    int fo_star;           // soma das funes objetivas da melhor soluo
    int fo;                // soma das funes objetivas das mochilas
    int *fom_vizinho;       // fom do vizinho
    int fo_vizinho;
    int *s_star;           // melhor soluo at ento
    int *peso_modificado;  // pesos modificados na mochila.
    int *inv_vizinho;       //calcula as inviabilidades do vizinho gerado
    int x;
    int *s_vizinho;

    fo = 0;
    for (int j=0; j<num_mochilas; j++) fo += fom[j];
    fo_star = fo;

    temperatura = temperatura_inicial;
    num_mudancas_temp = 0;
    printf("Solucao inicial:\n");
    imprimePesosInviabilidadesFos(peso_objetos,inv,fom,num_mochilas);

    s_star = cria_vetor(num_objetos);
    inicializa_vetor(s_star,num_objetos);
    atualiza_melhor_solucao(s, s_star, num_objetos);

    fom_star = cria_vetor(num_mochilas);
    inicializa_vetor(fom_star,num_mochilas);
    atualiza_melhor_solucao(fom, fom_star, num_mochilas);

    peso_modificado = cria_vetor(num_mochilas);
    inicializa_vetor(peso_modificado,num_mochilas);

    s_vizinho = cria_vetor(num_objetos);
    inicializa_vetor(s_vizinho,num_objetos);

//    getchar();

    /* enquanto o sistema nao congelar faca */
    while (temperatura > temperatura_final) {
       iter = 0;
       /* enquanto o equilibrio termico nao for atingido faca */
       while (iter < SAmax){
          iter++;

	  /* escolha um objeto qualquer */
	  posicao_escolhida = random(num_objetos);
 	  /* e qual sera a mudanca de mochilas */
	  do {
	      troca_mochila = random(num_mochilas+1);
	  } while (troca_mochila == s[posicao_escolhida]);

//          imprime_solucao(s,n);
          if (s[posicao_escolhida]==0)
              printf("Vou tentar incluir o objeto %d de peso %d na mochila %d \n", posicao_escolhida, w[posicao_escolhida], troca_mochila);
              else
                if (troca_mochila == 0)
                   printf("Vou tentar retirar o objeto %d de peso %d da mochila %d  \n", posicao_escolhida, w[posicao_escolhida],s[posicao_escolhida]);
                   else printf("Vou tentar retirar o objeto %d de peso %d da mochila %d e incluir na mochila %d \n",posicao_escolhida, w[posicao_escolhida], s[posicao_escolhida], troca_mochila);

  	/* calcule a variacao de energia se efetuada a troca*/
   	  atualiza_melhor_solucao(peso_objetos,peso_modificado,num_mochilas);
          if (s[posicao_escolhida] != 0 ) peso_modificado[s[posicao_escolhida]-1] = peso_objetos[s[posicao_escolhida]-1] - w[posicao_escolhida];
          if (troca_mochila != 0) peso_modificado[troca_mochila -1] = peso_objetos[troca_mochila -1] + w[posicao_escolhida];
          inv_vizinho = calcula_inviabilidade(peso_modificado,b,num_mochilas);

          atualiza_melhor_solucao(s, s_vizinho,num_objetos);
          s_vizinho[posicao_escolhida] = troca_mochila;
          fom_vizinho = calcula_fo(s_vizinho, num_objetos, p, num_mochilas, inv_vizinho, penalidade);
          fo_vizinho = 0;
          for (int j=0; j<num_mochilas; j++) fo_vizinho += fom_vizinho[j];

          delta = fo_vizinho - fo  ;

    	  printf("variacao de energia = %3d \n",delta);

	  	/* se houver melhora, aceite o vizinho */
	  if (delta > 0){
	     fo += delta;
             atualiza_melhor_solucao(peso_modificado, peso_objetos,num_mochilas);
             atualiza_melhor_solucao(inv_vizinho, inv, num_mochilas);
             atualiza_melhor_solucao(fom_vizinho, fom, num_mochilas);
             // efetuada a troca
             s[posicao_escolhida] = troca_mochila;
             printf("Solucao de melhora: fo corrente = %d \n",fo);
             imprimePesosInviabilidadesFos(peso_objetos,inv,fom,num_mochilas);

//             getchar();

             if (fo > fo_star){
	  	atualiza_melhor_solucao(s, s_star, num_objetos);
		fo_star = fo;
                atualiza_melhor_solucao(fom, fom_star, num_mochilas);
	  	imprime_solucao(s_star,num_objetos);
                printf("********** fo_star = %3d \n",fo_star);
//                getchar();
             }
	  }
	  else {
	      /* se houver piora, aceite o vizinho com uma determinada probabilidade */
	      x = randomico(0,1);
              if (x < exp(delta/temperatura)){
	       	 fo += delta;
                 atualiza_melhor_solucao(peso_modificado, peso_objetos,num_mochilas);
                 atualiza_melhor_solucao(inv_vizinho, inv, num_mochilas);
                 atualiza_melhor_solucao(fom_vizinho, fom, num_mochilas);
                // efetuada a troca
                s[posicao_escolhida] = troca_mochila;
                printf("Solucao de piora: fo corrente = %d   \n",fo);
                imprimePesosInviabilidadesFos(peso_objetos,inv,fom,num_mochilas);
//                 getchar();
              }
	  }
        }
		/* decresca a temperatura */
        temperatura *= alfa;
        printf("Temperatura atual = %10.3f\n", temperatura);
        num_mudancas_temp += 1;
    }

    printf("********* Melhor Solucao obtida pelo SA ************** \n");
    peso_objetos = calcula_peso_objetos(s_star, num_objetos, w, num_mochilas);
    inv = calcula_inviabilidade(peso_objetos, b, num_mochilas);
    fom_star = calcula_fo(s_star, num_objetos, p, num_mochilas, inv, penalidade);
    fo_star = 0;
    for (int j=0; j<num_mochilas; j++) fo_star += fom_star[j];
    imprimePesosInviabilidadesFos(peso_objetos,inv,fom_star,num_mochilas);
    printf("funcao objetivo = %3d \n",fo_star);
    printf("Num. max. de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);
    printf("****************************************************** \n");
    atualiza_melhor_solucao(s_star, s, num_objetos);
    imprime_solucao(s_star,num_objetos);
    libera_vetor(s_star);
    getchar();
}



int ProcuraDelta(int num_objetos,
        int *s,
        int *p,
        int *w,
        int num_mochilas,
        int *b,
        int penalidade,
        int *peso_objetos,
        int *fom,
        int *inv)
{
    int iter;              // numero de iteracoes na temperatura corrente
    int posicao_escolhida; // objeto escolhido
    int troca_mochila;     // nova mochila do objeto escolhido
    int delta;             // variacao de energia
    int fo;                // soma das funes objetivas das mochilas
    int *fom_vizinho;       // fom do vizinho
    int fo_vizinho;
    int *s_vizinho;
    int *peso_modificado;  // pesos modificados na mochila.
    int *inv_vizinho;       //calcula as inviabilidades do vizinho gerado
    int maior_delta=0;
    fo = 0;
    for (int j=0; j<num_mochilas; j++) fo += fom[j];

    printf("Solucao inicial:\n");
    imprimePesosInviabilidadesFos(peso_objetos,inv,fom,num_mochilas);

    peso_modificado = cria_vetor(num_mochilas);
    inicializa_vetor(peso_modificado,num_mochilas);

    s_vizinho = cria_vetor(num_objetos);
    inicializa_vetor(s_vizinho,num_objetos);

//    getchar();


    for (int j=0; j<1000; j++) {
	  /* escolha um objeto qualquer */
	  posicao_escolhida = random(num_objetos);
 	  /* e qual sera a mudanca de mochilas */
	  do {
	      troca_mochila = random(num_mochilas+1);
	  } while (troca_mochila == s[posicao_escolhida]);

  	/* calcule a variacao de energia se efetuada a troca*/
   	  atualiza_melhor_solucao(peso_objetos,peso_modificado,num_mochilas);
          if (s[posicao_escolhida] != 0 ) peso_modificado[s[posicao_escolhida]-1] = peso_objetos[s[posicao_escolhida]-1] - w[posicao_escolhida];
          if (troca_mochila != 0) peso_modificado[troca_mochila -1] = peso_objetos[troca_mochila -1] + w[posicao_escolhida];
          inv_vizinho = calcula_inviabilidade(peso_modificado,b,num_mochilas);

          atualiza_melhor_solucao(s, s_vizinho,num_objetos);
          s_vizinho[posicao_escolhida] = troca_mochila;
          fom_vizinho = calcula_fo(s_vizinho, num_objetos, p, num_mochilas, inv_vizinho, penalidade);
          fo_vizinho = 0;
          for (int j=0; j<num_mochilas; j++) fo_vizinho += fom_vizinho[j];

          delta = fo_vizinho - fo  ;
          if (abs(delta) > maior_delta) maior_delta = abs(delta);
    	  printf("variacao de energia = %3d \n",delta);
	  	/* se houver melhora, aceite o vizinho */

    }
    getchar();
    return maior_delta;
}
